/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.SPISpec;
import java.util.List;

public class SPIMasterSettingInfo {
    public static final int SPI_RAW_CS_MODE_FORCED = 0;
    public static final int SPI_RAW_CS_MODE_FRAME = 1;
    public static final int SPI_RAW_CLOCK_MODE_HIGH_RISING = 0;
    public static final int SPI_RAW_CLOCK_MODE_HIGH_FALLING = 1;
    public static final int SPI_RAW_CLOCK_MODE_LOW_RISING = 2;
    public static final int SPI_RAW_CLOCK_MODE_LOW_FALLING = 3;
    public static final int SPI_RAW_FRAME_SIZE_8_BITS = 0;
    public static final int SPI_RAW_FRAME_SIZE_16_BITS = 1;
    public static final int SPI_RAW_FRAME_SIZE_32_BITS = 2;
    public static final int SPI_RAW_FRAME_SIZE_64_BITS = 3;
    public static final int DELAY_TYPE_CS_HEAD = 0;
    public static final int DELAY_TYPE_CS_TAIL = 1;
    public static final int DELAY_TYPE_NEXT_TRANSMIT = 2;
    long frequency;
    int clockMode;
    int csMode;
    int frameSize;
    int[] delay = new int[3];

    public void setClockFrequency(long l) {
        List<SPISpec> list = ConnectionProperties.getInstance().getSPISpecList();
        List<Long> list2 = list.get(0).getClockFrequencyList();
        if (!list2.contains(l)) {
            throw new IllegalArgumentException();
        }
        this.frequency = l;
    }

    public void setClockMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.clockMode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setCsMode(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.csMode = n;
    }

    public void setBitsPerFrame(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.frameSize = n;
    }

    public void setDelay(int n, int n2) throws ConnectionException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (n2 < 0 || (long)n2 > ConnectionProperties.getInstance().getSPIMaxDelay()) {
            throw new IllegalArgumentException();
        }
        this.delay[n] = n2;
    }

    long getClockFrequency() {
        return this.frequency;
    }

    int getClockMode() {
        return this.clockMode;
    }

    int getCsMode() {
        return this.csMode;
    }

    int getBitsPerFrame() {
        return this.frameSize;
    }

    int getDelay(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.delay[n];
    }
}

