/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.SPICombinedFormatData;
import com.docomo_um.module.connection.SPIDevice;
import com.docomo_um.module.connection.SPIFunctions;
import com.docomo_um.module.connection.SPIMasterSettingInfo;
import com.docomo_um.module.connection.SPISpec;
import java.io.IOException;

public class SPIMaster
extends SPIDevice {
    private SPIMasterSettingInfo settingInfo;
    private SPISpec spec;

    SPIMaster(SPISpec sPISpec, SPIMasterSettingInfo sPIMasterSettingInfo) {
        if (sPISpec.getCommMode() == 2) {
            throw new IllegalArgumentException();
        }
        this.spec = sPISpec;
        this.settingInfo = sPIMasterSettingInfo;
    }

    public void start() {
        SPIFunctions.start();
    }

    public void stop() {
        SPIFunctions.stop();
    }

    public void updateSettingInfo(SPIMasterSettingInfo sPIMasterSettingInfo) throws ConnectionException {
        if (sPIMasterSettingInfo == null) {
            throw new NullPointerException();
        }
        if (SPIFunctions.isStarted()) {
            throw new IllegalStateException();
        }
        this.settingInfo = sPIMasterSettingInfo;
    }

    public byte[] sendFullduplexFormat(byte[] byArray) throws IOException, ConnectionException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (!SPIFunctions.isStarted()) {
            throw new IllegalStateException();
        }
        return SPIFunctions.sendFullduplexFormat(byArray);
    }

    @Override
    public SPICombinedFormatData[] sendCombinedFormat(SPICombinedFormatData[] sPICombinedFormatDataArray) throws IOException, ConnectionException {
        if (sPICombinedFormatDataArray == null) {
            throw new NullPointerException();
        }
        if (sPICombinedFormatDataArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (!SPIFunctions.isStarted()) {
            throw new IllegalStateException();
        }
        return SPIFunctions.sendCombinedFormat(sPICombinedFormatDataArray);
    }
}

