/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.SPICombinedFormatData;
import com.docomo_um.module.connection.SPIDevice;
import com.docomo_um.module.connection.SPIListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.co.aplix.extra.util.HexUtil;

public class SPIFunctions {
    private static SPIListener spiListener = null;
    private static SPICommCombinedThread combinedThread = null;
    private static SPICommFullduplexThread fullduplexThread = null;
    private static SPIDevice spiDevice = null;
    static boolean busy = false;
    static Object lockObj = new Object();
    static SPIInputStream is = null;
    static SPIOutputStream os = null;
    static boolean started = false;
    static boolean interrupted = false;

    public static void finalize() {
        try {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setSPIDevice(SPIDevice sPIDevice) {
        spiDevice = sPIDevice;
        is = new SPIInputStream();
        os = new SPIOutputStream();
    }

    public static void setSPIListener(SPIListener sPIListener) throws ConnectionException {
        spiListener = sPIListener;
    }

    public static void start() {
        if (!started) {
            started = true;
            if (spiListener != null && spiDevice != null) {
                spiListener.onChangedStatus(spiDevice, true);
            }
        }
    }

    public static void stop() {
        if (started) {
            started = false;
            if (spiListener != null && spiDevice != null) {
                spiListener.onChangedStatus(spiDevice, false);
            }
            interrupted = true;
            if (fullduplexThread != null) {
                fullduplexThread.interrupt();
            }
            if (combinedThread != null) {
                combinedThread.interrupt();
            }
        }
    }

    public static boolean isStarted() {
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sendFullduplexFormat(byte[] byArray) throws IOException, ConnectionException {
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        Object object = lockObj;
        synchronized (object) {
            if (busy) {
                throw new IllegalStateException();
            }
            busy = true;
        }
        interrupted = false;
        fullduplexThread = new SPICommFullduplexThread(byArray);
        fullduplexThread.start();
        try {
            fullduplexThread.join();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException();
        }
        finally {
            Object object2 = lockObj;
            synchronized (object2) {
                busy = false;
            }
        }
        if (interrupted) {
            throw new IOException();
        }
        return fullduplexThread.getReceivedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SPICombinedFormatData[] sendCombinedFormat(SPICombinedFormatData[] sPICombinedFormatDataArray) throws IOException, ConnectionException {
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        Object object = lockObj;
        synchronized (object) {
            if (busy) {
                throw new IllegalStateException();
            }
            busy = true;
        }
        interrupted = false;
        combinedThread = new SPICommCombinedThread(sPICombinedFormatDataArray);
        combinedThread.start();
        try {
            combinedThread.join();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException();
        }
        finally {
            Object object2 = lockObj;
            synchronized (object2) {
                busy = false;
            }
        }
        if (interrupted) {
            throw new IOException();
        }
        return combinedThread.getReceivedData();
    }

    public static void interrupt() throws IOException, ConnectionException {
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        if (combinedThread != null) {
            interrupted = true;
            combinedThread.interrupt();
        }
    }

    static class SPIInputStream
    extends InputStream {
        FileInputStream fis = null;

        SPIInputStream() {
            try {
                this.fis = new FileInputStream(ConnectionProperties.getInstance().getSPIInputFile());
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }

        private int read4bit() throws IOException, InterruptedException {
            int n = -1;
            while (true) {
                if (started) {
                    if (interrupted) break;
                    n = this.fis.read();
                    if (n >= 48 && n <= 57) {
                        n -= 48;
                        break;
                    }
                    if (n >= 65 && n <= 70) {
                        n -= 65;
                        n += 10;
                        break;
                    }
                    if (n >= 97 && n <= 102) {
                        n -= 97;
                        n += 10;
                        break;
                    }
                }
                Thread.sleep(200L);
            }
            return n;
        }

        @Override
        @Override
        public int read() throws IOException {
            if (this.fis == null) {
                return -1;
            }
            int n = 0;
            int n2 = 0;
            try {
                n = this.read4bit();
                n2 = this.read4bit();
            }
            catch (InterruptedException interruptedException) {
                return -1;
            }
            return n << 4 | n2;
        }

        @Override
        @Override
        public void close() throws IOException {
            if (this.fis != null) {
                this.fis.close();
            }
        }
    }

    static class SPIOutputStream
    extends OutputStream {
        FileOutputStream fos = null;

        SPIOutputStream() {
            File file = new File(ConnectionProperties.getInstance().getSPIOutputFile());
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.fos = new FileOutputStream(ConnectionProperties.getInstance().getSPIOutputFile());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        @Override
        public void write(int n) throws IOException {
            String string = HexUtil.toHexStringUpper((byte)n);
            this.fos.write(string.getBytes());
        }

        @Override
        @Override
        public void close() throws IOException {
            this.fos.close();
        }
    }

    static class SPICommCombinedThread
    extends Thread {
        SPICombinedFormatData[] data;
        SPICombinedFormatData[] recvData = null;

        SPICommCombinedThread(SPICombinedFormatData[] sPICombinedFormatDataArray) {
            int n = 0;
            this.data = sPICombinedFormatDataArray;
            for (int i = 0; i < sPICombinedFormatDataArray.length; ++i) {
                if (sPICombinedFormatDataArray[i].getProcessingType() != 0) continue;
                ++n;
            }
            this.recvData = n > 0 ? new SPICombinedFormatData[n] : null;
        }

        public SPICombinedFormatData[] getReceivedData() {
            return this.recvData;
        }

        @Override
        @Override
        public void run() {
            int n = 0;
            try {
                for (int i = 0; i < this.data.length && !interrupted; ++i) {
                    if (this.data[i].getProcessingType() == 0) {
                        byte[] byArray = new byte[this.data[i].getTransmissionData().length];
                        is.read(byArray);
                        this.recvData[n] = new SPICombinedFormatData(0, byArray);
                        ++n;
                        continue;
                    }
                    os.write(this.data[i].getTransmissionData());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static class SPICommFullduplexThread
    extends Thread {
        byte[] data;
        byte[] recvData;

        SPICommFullduplexThread(byte[] byArray) {
            this.data = byArray;
            this.recvData = new byte[byArray.length];
        }

        public byte[] getReceivedData() {
            return this.recvData;
        }

        @Override
        @Override
        public void run() {
            try {
                os.write(this.data);
                if (interrupted) {
                    return;
                }
                is.read(this.recvData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

