/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.Connectable;
import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.SPIFunctions;
import com.docomo_um.module.connection.SPIMaster;
import com.docomo_um.module.connection.SPIMasterSettingInfo;
import com.docomo_um.module.connection.SPISlave;
import com.docomo_um.module.connection.SPISpec;
import java.util.ArrayList;
import java.util.List;

public class SPIConnection
implements Connectable {
    private List<SPISpec> specList = null;
    private SPIMaster[] spiMaster = new SPIMaster[1];
    private SPISlave[] spiSlave = new SPISlave[1];

    SPIConnection(List<SPISpec> list) {
        this.specList = list;
        this.spiMaster[0] = null;
        this.spiSlave[0] = null;
    }

    public List<SPISpec> getSPISpec() {
        ArrayList<SPISpec> arrayList = new ArrayList<SPISpec>();
        for (int i = 0; i < this.specList.size(); ++i) {
            arrayList.add(this.specList.get(i));
        }
        return arrayList;
    }

    public synchronized SPIMaster getSPIMaster(SPISpec sPISpec, SPIMasterSettingInfo sPIMasterSettingInfo) throws ConnectionException {
        if (sPISpec == null || sPIMasterSettingInfo == null) {
            throw new NullPointerException();
        }
        if (this.spiSlave[0] != null) {
            throw new IllegalStateException();
        }
        if (this.spiMaster[0] == null) {
            this.spiMaster[0] = new SPIMaster(sPISpec, sPIMasterSettingInfo);
            SPIFunctions.setSPIDevice(this.spiMaster[0]);
        } else if (SPIFunctions.isStarted()) {
            throw new IllegalStateException();
        }
        return this.spiMaster[0];
    }

    public synchronized SPISlave getSPISlave(SPISpec sPISpec) throws ConnectionException {
        if (sPISpec == null) {
            throw new NullPointerException();
        }
        if (this.spiMaster[0] != null) {
            throw new IllegalStateException();
        }
        if (this.spiSlave[0] == null) {
            this.spiSlave[0] = new SPISlave(sPISpec);
            SPIFunctions.setSPIDevice(this.spiSlave[0]);
        }
        return this.spiSlave[0];
    }
}

