/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.ConnectionProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

class I2CStream {
    private static I2CStream i2cStreamInstance = new I2CStream();
    private FileOutputStream fos;
    private String inputFileName;
    private String outputFileName = ConnectionProperties.getInstance().getI2COutputFile();

    private I2CStream() {
        File file = new File(this.outputFileName);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            this.fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        this.inputFileName = ConnectionProperties.getInstance().getI2CInputFile();
    }

    protected void finalize() {
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    InputStream getInputStream(int n) {
        List<Integer> list = ConnectionProperties.getInstance().getI2CSlaveAddressList();
        return new I2CInputStream(list.contains(n));
    }

    OutputStream getOutputStream(int n) {
        List<Integer> list = ConnectionProperties.getInstance().getI2CSlaveAddressList();
        return new I2COutputStream(list.contains(n));
    }

    public static I2CStream getInstance() {
        return i2cStreamInstance;
    }

    private class I2COutputStream
    extends OutputStream {
        byte[] buf = new byte[2];
        boolean availableSlave;

        I2COutputStream(boolean bl) {
            this.availableSlave = bl;
        }

        @Override
        @Override
        public void write(int n) throws IOException {
            if (!this.availableSlave) {
                throw new IOException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
            }
            if (ConnectionProperties.getInstance().getIOException()) {
                throw new IOException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
            }
            for (int i = 0; i < 2; ++i) {
                int n2 = n & 0xF0;
                this.buf[i] = (n2 >>= 4) >= 0 && n2 <= 9 ? (byte)(48 + n2) : (byte)(65 + n2 - 10);
                n <<= 4;
            }
            I2CStream.this.fos.write(this.buf);
        }
    }

    private class I2CInputStream
    extends InputStream {
        private FileInputStream fis;
        byte[] buf = new byte[2];
        boolean availableSlave;

        public I2CInputStream(boolean bl) {
            this.availableSlave = bl;
            try {
                this.fis = new FileInputStream(I2CStream.this.inputFileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        @Override
        public int read() throws IOException {
            int n;
            if (!this.availableSlave) {
                this.close();
                throw new IOException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
            }
            if (ConnectionProperties.getInstance().getIOException()) {
                this.close();
                throw new IOException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
            }
            if (this.fis == null) {
                return -1;
            }
            while (true) {
                if (this.fis.read(this.buf) < this.buf.length) {
                    return -1;
                }
                String string = new String(this.buf);
                try {
                    n = Integer.valueOf(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                break;
            }
            return n;
        }

        @Override
        @Override
        public void close() throws IOException {
            this.fis.close();
        }
    }
}

