/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.I2CMaster;
import com.docomo_um.module.connection.I2CSpec;
import com.docomo_um.module.connection.I2CStream;
import com.docomo_um.win.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class I2CMasterImpl
extends I2CMaster {
    private I2CSpec spec;
    private long speed;
    private int slaveAddress;
    private boolean bStart;
    InputStream inputStream = null;
    OutputStream outputStream = null;

    I2CMasterImpl(I2CSpec i2CSpec, int n) {
        this.spec = i2CSpec;
        this.slaveAddress = n;
    }

    @Override
    @Override
    public void start() {
        Logging.getInstance().putMethod(this, "start");
        this.bStart = true;
    }

    @Override
    @Override
    public void stop() {
        Logging.getInstance().putMethod(this, "stop");
        this.bStart = false;
    }

    @Override
    @Override
    public void setCommSpeed(long l) {
        Logging.getInstance().putMethod(this, "setCommSpeed", String.valueOf(l));
        for (int i = 0; i < this.spec.getCommSpeedList().size(); ++i) {
            if (l != this.spec.getCommSpeedList().get(i)) continue;
            this.speed = l;
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Override
    public OutputStream getOutputStream() {
        Logging.getInstance().putMethod(this, "getOutputStream");
        if (!this.bStart) {
            throw new IllegalStateException();
        }
        if (this.outputStream == null) {
            this.outputStream = I2CStream.getInstance().getOutputStream(this.slaveAddress);
        }
        return this.outputStream;
    }

    @Override
    @Override
    public InputStream getInputStream() {
        Logging.getInstance().putMethod(this, "getInputStream");
        if (!this.bStart) {
            throw new IllegalStateException();
        }
        if (this.inputStream == null) {
            this.inputStream = I2CStream.getInstance().getInputStream(this.slaveAddress);
        }
        return this.inputStream;
    }

    @Override
    @Override
    public byte[] sendCombinedFormat(byte[] byArray, int n) throws IOException {
        Logging.getInstance().putMethod(this, "sendCombinedFormat", "byte[" + byArray.length + "]", String.valueOf(n));
        if (!this.bStart) {
            throw new IllegalStateException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        byte[] byArray2 = new byte[n];
        if (this.inputStream == null) {
            this.inputStream = I2CStream.getInstance().getInputStream(this.slaveAddress);
        }
        if (this.outputStream == null) {
            this.outputStream = I2CStream.getInstance().getOutputStream(this.slaveAddress);
        }
        this.outputStream.write(byArray);
        this.inputStream.read(byArray2);
        return byArray2;
    }

    public int getSlaveAddress() {
        return this.slaveAddress;
    }

    public long getSpeed() {
        return this.speed;
    }
}

