/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.Connectable;
import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.I2CMaster;
import com.docomo_um.module.connection.I2CMasterImpl;
import com.docomo_um.module.connection.I2CSlave;
import com.docomo_um.module.connection.I2CSpec;
import com.docomo_um.win.Logging;
import java.util.ArrayList;
import java.util.List;

public class I2CConnection
implements Connectable {
    private List<I2CMaster> masterList;
    private I2CSlave slave;
    private List<I2CSpec> specList;

    I2CConnection(List<I2CSpec> list) {
        this.specList = list;
        this.masterList = new ArrayList<I2CMaster>();
        this.slave = null;
    }

    public List<I2CSpec> getI2CSpec() {
        Logging.getInstance().putMethod(this, "getI2CSpec");
        return this.specList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2CMaster getI2CMaster(I2CSpec i2CSpec, int n) throws ConnectionException {
        I2CMasterImpl i2CMasterImpl;
        Logging.getInstance().putMethod(this, "getI2CSpec", i2CSpec.toString(), String.valueOf(n));
        if ((i2CSpec.getCommMode() & 1) == 0) {
            throw new IllegalArgumentException();
        }
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        I2CConnection i2CConnection = this;
        synchronized (i2CConnection) {
            if (this.slave != null) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < this.masterList.size(); ++i) {
                i2CMasterImpl = (I2CMasterImpl)this.masterList.get(i);
                if (i2CMasterImpl.getSlaveAddress() != n) continue;
                return i2CMasterImpl;
            }
            i2CMasterImpl = new I2CMasterImpl(i2CSpec, n);
            this.masterList.add(i2CMasterImpl);
        }
        return i2CMasterImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2CSlave getI2CSlave(I2CSpec i2CSpec, int n) throws ConnectionException {
        Logging.getInstance().putMethod(this, "getI2CSpec", i2CSpec.toString(), String.valueOf(n));
        if ((i2CSpec.getCommMode() & 2) == 0) {
            throw new IllegalArgumentException();
        }
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        I2CConnection i2CConnection = this;
        synchronized (i2CConnection) {
            if (this.masterList.size() != 0) {
                throw new IllegalStateException();
            }
            if (this.slave == null) {
                this.slave = new I2CSlave(i2CSpec, n);
            }
        }
        return this.slave;
    }
}

