/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.ConnectionException;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.GPIOListener;
import java.util.ArrayList;
import java.util.List;

public class GPIOFunctions {
    private static GPIOListener gpiolistener = null;
    private static List<Integer> inquiryPorts;
    private static List<Integer> inPortList;
    private static List<Integer> outPortList;
    private static boolean[] inPort;
    private static boolean[] outPort;

    static void InitGPIOFunctions(List<Integer> list, List<Integer> list2) {
        inPortList = list;
        outPortList = list2;
        inPort = new boolean[inPortList.size()];
        outPort = new boolean[outPortList.size()];
        inquiryPorts = new ArrayList<Integer>();
    }

    public static List<Integer> getAvailableInPort() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < inPortList.size(); ++i) {
            arrayList.add(inPortList.get(i));
        }
        return arrayList;
    }

    public static List<Integer> getAvailableOutPort() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < outPortList.size(); ++i) {
            arrayList.add(outPortList.get(i));
        }
        return arrayList;
    }

    public static void setGPIOListener(List<Integer> list, GPIOListener gPIOListener) throws ConnectionException {
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException();
        }
        inquiryPorts.clear();
        for (int i = 0; i < list.size(); ++i) {
            int n = list.get(i);
            if (!inPortList.contains(n)) {
                throw new IllegalArgumentException();
            }
            inquiryPorts.add(n);
        }
        gpiolistener = gPIOListener;
    }

    public static void sendControlSignal(int n, boolean bl) throws ConnectionException {
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        int n2 = outPortList.indexOf(n);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        GPIOFunctions.outPort[n2] = bl;
    }

    public static boolean receiveControlSignal(int n) throws ConnectionException {
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        int n2 = inPortList.indexOf(n);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return inPort[n2];
    }

    public static boolean getControlSignal(int n) throws ConnectionException {
        if (ConnectionProperties.getInstance().getConnectionException()) {
            throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        int n2 = outPortList.indexOf(n);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return outPort[n2];
    }

    public static void setReceiveControlSignal(int n, boolean bl) {
        int n2 = inPortList.indexOf(n);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (inPort[n2] == bl) {
            return;
        }
        GPIOFunctions.inPort[n2] = bl;
        n2 = inquiryPorts.indexOf(n);
        if (n2 >= 0 && gpiolistener != null) {
            gpiolistener.onChangedStatus(n, bl);
        }
    }
}

