/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.ADChannel;
import com.docomo_um.module.connection.I2CSpec;
import com.docomo_um.module.connection.SPISpec;
import com.docomo_um.module.connection.SerialSpec;
import com.docomo_um.win.SDKProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ConnectionProperties {
    private static ConnectionProperties connectionPropertiesInstance = null;
    private static String filename = "/nano/properties/connection.pro";
    private static List<SerialSpec> serialSpecList;
    private static List<String> enableSerialList;
    private static List<I2CSpec> i2cSpecList;
    private static String i2cOutputFile;
    private static String i2cInputFile;
    private static List<Integer> i2cSlaveAddressList;
    private static List<ADChannel> adChannelList;
    private static List<Integer> gpioInPortList;
    private static List<Integer> gpioOutPortList;
    private static List<SPISpec> spiSpecList;
    private static String spiOutputFile;
    private static String spiInputFile;
    private static long spiMaxDelay;
    private boolean connectionException = false;
    private String connectionExceptionMessage;
    private boolean ioException = false;
    private String ioExceptionMessage;

    private ConnectionProperties() {
        serialSpecList = new ArrayList<SerialSpec>();
        enableSerialList = new ArrayList<String>();
        i2cSpecList = new ArrayList<I2CSpec>();
        i2cSlaveAddressList = new ArrayList<Integer>();
        adChannelList = new ArrayList<ADChannel>();
        gpioInPortList = new ArrayList<Integer>();
        gpioOutPortList = new ArrayList<Integer>();
        spiSpecList = new ArrayList<SPISpec>();
        try {
            this.GetSerialSpecProc("UART");
            this.GetSerialSpecProc("USB");
            this.GetEnableSerialList();
            this.loadProperties();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static synchronized ConnectionProperties getInstance() {
        if (connectionPropertiesInstance == null) {
            connectionPropertiesInstance = new ConnectionProperties();
        }
        return connectionPropertiesInstance;
    }

    public List<SerialSpec> getSerialSpec() {
        return serialSpecList;
    }

    public List<String> getEnableSerialList() {
        return enableSerialList;
    }

    public List<I2CSpec> getI2CSpec() {
        return i2cSpecList;
    }

    public String getI2CInputFile() {
        return i2cInputFile;
    }

    public String getI2COutputFile() {
        return i2cOutputFile;
    }

    public List<Integer> getI2CSlaveAddressList() {
        return i2cSlaveAddressList;
    }

    public List<ADChannel> getADChannelList() {
        return adChannelList;
    }

    public List<Integer> getGPIOInPortList() {
        return gpioInPortList;
    }

    public List<Integer> getGPIOOutPortList() {
        return gpioOutPortList;
    }

    public List<SPISpec> getSPISpecList() {
        return spiSpecList;
    }

    public String getSPIOutputFile() {
        return spiOutputFile;
    }

    public String getSPIInputFile() {
        return spiInputFile;
    }

    public long getSPIMaxDelay() {
        return spiMaxDelay;
    }

    public void setConnectionException(boolean bl, String string) {
        this.connectionException = bl;
        this.connectionExceptionMessage = string;
    }

    public boolean getConnectionException() {
        return this.connectionException;
    }

    public String getConnectionExceptionMessage() {
        return this.connectionExceptionMessage;
    }

    public void setIOExcepton(boolean bl, String string) {
        this.ioException = bl;
        this.ioExceptionMessage = string;
    }

    public boolean getIOException() {
        return this.ioException;
    }

    public String getIOExceptionMessage() {
        return this.ioExceptionMessage;
    }

    private void GetEnableSerialList() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(filename);
        SDKProperties sDKProperties = new SDKProperties();
        sDKProperties.load(fileInputStream);
        String string = sDKProperties.getProperty("ENABLESERIAL", "");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                enableSerialList.add(string2);
            }
        }
    }

    public String getTerminalPort(String string) {
        String string2 = null;
        try {
            string2 = this.getTerminalPortInternal("USB", string);
            if (string2 != null) {
                return string2;
            }
            string2 = this.getTerminalPortInternal("UART", string);
        }
        catch (IOException iOException) {
            string2 = null;
        }
        return string2;
    }

    private String getTerminalPortInternal(String string, String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(filename);
        SDKProperties sDKProperties = new SDKProperties();
        sDKProperties.load(fileInputStream);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                String string3 = string + String.valueOf(i) + String.valueOf(j);
                String string4 = sDKProperties.getProperty(string3);
                if (string4 == null || !string4.equals(string2)) continue;
                return string3;
            }
        }
        return null;
    }

    private void GetSerialSpecProc(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(filename);
        SDKProperties sDKProperties = new SDKProperties();
        sDKProperties.load(fileInputStream);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                Object object;
                String string2 = string + String.valueOf(i) + String.valueOf(j);
                String string3 = sDKProperties.getProperty(string2);
                if (string3 == null) continue;
                ArrayList<Long> arrayList = new ArrayList<Long>();
                arrayList.clear();
                String string4 = string + String.valueOf(i) + String.valueOf(j) + "SPEC";
                String string5 = sDKProperties.getProperty(string4);
                if (string5 != null) {
                    object = new StringTokenizer(string5, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string6 = ((StringTokenizer)object).nextToken();
                        long l = Integer.parseInt(string6);
                        arrayList.add(l);
                    }
                }
                object = new SerialSpec(arrayList, string2, string3);
                serialSpecList.add((SerialSpec)object);
            }
        }
    }

    private void loadProperties() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        SDKProperties sDKProperties = new SDKProperties();
        sDKProperties.load(fileInputStream);
        String string = sDKProperties.getProperty("I2CDEVICENAME");
        int n = 0;
        String string2 = sDKProperties.getProperty("I2CMODE");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            object4 = stringTokenizer.nextToken();
            if (((String)object4).equals("MASTER")) {
                n |= 1;
                continue;
            }
            if (!((String)object4).equals("SLAVE")) continue;
            n |= 2;
        }
        object4 = new ArrayList();
        string2 = sDKProperties.getProperty("I2CADDRESSSIZE");
        stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            object3 = stringTokenizer.nextToken();
            if (((String)object3).equals("7")) {
                object4.add(7);
                continue;
            }
            if (!((String)object3).equals("10")) continue;
            object4.add(10);
        }
        object3 = new ArrayList();
        string2 = sDKProperties.getProperty("I2CSPEED");
        stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            object3.add(Long.valueOf((String)object2));
        }
        if (string != null && object4.size() != 0 && n != 0 && object3.size() != 0) {
            object2 = new I2CSpec(string, (List<Integer>)object4, n, (List<Long>)object3);
            i2cSpecList.add((I2CSpec)object2);
        }
        i2cOutputFile = sDKProperties.getProperty("I2COUTPUT", null);
        i2cInputFile = sDKProperties.getProperty("I2CINPUT", null);
        string2 = sDKProperties.getProperty("I2CSLAVEADDR");
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                i2cSlaveAddressList.add(Integer.valueOf((String)object2));
            }
        }
        for (int i = 0; i < 10 && (string2 = sDKProperties.getProperty((String)(object = "AD" + String.valueOf(i)))) != null; ++i) {
            stringTokenizer = new StringTokenizer(string2, ",");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string4 = stringTokenizer.nextToken();
            ADChannel aDChannel = new ADChannel(string3, Integer.valueOf(string4));
            adChannelList.add(aDChannel);
        }
        string2 = sDKProperties.getProperty("GPIOINPORT");
        stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            try {
                gpioInPortList.add(Integer.valueOf(string5));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        string2 = sDKProperties.getProperty("GPIOOUTPORT");
        stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            try {
                gpioOutPortList.add(Integer.valueOf(string6));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        n = 0;
        string2 = sDKProperties.getProperty("SPIMODE");
        stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("MASTER")) {
                n |= 1;
                continue;
            }
            if (!((String)object).equals("SLAVE")) continue;
            n |= 2;
        }
        string2 = sDKProperties.getProperty("SPISPEED");
        stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            arrayList.add(Long.valueOf((String)object));
        }
        if (n != 0 && arrayList.size() != 0) {
            object = new SPISpec(n, arrayList, 0);
            spiSpecList.add((SPISpec)object);
        }
        spiOutputFile = sDKProperties.getProperty("SPIOUTPUT");
        spiInputFile = sDKProperties.getProperty("SPIINPUT");
        object = sDKProperties.getProperty("SPIMAXDELAY");
        spiMaxDelay = Long.parseLong((String)object);
    }

    static {
        spiMaxDelay = 1000000L;
    }
}

