/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module.connection;

import com.docomo_um.module.connection.ADChannel;
import com.docomo_um.module.connection.ADConverter;
import com.docomo_um.module.connection.Connectable;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.module.connection.GPIOConnection;
import com.docomo_um.module.connection.I2CConnection;
import com.docomo_um.module.connection.I2CSpec;
import com.docomo_um.module.connection.SPIConnection;
import com.docomo_um.module.connection.SPISpec;
import com.docomo_um.module.connection.SerialConnection;
import com.docomo_um.module.connection.SerialSpec;
import java.util.ArrayList;
import java.util.List;

public abstract class ConnectionManager {
    private Connectable[] connection = new Connectable[5];
    private int[] available = null;
    public static final int CONNECTION_TYPE_ADCONVERTER = 0;
    public static final int CONNECTION_TYPE_GPIO = 1;
    public static final int CONNECTION_TYPE_I2C = 2;
    public static final int CONNECTION_TYPE_SERIAL = 3;
    public static final int CONNECTION_TYPE_SPI = 4;

    ConnectionManager() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.initializeADConverter(arrayList);
        this.initializeGpio(arrayList);
        this.initializeSerial(arrayList);
        this.initializeI2C(arrayList);
        this.initializeSpi(arrayList);
        if (!arrayList.isEmpty()) {
            this.available = new int[arrayList.size()];
            for (int i = 0; i < this.available.length; ++i) {
                this.available[i] = (Integer)arrayList.get(i);
            }
        }
    }

    private void initializeADConverter(List<Integer> list) {
        this.connection[0] = null;
        List<ADChannel> list2 = ConnectionProperties.getInstance().getADChannelList();
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        this.connection[0] = new ADConverter(list2);
        list.add(0);
    }

    private void initializeGpio(List<Integer> list) {
        this.connection[1] = null;
        List<Integer> list2 = ConnectionProperties.getInstance().getGPIOInPortList();
        List<Integer> list3 = ConnectionProperties.getInstance().getGPIOOutPortList();
        if (list2.isEmpty() && list3.isEmpty()) {
            return;
        }
        this.connection[1] = new GPIOConnection(list2, list3);
        list.add(1);
    }

    private void initializeSerial(List<Integer> list) {
        this.connection[3] = null;
        List<SerialSpec> list2 = ConnectionProperties.getInstance().getSerialSpec();
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        this.connection[3] = new SerialConnection(list2);
        list.add(3);
    }

    private void initializeI2C(List<Integer> list) {
        this.connection[2] = null;
        List<I2CSpec> list2 = ConnectionProperties.getInstance().getI2CSpec();
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        this.connection[2] = new I2CConnection(list2);
        list.add(2);
    }

    private void initializeSpi(List<Integer> list) {
        this.connection[4] = null;
        List<SPISpec> list2 = ConnectionProperties.getInstance().getSPISpecList();
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        this.connection[4] = new SPIConnection(list2);
        list.add(4);
    }

    public int[] getAvailableConnections() {
        int[] nArray = new int[this.available.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.available[i];
        }
        return nArray;
    }

    public Connectable getConnection(int n) {
        if (n < 0 || n > 4) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("type is invalid.");
            throw illegalArgumentException;
        }
        if (this.connection[n] == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("type is invalid.");
            throw illegalArgumentException;
        }
        return this.connection[n];
    }
}

