/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module;

import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.win.Logging;

public class PINManager {
    private static int status;
    private static int lockCount;
    private static int FULLLockCount;
    public static final int STATUS_READY = 0;
    public static final int STATUS_WAIT_PIN1 = 1;
    public static final int STATUS_LOCK_PIN1 = 2;
    public static final int STATUS_FULL_LOCK = 3;
    private static final int FullLockNum = 10;
    private static final int LockNum = 3;

    PINManager() throws ExternalStatusException, ModuleException, DeviceException {
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        lockCount = ModuleProperties.getInstance().getPIN1LockCount();
        FULLLockCount = ModuleProperties.getInstance().getPIN1FullLockCount();
        status = ModuleProperties.getInstance().getPIN1Enable() ? (FULLLockCount >= 10 ? 3 : (lockCount >= 3 ? 2 : 1)) : 0;
    }

    public void verifyPIN1Code(String string) throws ExternalStatusException, ModuleException, DeviceException {
        Logging.getInstance().putMethod(this, "verifyPIN1Code", string);
        if (status == 0) {
            return;
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (!this.availablePIN1Code(string)) {
            throw new IllegalArgumentException();
        }
        if (!string.equals(ModuleProperties.getInstance().getPIN1Code())) {
            if (++lockCount >= 3) {
                status = 2;
            }
            throw new IllegalArgumentException();
        }
        lockCount = 0;
        FULLLockCount = 0;
        status = 0;
    }

    public void changePIN1Code(String string, String string2) throws ExternalStatusException, ModuleException, DeviceException {
        Logging.getInstance().putMethod(this, "changePIN1Code", string, string2);
        if (!ModuleProperties.getInstance().getPIN1Enable()) {
            return;
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (!this.availablePIN1Code(string) || !this.availablePIN1Code(string2)) {
            throw new IllegalArgumentException();
        }
        if (!string.equals(ModuleProperties.getInstance().getPIN1Code())) {
            if (++lockCount >= 3) {
                status = 2;
            }
            throw new IllegalArgumentException();
        }
        lockCount = 0;
        FULLLockCount = 0;
        ModuleProperties.getInstance().setPIN1Code(string2);
        status = 0;
    }

    public void setPIN1CodeEnable(boolean bl, String string) throws ExternalStatusException, ModuleException, DeviceException {
        Logging.getInstance().putMethod(this, "setPIN1CodeEnable", String.valueOf(bl), string);
        if (bl ? status == 0 && ModuleProperties.getInstance().getPIN1Enable() : status == 0 && !ModuleProperties.getInstance().getPIN1Enable()) {
            return;
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (!this.availablePIN1Code(string)) {
            throw new IllegalArgumentException();
        }
        if (!string.equals(ModuleProperties.getInstance().getPIN1Code())) {
            if (++lockCount >= 3) {
                status = 2;
            }
            throw new IllegalArgumentException();
        }
        lockCount = 0;
        FULLLockCount = 0;
        ModuleProperties.getInstance().setPIN1Enable(bl);
        status = 0;
    }

    public int getPINStatus() throws ExternalStatusException, ModuleException, DeviceException {
        Logging.getInstance().putMethod(this, "getPINStatus");
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        return status;
    }

    public void unlockPIN1Code(String string, String string2) throws ExternalStatusException, ModuleException, DeviceException {
        Logging.getInstance().putMethod(this, "unlockPIN1Code", string, string2);
        if (status == 0 || status == 1) {
            return;
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (!this.availableUnlockCode(string) || !this.availablePIN1Code(string2)) {
            throw new IllegalArgumentException();
        }
        if (status == 3) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (!string.equals(ModuleProperties.getInstance().getUnlockCode())) {
            if (++FULLLockCount >= 10) {
                status = 3;
            }
            throw new IllegalArgumentException();
        }
        lockCount = 0;
        FULLLockCount = 0;
        ModuleProperties.getInstance().setPIN1Code(string2);
        status = 0;
    }

    private boolean availableUnlockCode(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length != 8) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (byArray[i] >= 48 && byArray[i] <= 57) continue;
            return false;
        }
        return true;
    }

    public int getPIN1LockRemainCount() throws ModuleException, ExternalStatusException, DeviceException {
        Logging.getInstance().putMethod(this, "getPIN1LockRemainCount");
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        return 3 - lockCount;
    }

    public int getFullLockRemainCount() throws ModuleException, ExternalStatusException, DeviceException {
        Logging.getInstance().putMethod(this, "getFullLockRemainCount");
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        return 10 - FULLLockCount;
    }

    private boolean availablePIN1Code(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (byArray[i] >= 48 && byArray[i] <= 57) continue;
            return false;
        }
        return true;
    }
}

