/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.module;

import com.docomo_um.module.Application;
import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleException;
import com.docomo_um.module.ModuleFunctions;
import com.docomo_um.module.ModuleListener;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.PINManager;
import com.docomo_um.module.connection.ConnectionManager;
import com.docomo_um.module.connection.ConnectionManagerImpl;
import com.docomo_um.module.location.LocationProvider;
import com.docomo_um.module.location.LocationProviderImpl;
import com.docomo_um.module.net.PacketController;
import com.docomo_um.module.net.PacketControllerImpl;
import com.docomo_um.module.net.VoiceController;
import com.docomo_um.module.net.VoiceControllerImpl;
import com.docomo_um.win.Logging;
import java.util.Date;
import java.util.List;

public class ModuleManager {
    public static final int SYSTEM_UPDATE_IDLE = 0;
    public static final int SYSTEM_UPDATE_DOWNLOADING = 1;
    public static final int SYSTEM_UPDATE_DOWNLOAD_COMPLETE = 2;
    public static final int SYSTEM_UPDATE_REWRITING = 3;
    public static final int SYSTEM_UPDATE_SENDING_COMPINFO = 4;
    private static ModuleManager moduleManagerInstance = null;
    private PINManager pinManagerInstance = null;
    private ConnectionManager connectionManagerInstance = null;
    private LocationProvider[] locationProviderInstance = new LocationProvider[3];
    private VoiceController voiceControllerInstance = null;
    private PacketController packetControllerInstance = null;

    private ModuleManager() throws ModuleException {
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
    }

    public static synchronized ModuleManager getInstance() throws ModuleException {
        if (moduleManagerInstance == null) {
            moduleManagerInstance = new ModuleManager();
        }
        Logging.getInstance().putMethod(moduleManagerInstance, "getInstance");
        return moduleManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PINManager getPINManager() throws ExternalStatusException, ModuleException, DeviceException {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            Logging.getInstance().putMethod(this, "getPINManager");
            if (this.pinManagerInstance == null) {
                this.pinManagerInstance = new PINManager();
            }
        }
        return this.pinManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionManager getConnectionManager() {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            Logging.getInstance().putMethod(this, "getConnectionManager");
            if (this.connectionManagerInstance == null) {
                this.connectionManagerInstance = new ConnectionManagerImpl();
            }
        }
        return this.connectionManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationProvider getLocationProvider(int n) {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            Logging.getInstance().putMethod(this, "getLocationProvider", String.valueOf(n));
            if (this.locationProviderInstance[n] == null) {
                this.locationProviderInstance[n] = new LocationProviderImpl(n);
            }
        }
        return this.locationProviderInstance[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoiceController getVoiceController() {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            Logging.getInstance().putMethod(this, "getVoiceController");
            if (this.voiceControllerInstance == null) {
                this.voiceControllerInstance = new VoiceControllerImpl();
            }
        }
        return this.voiceControllerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketController getPacketController() {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            Logging.getInstance().putMethod(this, "getPacketController");
            if (this.packetControllerInstance == null) {
                this.packetControllerInstance = new PacketControllerImpl();
            }
        }
        return this.packetControllerInstance;
    }

    public void setModuleListener(ModuleListener moduleListener) {
        Logging.getInstance().putMethod(this, "setModuleListener", moduleListener == null ? "null" : moduleListener.toString());
        ModuleFunctions.setModuleListener(moduleListener);
    }

    public void turnOff() throws ModuleException {
        this.turnOff(null);
    }

    public void turnOff(Date date) throws ModuleException {
        Logging.getInstance().putMethod(this, "turnOff", date == null ? "null" : date.toString());
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        Logging.getInstance().printTerminalMessage("turnOff(" + (date == null ? "null" : date.toString()) + ")");
    }

    public void reset() throws ModuleException {
        Logging.getInstance().putMethod(this, "reset");
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getSystemUpdateStatus() == 2) {
            ModuleProperties.getInstance().setSystemUpdateStatus(3);
            Logging.getInstance().printTerminalMessage("\u30b7\u30b9\u30c6\u30e0\u306e\u66f8\u304d\u63db\u3048\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f\u3002");
            Logging.getInstance().put("\u30b7\u30b9\u30c6\u30e0\u306e\u66f8\u304d\u63db\u3048\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f\u3002");
        }
    }

    public int getSystemUpdateStatus() throws ModuleException {
        Logging.getInstance().putMethod(this, "getSystemUpdateStatus");
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        return ModuleProperties.getInstance().getSystemUpdateStatus();
    }

    public void updateSystem() throws ModuleException, DeviceException, ExternalStatusException {
        Logging.getInstance().putMethod(this, "updateSystem");
        if (ModuleProperties.getInstance().getModuleException()) {
            throw new ModuleException(ModuleProperties.getInstance().getModuleExceptionMessage());
        }
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (!ModuleProperties.getInstance().getUIM()) {
            throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
        }
        if (ModuleProperties.getInstance().getSystemUpdateStatus() == 0) {
            ModuleProperties.getInstance().setSystemUpdateStatus(1);
            Logging.getInstance().put("\u30b7\u30b9\u30c6\u30e0\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u306e\u5b9f\u884c\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f\u3002");
            Logging.getInstance().printTerminalMessage("\u30b7\u30b9\u30c6\u30e0\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u306e\u5b9f\u884c\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f\u3002");
        }
    }

    public void cancelSystemUpdate() throws DeviceException, ModuleException {
        Logging.getInstance().putMethod(this, "cancelSystemUpdate");
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        if (ModuleProperties.getInstance().getSystemUpdateStatus() != 0) {
            if (!ModuleProperties.getInstance().getCancelSystemUpdate()) {
                throw new ModuleException();
            }
            ModuleProperties.getInstance().setSystemUpdateStatus(0);
            Logging.getInstance().printTerminalMessage("\u30b7\u30b9\u30c6\u30e0\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u306e\u5b9f\u884c\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
        }
    }

    public List<Application> getApplicationList() {
        Logging.getInstance().putMethod(this, "getApplicationList");
        return ModuleProperties.getInstance().getApplicationList();
    }

    public void changeApplication(Application application) throws ModuleException, DeviceException {
        int n;
        Logging.getInstance().putMethod(this, "changeApplication", application.toString());
        if (ModuleProperties.getInstance().getDeviceException()) {
            throw new DeviceException(ModuleProperties.getInstance().getDeviceExceptionMessage());
        }
        List<Application> list = ModuleProperties.getInstance().getApplicationList();
        for (n = 0; n < list.size() && !application.equals(list.get(n)); ++n) {
        }
        if (n >= list.size()) {
            throw new ModuleException();
        }
        Logging.getInstance().printTerminalMessage("changeApplication(" + list.get(n).getName() + ")");
    }
}

