/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.io;

import com.docomo_um.io.IOProperties;
import com.docomo_um.win.Logging;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class NVMAccessManager {
    private static long NVMSIZE = 1024L;
    private static String NVMNAME = "nvm";
    private static NVMAccessManager nvmAccessManagerObject = null;

    NVMAccessManager() {
        NVMSIZE = IOProperties.getInstance().getNVMSize();
    }

    public static synchronized NVMAccessManager getInstance() {
        if (nvmAccessManagerObject == null) {
            nvmAccessManagerObject = new NVMAccessManager();
            String string = IOProperties.getInstance().getNVMDir();
            File file = new File(string);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File(string = IOProperties.getInstance().getNVMDir() + NVMNAME)).exists()) {
                try {
                    file.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[(int)NVMSIZE];
                    for (int i = 0; i < 1024; ++i) {
                        byArray[i] = 0;
                    }
                    fileOutputStream.write(byArray);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Logging.getInstance().putMethodMessage(nvmAccessManagerObject, "getInstance", "Can't create NVM File.");
                    iOException.printStackTrace();
                }
            }
        }
        Logging.getInstance().putMethod(nvmAccessManagerObject, "getInstance");
        return nvmAccessManagerObject;
    }

    public long getAvailableMemorySize() {
        Logging.getInstance().putMethod(this, "getAvailableMemorySize");
        return NVMSIZE;
    }

    public OutputStream openOutputStream(long l) throws IOException {
        Logging.getInstance().putMethod(this, "openOutputStream", String.valueOf(l));
        if (l < 0L || l >= NVMSIZE) {
            Logging.getInstance().putMethodMessage(this, "openOutputStream", "offset = " + String.valueOf(l) + " is invalid address");
            throw new IllegalArgumentException();
        }
        NVMOutputStream nVMOutputStream = null;
        nVMOutputStream = new NVMOutputStream(IOProperties.getInstance().getNVMDir() + NVMNAME, l);
        return nVMOutputStream;
    }

    public InputStream openInputStream(long l) throws IOException {
        Logging.getInstance().putMethod(this, "openInputStream", String.valueOf(l));
        if (l < 0L || l >= NVMSIZE) {
            Logging.getInstance().putMethodMessage(this, "openOutputStream", "offset = " + String.valueOf(l) + " is invalid address");
            throw new IllegalArgumentException();
        }
        NVMInputStream nVMInputStream = null;
        nVMInputStream = new NVMInputStream(IOProperties.getInstance().getNVMDir() + NVMNAME, l);
        return nVMInputStream;
    }

    private class NVMInputStream
    extends InputStream {
        private final RandomAccessFile raf_;

        public NVMInputStream(String string, long l) throws IOException {
            this.raf_ = new RandomAccessFile(string, "r");
            this.raf_.seek(l);
        }

        @Override
        @Override
        public int read() throws IOException {
            int n;
            Logging.getInstance().putMethod(this, "read");
            try {
                n = this.raf_.read();
                if (n == -1) {
                    return -1;
                }
            }
            catch (EOFException eOFException) {
                return -1;
            }
            return n & 0xFF;
        }

        @Override
        @Override
        public void close() throws IOException {
            Logging.getInstance().putMethod(this, "close");
            this.raf_.close();
        }
    }

    private class NVMOutputStream
    extends OutputStream {
        private final RandomAccessFile raf_;
        private long offset_;

        public NVMOutputStream(String string, long l) throws IOException {
            this.raf_ = new RandomAccessFile(string, "rw");
            this.raf_.seek(l);
            this.offset_ = l;
        }

        @Override
        @Override
        public void write(int n) throws IOException {
            Logging.getInstance().putMethod(this, "write", String.valueOf(n));
            ++this.offset_;
            if (this.offset_ > NVMSIZE) {
                throw new IOException();
            }
            this.raf_.writeByte(n);
        }

        @Override
        @Override
        public void close() throws IOException {
            Logging.getInstance().putMethod(this, "close");
            this.raf_.close();
        }
    }
}

