/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.io;

import com.docomo_um.io.FFSFile;
import com.docomo_um.io.IOProperties;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.win.Logging;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class FFSAccessManager {
    protected static final int FFSSIZE = 0x100000;
    private static FFSAccessManager ffsAccessManagerInstance = null;
    private static Object lock = new Object();
    protected List<FFSFile> fileList;
    protected int remainSize;
    protected int ffsType;
    protected String path = IOProperties.getInstance().getFFSDir();

    FFSAccessManager() {
        this.fileList = new ArrayList<FFSFile>();
        this.fileList.add(new FFSFile("ffsfile00.dat"));
        this.fileList.add(new FFSFile("ffsfile01.dat"));
        this.fileList.add(new FFSFile("ffsfile02.dat"));
        this.fileList.add(new FFSFile("ffsfile03.dat"));
        this.fileList.add(new FFSFile("ffsfile04.dat"));
        this.fileList.add(new FFSFile("ffsfile05.dat"));
        this.fileList.add(new FFSFile("ffsfile06.dat"));
        this.fileList.add(new FFSFile("ffsfile07.dat"));
        this.fileList.add(new FFSFile("ffsfile08.dat"));
        this.fileList.add(new FFSFile("ffsfile09.dat"));
        String string = IOProperties.getInstance().getFFSDir();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        this.remainSize = 0x100000;
        for (int i = 0; i < this.fileList.size(); ++i) {
            String string2 = IOProperties.getInstance().getFFSDir() + this.fileList.get(i).getName();
            file = new File(string2);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    Logging.getInstance().putMethodMessage(ffsAccessManagerInstance, "getInstance", "IOException in createNewFile");
                    iOException.printStackTrace();
                }
                continue;
            }
            this.remainSize = (int)((long)this.remainSize - file.length());
        }
    }

    public static synchronized FFSAccessManager getInstance() {
        if (ffsAccessManagerInstance == null) {
            ffsAccessManagerInstance = new FFSAccessManager();
        }
        Logging.getInstance().putMethod(ffsAccessManagerInstance, "getInstance");
        return ffsAccessManagerInstance;
    }

    public List<FFSFile> getFileList() {
        Logging.getInstance().putMethod(this, "getFileList");
        ArrayList<FFSFile> arrayList = new ArrayList<FFSFile>();
        for (int i = 0; i < this.fileList.size(); ++i) {
            arrayList.add(new FFSFile(this.fileList.get(i).getName()));
        }
        return arrayList;
    }

    public OutputStream openOutputStream(FFSFile fFSFile, boolean bl) throws IOException {
        Logging.getInstance().putMethod(this, "openOutputStream", fFSFile.getName(), Boolean.toString(bl));
        for (int i = 0; i < this.fileList.size(); ++i) {
            FFSFile fFSFile2 = this.fileList.get(i);
            if (!fFSFile.getName().equals(fFSFile2.getName())) continue;
            FFSOutputStream fFSOutputStream = null;
            try {
                fFSOutputStream = new FFSOutputStream(fFSFile.getName(), bl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException();
            }
            return fFSOutputStream;
        }
        throw new IllegalArgumentException(fFSFile.getName());
    }

    public InputStream openInputStream(FFSFile fFSFile) throws IOException {
        FFSInputStream fFSInputStream = null;
        if (fFSFile == null) {
            throw new NullPointerException();
        }
        Logging.getInstance().putMethod(this, "openInputStream", fFSFile.getName());
        for (int i = 0; i < this.fileList.size(); ++i) {
            FFSFile fFSFile2 = this.fileList.get(i);
            if (!fFSFile.getName().equals(fFSFile2.getName())) continue;
            try {
                fFSInputStream = new FFSInputStream(fFSFile.getName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException();
            }
            return fFSInputStream;
        }
        throw new IllegalArgumentException(fFSFile.getName());
    }

    public int getRemainSize() throws IOException {
        Logging.getInstance().putMethod(this, "getRemainSize");
        Logging.getInstance().putMethodMessage(this, "getRemainSize", "remain size = " + String.valueOf(this.remainSize));
        if (ConnectionProperties.getInstance().getIOException()) {
            throw new IOException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        return this.remainSize;
    }

    private class FFSInputStream
    extends InputStream {
        private final RandomAccessFile raf_;

        public FFSInputStream(String string) throws IOException {
            this.raf_ = new RandomAccessFile(FFSAccessManager.this.path + string, "r");
        }

        @Override
        @Override
        public int read() throws IOException {
            int n;
            try {
                n = this.raf_.read();
                if (n == -1) {
                    return -1;
                }
            }
            catch (EOFException eOFException) {
                return -1;
            }
            return n & 0xFF;
        }

        @Override
        @Override
        public void close() throws IOException {
            Logging.getInstance().putMethod(this, "close");
            this.raf_.close();
        }

        @Override
        public int available() throws IOException {
            return (int)(this.raf_.length() - this.raf_.getFilePointer());
        }
    }

    private class FFSOutputStream
    extends OutputStream {
        private final RandomAccessFile raf_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FFSOutputStream(String string, boolean bl) throws IOException {
            this.raf_ = new RandomAccessFile(FFSAccessManager.this.path + string, "rw");
            long l = 0L;
            Object object = lock;
            synchronized (object) {
                l = this.raf_.length();
                if (bl) {
                    this.raf_.seek(l);
                } else {
                    this.raf_.setLength(0L);
                    FFSAccessManager.this.remainSize = (int)((long)FFSAccessManager.this.remainSize + l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Override
        public void write(int n) throws IOException {
            Logging.getInstance().putMethod(this, "write", String.valueOf(n));
            Object object = lock;
            synchronized (object) {
                if (FFSAccessManager.this.remainSize > 0) {
                    --FFSAccessManager.this.remainSize;
                } else {
                    throw new IOException();
                }
            }
            this.raf_.write(n);
        }

        @Override
        @Override
        public void close() throws IOException {
            Logging.getInstance().putMethod(this, "close");
            this.raf_.close();
        }
    }
}

