/*
 * Decompiled with CFR 0.152.
 */
package com.docomo_um.io;

import com.docomo_um.io.FFSAccessManager;
import com.docomo_um.io.FFSFile;
import com.docomo_um.io.IOProperties;
import com.docomo_um.module.connection.ConnectionProperties;
import com.docomo_um.win.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jp.co.aplix.avm.LoadableModule;
import jp.co.aplix.avm.LoadableModuleException;

public class ApplicationInstallManager
extends FFSAccessManager {
    private static ApplicationInstallManager appInstallManagerInstance;
    private List<FFSFile> appList;

    ApplicationInstallManager() {
        this.path = IOProperties.getInstance().getDLDir();
        this.fileList = new ArrayList();
        this.fileList.add(new FFSFile("dltemp.cap"));
        this.appList = new ArrayList<FFSFile>();
        this.appList.add(new FFSFile("usrapp00.cap"));
        this.appList.add(new FFSFile("usrapp01.cap"));
        this.remainSize = 0x100000;
        String string = IOProperties.getInstance().getDLDir();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        for (int i = 0; i < this.fileList.size(); ++i) {
            String string2 = IOProperties.getInstance().getDLDir() + ((FFSFile)this.fileList.get(i)).getName();
            file = new File(string2);
            if (!file.exists()) continue;
            this.remainSize = (int)((long)this.remainSize - file.length());
        }
        string = IOProperties.getInstance().getAppDir();
        file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public static synchronized ApplicationInstallManager getInstance() {
        if (appInstallManagerInstance == null) {
            appInstallManagerInstance = new ApplicationInstallManager();
        }
        Logging.getInstance().putMethod(appInstallManagerInstance, "getInstance");
        return appInstallManagerInstance;
    }

    @Override
    @Override
    public OutputStream openOutputStream(FFSFile fFSFile, boolean bl) throws IOException {
        Logging.getInstance().putMethod(this, "openOutputStream", fFSFile.toString(), String.valueOf(bl));
        return super.openOutputStream(fFSFile, bl);
    }

    @Override
    @Override
    public InputStream openInputStream(FFSFile fFSFile) throws IOException {
        Logging.getInstance().putMethod(this, "openInputStream", fFSFile.toString());
        return super.openInputStream(fFSFile);
    }

    @Override
    @Override
    public List<FFSFile> getFileList() {
        Logging.getInstance().putMethod(this, "getFileList");
        ArrayList<FFSFile> arrayList = new ArrayList<FFSFile>();
        for (int i = 0; i < this.fileList.size(); ++i) {
            arrayList.add(new FFSFile(((FFSFile)this.fileList.get(i)).getName()));
        }
        return arrayList;
    }

    public List<FFSFile> getApplicationAreaList() {
        Logging.getInstance().putMethod(this, "getApplicationAreaList");
        ArrayList<FFSFile> arrayList = new ArrayList<FFSFile>();
        for (int i = 0; i < this.appList.size(); ++i) {
            arrayList.add(new FFSFile(this.appList.get(i).getName()));
        }
        return arrayList;
    }

    public synchronized void updateApplicationArea(FFSFile fFSFile) throws LoadableModuleException, IOException {
        Object object;
        Object object2;
        Logging.getInstance().putMethod(this, "updateApplicationArea", fFSFile.toString());
        boolean bl = false;
        for (int i = 0; i < this.appList.size(); ++i) {
            object2 = this.appList.get(i);
            if (!fFSFile.getName().equals(((FFSFile)object2).getName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
        if (ConnectionProperties.getInstance().getIOException()) {
            throw new IOException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        FFSFile fFSFile2 = (FFSFile)this.fileList.get(0);
        object2 = new File(this.path + fFSFile2.getName());
        if (!((File)object2).exists()) {
            throw new IllegalStateException();
        }
        byte[] byArray = new byte[(int)((File)object2).length()];
        try {
            object = new FileInputStream((File)object2);
            ((FileInputStream)object).read(byArray);
            ((FileInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException();
        }
        if (IOProperties.getInstance().getLoadableModuleException()) {
            object = new LoadableModule(byArray);
            ((LoadableModule)object).destroy();
        }
        ((File)object2).delete();
        object2 = new File(IOProperties.getInstance().getAppDir() + fFSFile.getName());
        if (!((File)object2).exists()) {
            ((File)object2).createNewFile();
        }
        try {
            object = new FileOutputStream((File)object2);
            ((FileOutputStream)object).write(byArray);
            ((FileOutputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    @Override
    public int getRemainSize() throws IOException {
        Logging.getInstance().putMethod(this, "getRemainSize");
        if (ConnectionProperties.getInstance().getIOException()) {
            throw new IOException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
        }
        return this.remainSize;
    }
}

