/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.nano.wizard.wizards;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import jp.co.aplix.nano.wizard.wizards.nanoNewWizardConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class nanoNewWizardJava
extends NewJavaProjectWizardPage {
    private static final String[] required = nanoNewWizardConstants.REQUIRED_PROJECTS;
    private boolean initialized;
    private WizardNewProjectCreationPage mainpage;
    private IProject project;
    private IJavaProject javaProject;

    public nanoNewWizardJava(IWorkspaceRoot root, WizardNewProjectCreationPage mainpage) {
        super(root, mainpage);
        this.mainpage = mainpage;
    }

    public void setVisible(boolean visible) {
        if (!this.initialized) {
            this.init();
        }
        super.setVisible(visible);
    }

    private void init() {
        this.project = this.mainpage.getProjectHandle();
        this.javaProject = JavaCore.create((IProject)this.project);
        this.setDefaultClassPath(this.getDefaultClasspathEntry(), false);
        this.setDefaultOutputFolder(this.getDefaultOutputFolder());
        this.initialized = true;
    }

    private IClasspathEntry[] getDefaultClasspathEntry() {
        IClasspathEntry[] sources = this.getDefaultSourceFolder();
        IClasspathEntry[] projects = this.getDefaultProjectEntry();
        IClasspathEntry[] newEntries = new IClasspathEntry[sources.length + projects.length];
        System.arraycopy(sources, 0, newEntries, 0, sources.length);
        System.arraycopy(projects, 0, newEntries, sources.length, projects.length);
        return newEntries;
    }

    private IClasspathEntry[] getDefaultSourceFolder() {
        IPath path = this.javaProject.getPath().append("src");
        return new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)path)};
    }

    private IClasspathEntry[] getDefaultProjectEntry() {
        IClasspathEntry[] entries = new IClasspathEntry[required.length];
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < required.length) {
            IClasspathEntry entry;
            IProject project = root.getProject(required[i]);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath path = javaProject.getPath();
            entries[i] = entry = JavaCore.newProjectEntry((IPath)path, (IAccessRule[])new IAccessRule[0], (boolean)false, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
            ++i;
        }
        return entries;
    }

    private IPath getDefaultOutputFolder() {
        IPath path = this.javaProject.getPath().append("bin");
        return path;
    }

    private File getSrc() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(required[0]);
        Object path = project.getLocation();
        path = path != null ? path.append("../app/baseApp") : new Path("C:/nano/app/baseApp");
        File dir = new File(path.toOSString());
        return dir;
    }

    private File getDst() {
        IPath path = this.project.getLocation();
        File dir = new File(path.toOSString());
        return dir;
    }

    private void copy(File srcdir, File dstdir, String[] files) {
        int i = 0;
        while (i < files.length) {
            this.copy(new File(String.valueOf(srcdir.toString()) + File.separator + files[i]), new File(String.valueOf(dstdir.toString()) + File.separator + files[i]));
            ++i;
        }
    }

    private void copy(File src, File dst) {
        try {
            int c;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTop(IPath src, IPath dst) {
        int count = dst.matchingFirstSegments(src);
        StringBuilder sb = new StringBuilder();
        String[] dseg = dst.segments();
        int i = count;
        while (i < dseg.length) {
            sb.append("../");
            ++i;
        }
        String[] sseg = src.segments();
        int i2 = count;
        while (i2 < sseg.length) {
            sb.append(sseg[i2]).append("/");
            ++i2;
        }
        Path result = new Path(sb.toString());
        return result.toString();
    }

    private void modify(File src, String top) {
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(src)));
            while ((str = br.readLine()) != null) {
                if (str.equals("TOP = ../..")) {
                    sb.append("TOP = ").append(top).append("\n");
                    continue;
                }
                sb.append(str).append("\n");
            }
            br.close();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(src)));
            bw.write(sb.toString());
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void update() {
        File src = this.getSrc();
        File dst = this.getDst();
        this.copy(src, dst, nanoNewWizardConstants.COPY_FILES);
        String top = this.getTop(new Path(src.toString()).append("../.."), (IPath)new Path(dst.toString()));
        this.modify(new File(String.valueOf(dst.toString()) + File.separator + nanoNewWizardConstants.COPY_FILES[0]), top);
    }

    public boolean performFinish() {
        if (!this.initialized) {
            this.init();
        }
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.getRunnable().run((IProgressMonitor)monitor);
            if (!monitor.isCanceled()) {
                this.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

