/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.nano.plugin;

import jp.co.aplix.nano.plugin.C;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

final class TheLaunchTabMain
extends JavaLaunchTab {
    private static final String MYNAME = "\u30e1\u30a4\u30f3\u30fb\u30bf\u30d6";
    private Text textProjName;
    private Text textMethodName;
    private Text textIPAddr;
    private Text textSerialPort;
    private Button btnProj;
    private Button btnMethod;
    private Button radioTgtWin32;
    private Button radioTgtTCP;
    private Button radioTgtSerial;
    private Button btnTgtTcpCheck;
    private Button btnTgtSerialCheck;

    TheLaunchTabMain() {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            String serialName;
            String methodName;
            String projectName = configuration.getAttribute(C.LAUNCHATTR.KEY_PROJECT_NAME, "<unname>");
            if (this.textProjName != null) {
                this.textProjName.setText(projectName);
            }
            if ((methodName = configuration.getAttribute("NANO_INVOKE_METHOD", "")) != null) {
                this.textMethodName.setText(methodName);
            }
            String tgtDevice = configuration.getAttribute("NANO_TARGET_DEVICE", "NANO_TARGET_DEVICE_WINDOWS");
            this.xSetSelections(tgtDevice);
            String netName = configuration.getAttribute("NANO_NETWORK_ADDR", "localhost");
            if (netName != null) {
                this.textIPAddr.setText(netName);
            }
            if ((serialName = configuration.getAttribute("NANO_SERIAL_DEVICE", "COM1")) != null) {
                this.textSerialPort.setText(serialName);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, configuration);
        } else {
            configuration.setAttribute(C.LAUNCHATTR.KEY_PROJECT_NAME, "<unname>");
        }
        configuration.setAttribute("NANO_INVOKE_METHOD", "");
        configuration.setAttribute("NANO_TARGET_DEVICE", "NANO_TARGET_DEVICE_WINDOWS");
        configuration.setAttribute("NANO_NETWORK_ADDR", "localhost");
        configuration.setAttribute("NANO_SERIAL_DEVICE", "COM1");
    }

    private IJavaProject xRunProjectChooseDialog() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u9078\u629e");
        dialog.setMessage("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        try {
            dialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        IJavaProject javaProject = this.xGetJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        composite.setLayout((Layout)topLayout);
        ModifyListener modifer = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TheLaunchTabMain.this.updateLaunchConfigurationDialog();
            }
        };
        Group group = C.zMakeNewGroup(composite, "\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d(&P):", 2);
        this.textProjName = new Text((Composite)group, 2052);
        this.textProjName.setLayoutData((Object)new GridData(768));
        this.textProjName.addModifyListener(modifer);
        this.btnProj = new Button((Composite)group, 8);
        this.btnProj.setText("\u53c2\u7167(&B)...");
        this.btnProj.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String projName;
                IJavaProject proj = TheLaunchTabMain.this.xRunProjectChooseDialog();
                if (proj != null && !(projName = proj.getElementName()).equals(TheLaunchTabMain.this.textProjName.getText())) {
                    TheLaunchTabMain.this.textProjName.setText(projName);
                    TheLaunchTabMain.this.updateLaunchConfigurationDialog();
                }
            }
        });
        group = C.zMakeNewGroup(composite, "\u8d77\u52d5\u5bfe\u8c61\u30e1\u30bd\u30c3\u30c9(&I):", 2);
        this.textMethodName = new Text((Composite)group, 2052);
        this.textMethodName.setLayoutData((Object)new GridData(768));
        this.textMethodName.addModifyListener(modifer);
        this.btnMethod = new Button((Composite)group, 8);
        this.btnMethod.setText("\u691c\u7d22(&S)...");
        group = C.zMakeNewGroup(composite, "\u30bf\u30fc\u30b2\u30c3\u30c8\u30c7\u30d0\u30a4\u30b9\u9078\u629e(&T):", 1);
        this.radioTgtWin32 = new Button((Composite)group, 16);
        this.radioTgtWin32.setText("\u30a6\u30a3\u30f3\u30c9\u30a6\u30ba(&W)");
        this.radioTgtWin32.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TheLaunchTabMain.this.xSetSelections("NANO_TARGET_DEVICE_WINDOWS");
                TheLaunchTabMain.this.updateLaunchConfigurationDialog();
            }
        });
        this.radioTgtTCP = new Button((Composite)group, 16);
        this.radioTgtTCP.setText("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u63a5\u7d9a\u306e\u30ea\u30e2\u30fc\u30c8\u30fb\u30c7\u30d0\u30a4\u30b9(&N)");
        this.radioTgtTCP.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TheLaunchTabMain.this.xSetSelections("NANO_TARGET_DEVICE_NETWORK");
                TheLaunchTabMain.this.updateLaunchConfigurationDialog();
            }
        });
        this.radioTgtSerial = new Button((Composite)group, 16);
        this.radioTgtSerial.setText("\u30b7\u30ea\u30a2\u30eb\u63a5\u7d9a\u306e\u30ea\u30e2\u30fc\u30c8\u30fb\u30c7\u30d0\u30a4\u30b9(&C)");
        this.radioTgtSerial.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TheLaunchTabMain.this.xSetSelections("NANO_TARGET_DEVICE_SERIAL");
                TheLaunchTabMain.this.updateLaunchConfigurationDialog();
            }
        });
        group = C.zMakeNewGroup(composite, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30c7\u30d0\u30a4\u30b9\u306e\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u30a2\u30c9\u30ec\u30b9(&A):", 2);
        this.textIPAddr = new Text((Composite)group, 2052);
        this.textIPAddr.setLayoutData((Object)new GridData(768));
        this.textIPAddr.addModifyListener(modifer);
        this.btnTgtTcpCheck = new Button((Composite)group, 8);
        this.btnTgtTcpCheck.setText("\u30c1\u30a7\u30c3\u30af(&P)");
        group = C.zMakeNewGroup(composite, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30c7\u30d0\u30a4\u30b9\u306e\u30b7\u30ea\u30a2\u30eb\u30c7\u30d0\u30a4\u30b9\u9078\u629e(&B):", 2);
        this.textSerialPort = new Text((Composite)group, 2052);
        this.textSerialPort.setLayoutData((Object)new GridData(768));
        this.textSerialPort.addModifyListener(modifer);
        this.btnTgtSerialCheck = new Button((Composite)group, 8);
        this.btnTgtSerialCheck.setText("\u30c1\u30a7\u30c3\u30af(&Q)");
        this.setControl((Control)composite);
    }

    public String getName() {
        return MYNAME;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String projName = this.textProjName.getText().trim();
        configuration.setAttribute(C.LAUNCHATTR.KEY_PROJECT_NAME, projName);
        String methodName = this.textMethodName.getText().trim();
        configuration.setAttribute("NANO_INVOKE_METHOD", methodName);
        String tgtName = "NANO_TARGET_DEVICE_WINDOWS";
        if (!this.radioTgtWin32.getSelection()) {
            tgtName = this.radioTgtTCP.getSelection() ? "NANO_TARGET_DEVICE_NETWORK" : "NANO_TARGET_DEVICE_SERIAL";
        }
        configuration.setAttribute("NANO_TARGET_DEVICE", tgtName);
        String textNet = this.textIPAddr.getText().trim();
        configuration.setAttribute("NANO_NETWORK_ADDR", textNet);
        String textSerial = this.textSerialPort.getText().trim();
        configuration.setAttribute("NANO_SERIAL_DEVICE", textSerial);
    }

    private void xSetSelections(String newTargetDeviceName) {
        boolean fLocalEn = false;
        boolean fNetworkEn = false;
        boolean fSerialEn = false;
        if (newTargetDeviceName.equals("NANO_TARGET_DEVICE_WINDOWS")) {
            fLocalEn = true;
        } else if (newTargetDeviceName.equals("NANO_TARGET_DEVICE_NETWORK")) {
            fNetworkEn = true;
        } else if (newTargetDeviceName.equals("NANO_TARGET_DEVICE_SERIAL")) {
            fSerialEn = true;
        }
        this.radioTgtWin32.setSelection(fLocalEn);
        this.radioTgtTCP.setSelection(fNetworkEn);
        this.textIPAddr.setEnabled(fNetworkEn);
        this.btnTgtTcpCheck.setEnabled(fNetworkEn);
        this.radioTgtSerial.setSelection(fSerialEn);
        this.textSerialPort.setEnabled(fSerialEn);
        this.btnTgtSerialCheck.setEnabled(fSerialEn);
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    private IJavaProject xGetJavaProject() {
        String projectName = this.textProjName.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return C.zGetJavaProjectByName(projectName);
    }
}

