/*
 * Decompiled with CFR 0.152.
 */
package jp.co.aplix.nano.plugin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import jp.co.aplix.nano.plugin.C;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

final class ProjectWizardPage
extends JavaCapabilityConfigurationPage {
    private WizardNewProjectCreationPage mainpage;
    private IProjectDescription desc;
    private IProject project;
    private IJavaProject javaProject;
    private boolean fVisible;

    public ProjectWizardPage(WizardNewProjectCreationPage mainpage) {
        this.mainpage = mainpage;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            try {
                this.xInitJavaproject();
            }
            catch (CoreException coreException) {
                return;
            }
        }
        this.fVisible = visible;
        super.setVisible(visible);
    }

    public boolean zReqFinish(IWizardContainer container) {
        if (!this.fVisible) {
            try {
                this.xInitJavaproject();
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        this.desc = null;
        if (!this.mainpage.useDefaults()) {
            IPath projectLocationPath = this.mainpage.getLocationPath();
            this.desc = this.project.getWorkspace().newProjectDescription(this.project.getName());
            this.desc.setLocation(projectLocationPath);
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        ProjectWizardPage.this.project.create(ProjectWizardPage.this.desc, monitor);
                        ProjectWizardPage.this.project.open(monitor);
                        ProjectWizardPage.this.configureJavaProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            container.run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ex) {
            Throwable realException = ex.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        try {
            ProjectWizardPage.xAddNatureToProjectDescription(this.project, "org.eclipse.jdt.core.javanature");
        }
        catch (RuntimeException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error of the addition of nature:org.eclipse.jdt.core.javanature.", (String)e.getMessage());
            return false;
        }
        try {
            try {
                ProjectWizardPage.xAddNatureToProjectDescription(this.project, "NanoJBlendPlugin.Natures");
            }
            catch (RuntimeException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error of the addition of nature:NanoJBlendPlugin.Natures.", (String)e.getMessage());
                return false;
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
        }
        this.xSetupFinal();
        return true;
    }

    private static void xAddNatureToProjectDescription(IProject project, String natureId) throws CoreException {
        if (!project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            if (natureId.equals("NanoJBlendPlugin.Natures")) {
                System.arraycopy(natures, 0, newNatures, 1, natures.length);
                newNatures[0] = natureId;
            } else {
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = natureId;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }

    private void xSetupFinal() {
    }

    private void xInitJavaproject() throws CoreException {
        this.project = this.mainpage.getProjectHandle();
        this.javaProject = JavaCore.create((IProject)this.project);
        IPreferenceStore jdtstore = PreferenceConstants.getPreferenceStore();
        String srcFolderName = jdtstore.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName");
        String binFolderName = jdtstore.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
        boolean f = jdtstore.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
        Object srcFolder = !f || srcFolderName.length() == 0 ? this.project : this.project.getFolder(srcFolderName);
        Object binFolder = !f || binFolderName.length() == 0 ? this.project : this.project.getFolder(binFolderName);
        int numSourceEntries = 3;
        IClasspathEntry[] entries = new IClasspathEntry[numSourceEntries];
        IPath srcPath = srcFolder.getFullPath();
        IPath[] exclusionPatterns = new IPath[]{Path.fromPortableString((String)"**/.svn/*")};
        entries[0] = JavaCore.newSourceEntry((IPath)srcPath, (IPath[])exclusionPatterns);
        entries[1] = JavaCore.newSourceEntry((IPath)this.project.getFolder("res").getFullPath(), (IPath[])exclusionPatterns);
        entries[2] = JavaCore.newContainerEntry((IPath)new Path("NanoJBlendPlugin.BaseClasses"));
        try {
            this.init(this.javaProject, binFolder.getFullPath(), entries, true);
        }
        catch (Exception e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            e.printStackTrace(ps);
            byte[] ba = os.toByteArray();
            String msg = new String(ba);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)msg);
            C.zThrowCoreException("Error");
        }
    }
}

