/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.resourcearchiver;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class StructuredBinaryConcatenater {
    byte[] buf_;
    private final List<Element> elements_ = new ArrayList<Element>();
    private int offset_;

    public StructuredBinaryConcatenater(int n) {
        this.offset_ = n;
    }

    public void add(String string, InputStream inputStream, long l) {
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("length have to be less than 21474836471");
        }
        if (l <= 0L) {
            throw new RuntimeException("length have to be larger than 0");
        }
        this.elements_.add(new Element(string, inputStream, (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(OutputStream outputStream) throws IOException {
        this.buf_ = new byte[0x100000];
        try {
            int n = this.offset_;
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this.elements_.size());
            n += 4 + 4 * this.elements_.size();
            for (Element element : this.elements_) {
                dataOutputStream.writeInt(n);
                n += element.calcOutputSize();
            }
            for (Element element : this.elements_) {
                element.output(dataOutputStream);
            }
        }
        finally {
            this.buf_ = null;
        }
    }

    public void closeStreams() throws IOException {
        for (Element element : this.elements_) {
            element.getStream().close();
        }
    }

    private class Element {
        private byte[] slash_ = new byte[1];
        private InputStream is_;
        private int length_;
        private byte[] rawname_;
        private static final int NAMELENGTH_FIELD_SIZE = 2;
        private static final int DATALENGTH_FIELD_SIZE = 4;

        public Element(String string, InputStream inputStream, int n) {
            this.is_ = inputStream;
            this.length_ = n;
            try {
                this.rawname_ = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }

        public int calcOutputSize() {
            return 2 + this.rawname_.length + 1 + 4 + this.length_;
        }

        public void output(DataOutputStream dataOutputStream) throws IOException {
            int n;
            dataOutputStream.writeShort(this.rawname_.length + 1);
            this.slash_[0] = 47;
            dataOutputStream.write(this.slash_);
            dataOutputStream.write(this.rawname_);
            dataOutputStream.writeInt(this.length_);
            int n2 = StructuredBinaryConcatenater.this.buf_.length;
            for (int i = this.length_; i != 0; i -= n) {
                n = this.is_.read(StructuredBinaryConcatenater.this.buf_, 0, n2 < i ? n2 : i);
                if (n == -1) {
                    throw new RuntimeException("InputStream is too short");
                }
                dataOutputStream.write(StructuredBinaryConcatenater.this.buf_, 0, n);
            }
            dataOutputStream.flush();
        }

        public InputStream getStream() {
            return this.is_;
        }
    }
}

