/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.imageencoder;

import avm.romize.PixelInfo;
import avm.romize.imageencoder.ImageData;
import java.awt.image.BufferedImage;

public final class ImageDataR8G8B8
extends ImageData {
    private int[] d;
    private boolean hasColorKey = false;
    private int colorKey;

    public boolean hasTransparent() {
        return this.hasColorKey;
    }

    @Override
    public int getTransparentColor() {
        return this.colorKey;
    }

    ImageDataR8G8B8(BufferedImage bufferedImage) {
        this.w = bufferedImage.getWidth();
        this.h = bufferedImage.getHeight();
        this.d = bufferedImage.getRGB(0, 0, this.w, this.h, new int[this.w * this.h], 0, this.w);
        if (bufferedImage.getTransparency() == 2) {
            for (int n : this.d) {
                if ((n & 0xFF000000) != 0) continue;
                this.hasColorKey = true;
                this.colorKey = n;
                break;
            }
        }
    }

    @Override
    public Object getEncodedArrayData(PixelInfo pixelInfo) {
        return pixelInfo.cvtR8G8B8toDepend(this.d, this.w, this.h);
    }

    @Override
    public int getFlags() {
        return 0xFF0000 | (this.hasTransparent() ? 1024 : 0);
    }

    @Override
    public boolean isPalettedImage() {
        return false;
    }
}

