/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.imageencoder;

import avm.romize.PixelInfo;
import avm.romize.imageencoder.ImageData;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;

public final class ImageDataPaletted
extends ImageData {
    private int[] palette;
    private byte[] d;
    private int transparentIndex = -1;

    public ImageDataPaletted(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        this.w = bufferedImage.getWidth();
        this.h = bufferedImage.getHeight();
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        Raster raster = bufferedImage.getData();
        this.d = new byte[this.w * this.h];
        int n4 = 0;
        for (n3 = 0; n3 < this.h; ++n3) {
            n2 = 0;
            while (n2 < this.w) {
                n = raster.getSample(n2, n3, 0);
                this.d[n4] = (byte)n;
                ++n2;
                ++n4;
            }
        }
        n3 = indexColorModel.getMapSize();
        this.palette = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.palette[n2] = indexColorModel.getRGB(n2);
        }
        if (bufferedImage.getTransparency() == 2) {
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.palette[n2];
                if ((n & 0xFF000000) != 0) continue;
                this.transparentIndex = n2;
                break;
            }
        }
    }

    @Override
    public int getTransparentColor() {
        return this.transparentIndex;
    }

    @Override
    public Object getEncodedArrayData(PixelInfo pixelInfo) {
        return this.d;
    }

    @Override
    public Object getPaletteArrayData(PixelInfo pixelInfo) {
        return pixelInfo.cvtR8G8B8toDepend(this.palette, this.palette.length, 1);
    }

    @Override
    public int getFlags() {
        return 0xFF0000 | (this.transparentIndex == -1 ? 0 : 1024) | this.palette.length;
    }

    @Override
    public boolean isPalettedImage() {
        return true;
    }
}

