/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.imageencoder;

import avm.romize.PixelInfo;
import avm.romize.imageencoder.ImageDataPaletted;
import avm.romize.imageencoder.ImageDataR8G8B8;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class ImageData {
    static final int FLAG_PALETTE_MASK = 511;
    static final int FLAG_HAS_TRANSPARENT = 1024;
    static final int FLAG_ALPHA_MASK = 0xFF0000;
    static final boolean DEBUG_IMAGE = false;
    int w;
    int h;

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public abstract boolean isPalettedImage();

    public abstract int getTransparentColor();

    public abstract int getFlags();

    public abstract Object getEncodedArrayData(PixelInfo var1);

    public Object getPaletteArrayData(PixelInfo pixelInfo) {
        throw new RuntimeException();
    }

    protected ImageData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageData createImageData(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            if (!(bufferedImage.getColorModel() instanceof IndexColorModel)) {
                ImageDataR8G8B8 imageDataR8G8B8 = new ImageDataR8G8B8(bufferedImage);
                return imageDataR8G8B8;
            }
            ImageDataPaletted imageDataPaletted = new ImageDataPaletted(bufferedImage);
            return imageDataPaletted;
        }
        finally {
            byteArrayInputStream.close();
        }
    }
}

