/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.constantpool;

import avm.romize.RClass;
import avm.romize.RUTF8;
import avm.romize.constantpool.ConstantPoolElement;

public final class ConstantPools {
    private int[] tag;
    private ConstantPoolElement[] info;

    public ConstantPools(int n) {
        this.tag = new int[n];
        this.info = new ConstantPoolElement[n];
    }

    public int getTag(int n) {
        return this.tag[n];
    }

    public ConstantPoolElement getInfo(int n) {
        return this.info[n];
    }

    public void setClassResolved(int n, RClass rClass) {
        if (this.tag[n] != 7 || !this.info[n].equals(rClass.getAbsClassNameUTF8())) {
            throw new RuntimeException("wrong. clazz=" + rClass + " tag=" + this.tag[n] + " info=" + this.info[n]);
        }
        this.tag[n] = 23;
        this.info[n] = rClass;
    }

    public int getConstantPoolsCount() {
        return this.tag.length;
    }

    public void set(int n, int n2, ConstantPoolElement constantPoolElement) {
        this.tag[n] = n2;
        this.info[n] = constantPoolElement;
    }

    public RUTF8 get_utf8string(int n) {
        if (n > 0 && n < this.tag.length && this.tag[n] == 1) {
            return (RUTF8)this.info[n];
        }
        throw new RuntimeException("unknown");
    }

    public RUTF8 get_classname(int n) {
        if (n > 0 && n < this.tag.length) {
            if (this.tag[n] == 7) {
                return (RUTF8)this.info[n];
            }
            if (this.tag[n] == 23) {
                RClass rClass = (RClass)this.info[n];
                return rClass.getAbsClassNameUTF8();
            }
        }
        throw new RuntimeException("unknown");
    }
}

