/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.constantpool;

import avm.romize.FieldDef;
import avm.romize.MethodDef;
import avm.romize.RClass;
import avm.romize.RUTF8;
import avm.romize.constantpool.CPNameAndType;
import avm.romize.constantpool.ConstantPoolElement;
import avm.romize.constantpool.ConstantPools;

public final class CPFieldOrMethod
extends ConstantPoolElement {
    private final ConstantPools cpool_;
    private final int class_index;
    private final int name_and_type_index;

    public CPFieldOrMethod(ConstantPools constantPools, int n, int n2) {
        this.cpool_ = constantPools;
        this.class_index = n;
        this.name_and_type_index = n2;
    }

    public int getClassIndex() {
        return this.class_index;
    }

    public int getNameAndTypeIndex() {
        return this.name_and_type_index;
    }

    public String getTrueName() {
        RClass rClass;
        CPNameAndType cPNameAndType = (CPNameAndType)this.cpool_.getInfo(this.name_and_type_index);
        RUTF8 rUTF8 = cPNameAndType.name;
        RUTF8 rUTF82 = cPNameAndType.type;
        try {
            rClass = (RClass)this.cpool_.getInfo(this.class_index);
        }
        catch (ClassCastException classCastException) {
            RUTF8 rUTF83 = this.cpool_.get_classname(this.class_index);
            return rUTF83.convertToString() + "#" + rUTF8.convertToString() + rUTF82.convertToString();
        }
        return rClass.getAbsClassNameString() + "#" + rUTF8.convertToString() + rUTF82.convertToString();
    }

    public String getName() {
        RClass rClass;
        CPNameAndType cPNameAndType = (CPNameAndType)this.cpool_.getInfo(this.name_and_type_index);
        RUTF8 rUTF8 = cPNameAndType.name;
        RUTF8 rUTF82 = cPNameAndType.type;
        try {
            rClass = (RClass)this.cpool_.getInfo(this.class_index);
        }
        catch (ClassCastException classCastException) {
            return "<UNNECESSARY>#" + rUTF8.convertToString() + rUTF82.convertToString();
        }
        return rClass.getAbsClassNameString() + "#" + rUTF8.convertToString() + rUTF82.convertToString();
    }

    private static FieldDef find_own_field(RClass rClass, RUTF8 rUTF8, RUTF8 rUTF82) {
        FieldDef[] fieldDefArray;
        for (FieldDef fieldDef : fieldDefArray = rClass.getFields()) {
            if (!fieldDef.getName().equals(rUTF8) || !fieldDef.getDescriptor().equals(rUTF82)) continue;
            return fieldDef;
        }
        return null;
    }

    private static FieldDef find_interface_field(RClass rClass, RUTF8 rUTF8, RUTF8 rUTF82) {
        RClass[] rClassArray = rClass.getInterfaces();
        if (rClassArray != null) {
            for (RClass rClass2 : rClassArray) {
                FieldDef fieldDef = CPFieldOrMethod.find_own_field(rClass2, rUTF8, rUTF82);
                if (fieldDef != null) {
                    return fieldDef;
                }
                fieldDef = CPFieldOrMethod.find_interface_field(rClass2, rUTF8, rUTF82);
                if (fieldDef == null) continue;
                return fieldDef;
            }
        }
        return null;
    }

    private static FieldDef find_field(RClass rClass, RUTF8 rUTF8, RUTF8 rUTF82) {
        do {
            FieldDef fieldDef;
            if ((fieldDef = CPFieldOrMethod.find_own_field(rClass, rUTF8, rUTF82)) != null) {
                return fieldDef;
            }
            fieldDef = CPFieldOrMethod.find_interface_field(rClass, rUTF8, rUTF82);
            if (fieldDef == null) continue;
            return fieldDef;
        } while ((rClass = rClass.getSuperClass()) != null);
        return null;
    }

    public String getDetail(RClass rClass) {
        RClass rClass2 = (RClass)rClass.getConstantPools().getInfo(this.class_index);
        CPNameAndType cPNameAndType = (CPNameAndType)rClass.getConstantPools().getInfo(this.name_and_type_index);
        RUTF8 rUTF8 = cPNameAndType.name;
        RUTF8 rUTF82 = cPNameAndType.type;
        return rClass2.getAbsClassNameString() + "#" + rUTF8 + " - " + rUTF82;
    }

    public FieldDef resolveField(RClass rClass) {
        RClass rClass2 = (RClass)rClass.getConstantPools().getInfo(this.class_index);
        CPNameAndType cPNameAndType = (CPNameAndType)rClass.getConstantPools().getInfo(this.name_and_type_index);
        RUTF8 rUTF8 = cPNameAndType.name;
        RUTF8 rUTF82 = cPNameAndType.type;
        FieldDef fieldDef = CPFieldOrMethod.find_field(rClass2, rUTF8, rUTF82);
        return fieldDef;
    }

    public MethodDef resolveIFaceMethod(RClass rClass) {
        RClass rClass2 = (RClass)rClass.getConstantPools().getInfo(this.class_index);
        CPNameAndType cPNameAndType = (CPNameAndType)rClass.getConstantPools().getInfo(this.name_and_type_index);
        RUTF8 rUTF8 = cPNameAndType.name;
        RUTF8 rUTF82 = cPNameAndType.type;
        if (!rClass2.isInterface()) {
            throw new RuntimeException("IncompatibleClassChangeError in resolving interface method :" + rClass + "#" + rUTF8.convertToString() + rUTF82.convertToString());
        }
        MethodDef methodDef = CPFieldOrMethod.get_method_from_interface(rClass2, rUTF8, rUTF82);
        return methodDef;
    }

    public MethodDef resolveMethod(RClass rClass) {
        RClass rClass2 = (RClass)rClass.getConstantPools().getInfo(this.class_index);
        CPNameAndType cPNameAndType = (CPNameAndType)rClass.getConstantPools().getInfo(this.name_and_type_index);
        RUTF8 rUTF8 = cPNameAndType.name;
        RUTF8 rUTF82 = cPNameAndType.type;
        if (rClass2.isInterface()) {
            throw new RuntimeException("IncompatibleClassChangeError in resolving method :" + rClass + "#" + rUTF8.convertToString() + rUTF82.convertToString());
        }
        MethodDef methodDef = CPFieldOrMethod.get_method_from_class(rClass2, rUTF8, rUTF82);
        return methodDef;
    }

    public String toString() {
        return this.getTrueName();
    }

    private static MethodDef find_method(RClass rClass, RUTF8 rUTF8, RUTF8 rUTF82) {
        MethodDef[] methodDefArray;
        for (MethodDef methodDef : methodDefArray = rClass.getMethods()) {
            if (!methodDef.getName().equals(rUTF8) || !methodDef.getDescriptor().equals(rUTF82)) continue;
            return methodDef;
        }
        return null;
    }

    private static MethodDef find_from_methodtable(RClass rClass, RUTF8 rUTF8, RUTF8 rUTF82) {
        MethodDef[] methodDefArray = rClass.getVMethodTable();
        if (methodDefArray != null) {
            for (MethodDef methodDef : methodDefArray) {
                if (!methodDef.getName().equals(rUTF8) || !methodDef.getDescriptor().equals(rUTF82)) continue;
                return methodDef;
            }
        }
        return null;
    }

    private static MethodDef get_method_from_class(RClass rClass, RUTF8 rUTF8, RUTF8 rUTF82) {
        RClass rClass2 = rClass;
        boolean bl = rUTF8.convertToString().equals("<init>");
        do {
            MethodDef methodDef;
            if ((methodDef = CPFieldOrMethod.find_method(rClass, rUTF8, rUTF82)) != null) {
                return methodDef;
            }
            if (!bl) continue;
            throw new RuntimeException(rClass.getAbsClassNameString() + " doesn't have " + rUTF8.convertToString() + rUTF82.convertToString());
        } while ((rClass = rClass.getSuperClass()) != null);
        return CPFieldOrMethod.find_from_methodtable(rClass2, rUTF8, rUTF82);
    }

    private static MethodDef find_from_methoddefine(RClass rClass, RUTF8 rUTF8, RUTF8 rUTF82) {
        MethodDef methodDef = CPFieldOrMethod.find_method(rClass, rUTF8, rUTF82);
        if (methodDef == null) {
            RClass[] rClassArray;
            for (RClass rClass2 : rClassArray = rClass.getInterfaces()) {
                methodDef = CPFieldOrMethod.get_method_from_interface(rClass2, rUTF8, rUTF82);
                if (methodDef == null) continue;
                return methodDef;
            }
            if (methodDef == null) {
                RClass rClass3 = rClass.getClassLoader().findLoadedClass("java/lang/Object");
                methodDef = CPFieldOrMethod.find_method(rClass3, rUTF8, rUTF82);
            }
        }
        return methodDef;
    }

    private static MethodDef get_method_from_interface(RClass rClass, RUTF8 rUTF8, RUTF8 rUTF82) {
        MethodDef methodDef = CPFieldOrMethod.find_from_methodtable(rClass, rUTF8, rUTF82);
        if (methodDef == null) {
            methodDef = CPFieldOrMethod.find_from_methoddefine(rClass, rUTF8, rUTF82);
        }
        return methodDef;
    }
}

