/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.bytecode;

import avm.romize.BCODE;
import avm.romize.Bytep;
import avm.romize.C;
import avm.romize.Member;
import avm.romize.MethodDef;
import avm.romize.MyDataOutputStream;
import avm.romize.RClass;
import avm.romize.RClassLoader;
import avm.romize.RUTF8;
import avm.romize.TotalConstantPool;
import avm.romize.bytecode.B;
import avm.romize.bytecode.B_B;
import avm.romize.bytecode.B_GOTOorJSR;
import avm.romize.bytecode.B_IINC;
import avm.romize.bytecode.B_INVOKEINTERFACE;
import avm.romize.bytecode.B_LDC;
import avm.romize.bytecode.B_LOOKUPSWITCH;
import avm.romize.bytecode.B_MULTIANEWARRAY;
import avm.romize.bytecode.B_SIPUSH;
import avm.romize.bytecode.B_TABLESWITCH;
import avm.romize.bytecode.B_UB;
import avm.romize.bytecode.B_V;
import avm.romize.bytecode.B_cpindexUS;
import avm.romize.bytecode.B_offsetS;
import avm.romize.bytecode.B_wideIINC;
import avm.romize.bytecode.B_wideUS;
import avm.romize.constantpool.ConstantPoolElement;
import avm.romize.constantpool.ConstantPools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ByteCodes {
    MethodDef method;
    private RClassLoader loader;
    ConstantPools cpool;
    TotalConstantPool tcp;
    private B[] bcode;
    private int[] oldaddrs;
    private int[] newaddrs;
    private boolean sizechanged = false;
    private int addrindex = 0;
    private int codeLength = 0;

    private void addTotalConstantPool(int n) {
        int n2 = this.cpool.getTag(n);
        ConstantPoolElement constantPoolElement = this.cpool.getInfo(n);
        this.method.getOwner().getClassLoader().getTotalConstantPool().addElementZ(n2, constantPoolElement);
    }

    /*
     * WARNING - void declaration
     */
    public ByteCodes(MethodDef methodDef, byte[] byArray) {
        void var7_10;
        int n2;
        int n;
        this.method = methodDef;
        this.loader = methodDef.getOwner().getClassLoader();
        this.cpool = methodDef.getOwner().getConstantPools();
        this.tcp = this.loader.getTotalConstantPool();
        Vector<B> vector = new Vector<B>();
        Bytep bytep = new Bytep(byArray);
        while (bytep.get_index() != byArray.length) {
            n = bytep.get_index();
            n2 = bytep.get_u1();
            block0 : switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 100: 
                case 101: 
                case 104: 
                case 105: 
                case 108: 
                case 109: 
                case 112: 
                case 113: 
                case 116: 
                case 117: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 136: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 172: 
                case 173: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    vector.add(new B_V(this, n, n2));
                    break;
                }
                case 170: {
                    byte by = 0;
                    while ((bytep.get_index() & 3) != 0) {
                        by = (byte)(by + 1);
                        bytep.skip(1);
                    }
                    int n10 = bytep.get_u4();
                    int rUTF8 = bytep.get_u4();
                    int rUTF82 = bytep.get_u4();
                    int rClass2 = rUTF82 - rUTF8 + 1;
                    int[] nArray = bytep.getInts(rClass2);
                    vector.add(new B_TABLESWITCH(this, n, by, n10, rUTF8, rUTF82, nArray));
                    break;
                }
                case 171: {
                    byte by = 0;
                    int n11 = bytep.get_index();
                    while ((n11 & 3) != 0) {
                        by = (byte)(by + 1);
                        bytep.skip(1);
                        n11 = bytep.get_index();
                    }
                    int n14 = bytep.get_u4();
                    int n3 = bytep.get_u4();
                    int[] nArray = bytep.getInts(n3 * 2);
                    vector.add(new B_LOOKUPSWITCH(this, n, by, n14, n3, nArray));
                    break;
                }
                case 16: 
                case 188: {
                    vector.add(new B_B(this, n, n2, (byte)bytep.get_u1()));
                    break;
                }
                case 21: 
                case 22: 
                case 25: 
                case 54: 
                case 55: 
                case 58: 
                case 169: {
                    vector.add(new B_UB(this, n, n2, (byte)bytep.get_u1()));
                    break;
                }
                case 132: {
                    byte by = bytep.get_u1();
                    int rClass = bytep.get_u1();
                    vector.add(new B_IINC(this, n, by, (byte)rClass));
                    break;
                }
                case 17: {
                    vector.add(new B_SIPUSH(this, n, n2, (short)bytep.get_u2()));
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    vector.add(new B_offsetS(this, n, n2, (short)bytep.get_u2()));
                    break;
                }
                case 167: 
                case 168: {
                    vector.add(new B_GOTOorJSR(this, n, n2, (short)bytep.get_u2()));
                    break;
                }
                case 200: 
                case 201: {
                    vector.add(new B_GOTOorJSR(this, n, n2, bytep.get_u4()));
                    break;
                }
                case 197: {
                    byte by = bytep.get_u2();
                    int n12 = bytep.get_u1();
                    this.addTotalConstantPool(by);
                    vector.add(new B_MULTIANEWARRAY(this, n, by, (byte)n12));
                    break;
                }
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    RClass n13;
                    RUTF8 rUTF8;
                    RUTF8 rUTF82;
                    RClass rClass;
                    byte by = bytep.get_u2();
                    this.addTotalConstantPool(by);
                    if (n2 == 189 && (rClass = this.loader.requestArrayClass(rUTF82 = (rUTF8 = (n13 = (RClass)this.cpool.getInfo(by)).getAbsClassNameUTF8()).byteAt(0) == 91 || rUTF8.byteAt(0) == 76 && rUTF8.byteAt(rUTF8.length() - 1) == 59 ? new RUTF8("[" + rUTF8.convertToString()) : new RUTF8("[L" + rUTF8.convertToString() + ";"))).getClassLoader() != this.loader) {
                        this.tcp.addExternalClass(rClass);
                    }
                    vector.add(new B_cpindexUS(this, n, n2, by));
                    break;
                }
                case 19: {
                    byte by = bytep.get_u2();
                    if (this.cpool.getTag(by) == 23) {
                        throw new RuntimeException("Bytecode LDC_W with symbolic reference to a class is not supported.\nThe LDC_W is referring to class " + this.cpool.getInfo(by) + " in " + methodDef + ".");
                    }
                    this.addTotalConstantPool(by);
                    vector.add(new B_LDC(this, n, (short)by));
                    break;
                }
                case 185: {
                    byte by = bytep.get_u2();
                    int b = bytep.get_u1();
                    bytep.skip(1);
                    this.addTotalConstantPool(by);
                    vector.add(new B_INVOKEINTERFACE(this, n, by, (byte)b));
                    break;
                }
                case 18: {
                    byte by = bytep.get_u1();
                    if (this.cpool.getTag(by) == 23) {
                        throw new RuntimeException("Bytecode LDC with symbolic reference to a class is not supported.\nThe LDC is referring to class " + this.cpool.getInfo(by) + " in " + methodDef + ".");
                    }
                    this.addTotalConstantPool(by);
                    vector.add(new B_LDC(this, n, by));
                    break;
                }
                case 196: {
                    byte by = bytep.get_u1();
                    switch (by) {
                        case 21: 
                        case 22: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 58: 
                        case 169: {
                            int n4 = bytep.get_u2();
                            vector.add(new B_wideUS(this, n, by, (short)n4));
                            break block0;
                        }
                        case 132: {
                            int n4 = bytep.get_u2();
                            int n5 = bytep.get_u2();
                            vector.add(new B_wideIINC(this, n, (short)n4, (short)n5));
                            break block0;
                        }
                        case 23: 
                        case 24: 
                        case 56: 
                        case 57: {
                            if (!C.SUPPORT_FLOAT) break;
                            int n4 = bytep.get_u2();
                            vector.add(new B_wideUS(this, n, by, (short)n4));
                            break block0;
                        }
                    }
                    throw new RuntimeException("unsupport bytecode " + BCODE.getInstructionString(n2));
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 48: 
                case 49: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 81: 
                case 82: 
                case 98: 
                case 99: 
                case 102: 
                case 103: 
                case 106: 
                case 107: 
                case 110: 
                case 111: 
                case 114: 
                case 115: 
                case 118: 
                case 119: 
                case 134: 
                case 135: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 174: 
                case 175: {
                    if (!C.SUPPORT_FLOAT) {
                        throw new RuntimeException("This configuration is not support floating point instruction. bytecode " + BCODE.getInstructionString(n2) + ": 0x" + C.toHex2(n2));
                    }
                    vector.add(new B_V(this, n, n2));
                    break;
                }
                case 23: 
                case 24: 
                case 56: 
                case 57: {
                    if (!C.SUPPORT_FLOAT) {
                        throw new RuntimeException("This configuration is not support floating point instruction. bytecode " + BCODE.getInstructionString(n2) + ": 0x" + C.toHex2(n2));
                    }
                    vector.add(new B_UB(this, n, n2, (byte)bytep.get_u1()));
                    break;
                }
                default: {
                    throw new RuntimeException("unsupport bytecode " + BCODE.getInstructionString(n2) + ": 0x" + C.toHex2(n2));
                }
            }
        }
        this.bcode = new B[vector.size()];
        for (n = 0; n < this.bcode.length; ++n) {
            this.bcode[n] = (B)vector.elementAt(n);
        }
        B[] bArray = this.bcode;
        n2 = bArray.length;
        boolean bl = false;
        while (var7_10 < n2) {
            B b = bArray[var7_10];
            b.set_jmpaddr();
            ++var7_10;
        }
    }

    B findAddr(int n) {
        for (B b : this.bcode) {
            if (b.addr != n) continue;
            return b;
        }
        throw new RuntimeException();
    }

    public int oldToNew(int n) {
        int n2;
        if (!this.sizechanged) {
            return n;
        }
        for (n2 = 0; n2 < this.addrindex && n >= this.oldaddrs[n2]; ++n2) {
        }
        if (n2 == 0) {
            return n;
        }
        int n3 = this.newaddrs[n2 - 1] + n - this.oldaddrs[n2 - 1];
        return n3;
    }

    public String getCvtTblName() {
        if (this.sizechanged) {
            return this.method.getCodingName() + "_addrtbl";
        }
        return "NULL";
    }

    public int getCvtTblSize() {
        return this.addrindex;
    }

    public int output() {
        if (C.METHOD_REDUCTION && this.bcode.length == 0) {
            return 0;
        }
        boolean bl = false;
        for (B b : this.bcode) {
            int n = b.update();
            bl |= n;
        }
        if (bl) {
            this.sizechanged = true;
            int n = 0;
            for (B b : this.bcode) {
                n = b.readdressing(n);
            }
            bl = false;
            for (B b : this.bcode) {
                int n2 = b.updateJumpOffset();
                if (n2 == 0) continue;
                bl = true;
                throw new RuntimeException("not ready!");
            }
            this.oldaddrs = new int[this.bcode.length];
            this.newaddrs = new int[this.bcode.length];
            int n3 = 0;
            int n4 = 0;
            for (B b : this.bcode) {
                int n5 = b.addr;
                int n6 = b.org_addr;
                int n7 = n5 - n6;
                if (n3 == n7) continue;
                this.oldaddrs[n4] = n6;
                this.newaddrs[n4] = n5;
                ++n4;
                n3 = n7;
            }
            if (n4 == 0) {
                this.sizechanged = false;
            } else {
                this.addrindex = n4;
                this.loader.println("#if (JDWP == 1)");
                this.loader.println("static const AddrCvtTblT " + this.method.getCodingName() + "_addrtbl[] = {");
                for (int i = 0; i < n4; ++i) {
                    this.loader.println("\t{ 0x" + C.toHex4(this.oldaddrs[i]) + ", 0x" + C.toHex4(this.newaddrs[i]) + "},");
                }
                this.loader.println("};");
                this.loader.println("#endif");
            }
        }
        this.loader.println("#if (JDWP == 1)");
        this.loader.println("static nano_u1 " + this.method.getCodingName() + "_code[] = {");
        this.loader.println("#else");
        this.loader.println("static const nano_u1 " + this.method.getCodingName() + "_code[] = {");
        this.loader.println("#endif");
        int n = 0;
        for (B b : this.bcode) {
            n += b.writeText(this.loader);
        }
        this.loader.returnPrintHex();
        this.loader.println("};");
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void fix() {
        void var5_17;
        int n4;
        boolean bl = false;
        for (B bArray : this.bcode) {
            int n = bArray.update();
            if (n == 0) continue;
            bl = true;
        }
        if (bl) {
            void var5_13;
            void var5_11;
            this.sizechanged = true;
            int n = 0;
            B[] bArray = this.bcode;
            n4 = bArray.length;
            boolean bl2 = false;
            while (var5_11 < n4) {
                B b = bArray[var5_11];
                n = b.readdressing(n);
                ++var5_11;
            }
            bl = false;
            bArray = this.bcode;
            n4 = bArray.length;
            boolean bl3 = false;
            while (var5_13 < n4) {
                B b = bArray[var5_13];
                int n2 = b.updateJumpOffset();
                if (n2 != 0) {
                    bl = true;
                    throw new RuntimeException("not ready!");
                }
                ++var5_13;
            }
            this.oldaddrs = new int[this.bcode.length];
            this.newaddrs = new int[this.bcode.length];
            int n3 = 0;
            n4 = 0;
            for (B b : this.bcode) {
                int n5 = b.addr;
                int n6 = b.org_addr;
                int n7 = n5 - n6;
                if (n3 == n7) continue;
                this.oldaddrs[n4] = n6;
                this.newaddrs[n4] = n5;
                ++n4;
                n3 = n7;
            }
            if (n4 == 0) {
                this.sizechanged = false;
            } else {
                this.addrindex = n4;
            }
        }
        int n = 0;
        B[] bArray = this.bcode;
        n4 = bArray.length;
        boolean bl4 = false;
        while (var5_17 < n4) {
            B b = bArray[var5_17];
            n += b.getLength();
            ++var5_17;
        }
        this.codeLength = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputCAP(MyDataOutputStream myDataOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (B b : this.bcode) {
                b.writeBin(byteArrayOutputStream);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            myDataOutputStream.write(byArray);
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    public void outputAddrCvtTable(MyDataOutputStream myDataOutputStream) throws IOException {
        for (int i = 0; i < this.addrindex; ++i) {
            myDataOutputStream.writeVU(this.oldaddrs[i]);
            myDataOutputStream.writeVU(this.newaddrs[i]);
        }
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public void aaMarkByteCodes() {
        Vector<ConstantPoolElement> vector = new Vector<ConstantPoolElement>();
        for (B b : this.bcode) {
            b.aaMarkByteCode(vector);
        }
        RClassLoader rClassLoader = this.loader;
        ConstantPoolElement[] constantPoolElementArray = new ConstantPoolElement[vector.size()];
        vector.toArray(constantPoolElementArray);
        for (ConstantPoolElement constantPoolElement : constantPoolElementArray) {
            ConstantPoolElement constantPoolElement2;
            if (constantPoolElement instanceof MethodDef) {
                constantPoolElement2 = (MethodDef)constantPoolElement;
                if (((Member)constantPoolElement2).getOwner().getClassLoader() != rClassLoader) continue;
                ((MethodDef)constantPoolElement2).aaMarkMethod(this.method.isStatic());
                continue;
            }
            if (constantPoolElement instanceof RClass) {
                constantPoolElement2 = (RClass)constantPoolElement;
                if (((RClass)constantPoolElement2).getClassLoader() != rClassLoader) continue;
                ((RClass)constantPoolElement2).aaMarkClass();
                continue;
            }
            throw new RuntimeException("unexpected ConstantPoolElement:" + constantPoolElement);
        }
    }
}

