/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.bytecode;

import avm.romize.bytecode.B;
import avm.romize.bytecode.ByteCodes;

public final class B_TABLESWITCH
extends B {
    private byte padding;
    private int def;
    private int low;
    private int high;
    private int[] offsets;
    private B defcode;
    private B[] tgtcodes;
    private boolean updated = false;

    public B_TABLESWITCH(ByteCodes byteCodes, int n, byte by, int n2, int n3, int n4, int[] nArray) {
        super(byteCodes, n, 170, 1 + by + 12 + (n4 - n3 + 1) * 4);
        this.padding = by;
        this.def = n2;
        this.low = n3;
        this.high = n4;
        this.offsets = nArray;
    }

    @Override
    public int getBytes(byte[] byArray) {
        byArray[0] = B_TABLESWITCH.convertCode(this.code);
        int n = 1;
        byte by = 0;
        if (by < this.padding) {
            throw new RuntimeException("!!!" + this + ", padding:" + this.padding + ", updated:" + this.updated);
        }
        byArray[n++] = (byte)(this.def >> 24);
        byArray[n++] = (byte)(this.def >> 16);
        byArray[n++] = (byte)(this.def >> 8);
        byArray[n++] = (byte)(this.def >> 0);
        byArray[n++] = (byte)(this.low >> 24);
        byArray[n++] = (byte)(this.low >> 16);
        byArray[n++] = (byte)(this.low >> 8);
        byArray[n++] = (byte)(this.low >> 0);
        byArray[n++] = (byte)(this.high >> 24);
        byArray[n++] = (byte)(this.high >> 16);
        byArray[n++] = (byte)(this.high >> 8);
        byArray[n++] = (byte)(this.high >> 0);
        for (int n2 : this.offsets) {
            byArray[n++] = (byte)(n2 >> 24);
            byArray[n++] = (byte)(n2 >> 16);
            byArray[n++] = (byte)(n2 >> 8);
            byArray[n++] = (byte)(n2 >> 0);
        }
        return this.size;
    }

    @Override
    public boolean update() {
        this.updated = true;
        if (this.padding != 0) {
            this.updateCode(this.code, this.size - this.padding);
            this.padding = 0;
            return true;
        }
        return false;
    }

    @Override
    public void set_jmpaddr() {
        this.defcode = this.all.findAddr(this.addr + this.def);
        this.tgtcodes = new B[this.offsets.length];
        for (int i = 0; i < this.offsets.length; ++i) {
            int n = this.addr + this.offsets[i];
            this.tgtcodes[i] = this.all.findAddr(n);
        }
    }

    @Override
    public boolean updateJumpOffset() {
        this.def = this.defcode.addr - this.addr;
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = this.tgtcodes[i].addr - this.addr;
        }
        return false;
    }
}

