/*
 * Decompiled with CFR 0.152.
 */
package avm.romize.bytecode;

import avm.romize.bytecode.B;
import avm.romize.bytecode.ByteCodes;

public class B_LOOKUPSWITCH
extends B {
    private byte padding;
    private int def;
    private int npairs;
    private int[] match_offsets;
    private B defcode;
    private B[] tgtcodes;

    public B_LOOKUPSWITCH(ByteCodes byteCodes, int n, byte by, int n2, int n3, int[] nArray) {
        super(byteCodes, n, 171, 1 + by + 8 + n3 * 8);
        this.padding = by;
        this.def = n2;
        this.npairs = n3;
        this.match_offsets = nArray;
    }

    @Override
    public void set_jmpaddr() {
        this.defcode = this.all.findAddr(this.addr + this.def);
        this.tgtcodes = new B[this.match_offsets.length / 2];
        for (int i = 0; i < this.match_offsets.length / 2; ++i) {
            int n = this.addr + this.match_offsets[i * 2 + 1];
            this.tgtcodes[i] = this.all.findAddr(n);
        }
    }

    @Override
    public boolean update() {
        if (this.padding != 0) {
            this.updateCode(this.code, this.size - this.padding);
            this.padding = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean updateJumpOffset() {
        this.def = this.defcode.addr - this.addr;
        for (int i = 0; i < this.match_offsets.length / 2; ++i) {
            this.match_offsets[i * 2 + 1] = this.tgtcodes[i].addr - this.addr;
        }
        return false;
    }

    @Override
    public int getBytes(byte[] byArray) {
        byArray[0] = B_LOOKUPSWITCH.convertCode(this.code);
        int n = 1;
        for (int i = 0; i < this.padding; ++i) {
            byArray[n++] = 0;
        }
        byArray[n++] = (byte)(this.def >> 24);
        byArray[n++] = (byte)(this.def >> 16);
        byArray[n++] = (byte)(this.def >> 8);
        byArray[n++] = (byte)(this.def >> 0);
        byArray[n++] = (byte)(this.npairs >> 24);
        byArray[n++] = (byte)(this.npairs >> 16);
        byArray[n++] = (byte)(this.npairs >> 8);
        byArray[n++] = (byte)(this.npairs >> 0);
        for (int n2 : this.match_offsets) {
            byArray[n++] = (byte)(n2 >> 24);
            byArray[n++] = (byte)(n2 >> 16);
            byArray[n++] = (byte)(n2 >> 8);
            byArray[n++] = (byte)(n2 >> 0);
        }
        return this.size;
    }
}

