/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.MethodDef;
import avm.romize.RClass;
import avm.romize.RUTF8;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class UnnecessaryInfo {
    private Set<RUTF8> uClassNames = new HashSet<RUTF8>();
    private Set<RUTF8> notInstantiatedClassNames = new HashSet<RUTF8>();
    private Set<RUTF8> uMethodNames = new HashSet<RUTF8>();
    private Set<RUTF8> descriptorOnlyMethods_ = new HashSet<RUTF8>();
    private HashMap<RUTF8, RUTF8> resolveCache = new HashMap();
    private HashMap<RUTF8, String> nativeNames = new HashMap();
    private boolean isSecond = false;

    public void setSecond() {
        this.isSecond = true;
    }

    public boolean isSecond() {
        return this.isSecond;
    }

    public void addUnnecessaryClass(RClass rClass) {
        this.uClassNames.add(rClass.getAbsClassNameUTF8());
    }

    public void addNotInstantiatedClass(RClass rClass) {
        this.notInstantiatedClassNames.add(rClass.getAbsClassNameUTF8());
    }

    public void addUnnecessaryMethod(MethodDef methodDef) {
        this.uMethodNames.add(new RUTF8(methodDef.getAbsString()));
    }

    public void addDescriptorOnlyMethod(MethodDef methodDef) {
        this.descriptorOnlyMethods_.add(new RUTF8(methodDef.getAbsString()));
    }

    public RUTF8[] getUnnecessaryClasses() {
        RUTF8[] rUTF8Array = new RUTF8[this.uClassNames.size()];
        this.uClassNames.toArray(rUTF8Array);
        return rUTF8Array;
    }

    public RUTF8[] getUnnecessaryMethods() {
        RUTF8[] rUTF8Array = new RUTF8[this.uMethodNames.size()];
        this.uMethodNames.toArray(rUTF8Array);
        return rUTF8Array;
    }

    public void showResolveCache() {
        System.out.println("\nTable of the method resolvation.");
        Set<RUTF8> set = this.resolveCache.keySet();
        RUTF8[] rUTF8Array = new RUTF8[set.size()];
        set.toArray(rUTF8Array);
        for (RUTF8 rUTF8 : rUTF8Array) {
            RUTF8 rUTF82 = this.resolveCache.get(rUTF8);
            System.out.println(rUTF8.convertToString() + " => " + rUTF82.convertToString());
        }
    }

    public boolean isUnnecessaryClass(RClass rClass) {
        return this.uClassNames.contains(rClass.getAbsClassNameUTF8());
    }

    public boolean isUnnecessaryClass(RUTF8 rUTF8) {
        return this.uClassNames.contains(rUTF8);
    }

    public boolean isNotInstantiated(RClass rClass) {
        return this.notInstantiatedClassNames.contains(rClass.getAbsClassNameUTF8());
    }

    public boolean isUnnecessaryMethod(MethodDef methodDef) {
        return this.uMethodNames.contains(new RUTF8(methodDef.getAbsString()));
    }

    public boolean isUnnecessaryMethod(String string) {
        if (string.startsWith("<UNNECESSARY>")) {
            return true;
        }
        return this.uMethodNames.contains(new RUTF8(string));
    }

    public boolean isDescriptorOnlyMethod(String string) {
        return this.descriptorOnlyMethods_.contains(new RUTF8(string));
    }

    public boolean isUnnecessaryField(String string) {
        return string.startsWith("<UNNECESSARY>");
    }

    public void addMethodResolve(String string, MethodDef methodDef) {
        this.resolveCache.put(new RUTF8(string), new RUTF8(methodDef.getAbsString()));
    }

    public RUTF8 resolveFromCache(String string) {
        return this.resolveCache.get(new RUTF8(string));
    }

    public void addNativeNames(MethodDef methodDef, String string) {
        this.nativeNames.put(new RUTF8(methodDef.getAbsString()), string);
    }

    public String getNativeName(MethodDef methodDef) {
        return this.nativeNames.get(new RUTF8(methodDef.getAbsString()));
    }
}

