/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.C;
import avm.romize.MyDataOutputStream;
import avm.romize.Outputable;
import avm.romize.RClassLoader;
import avm.romize.RUTF8;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public final class TotalUTF8
implements Outputable {
    private Vector<RUTF8> vutf8 = new Vector();
    private RClassLoader loader;
    private int vcount;

    private boolean need_swapCmp(int n, int n2) {
        int n3;
        RUTF8 rUTF8 = this.vutf8.elementAt(n);
        RUTF8 rUTF82 = this.vutf8.elementAt(n2);
        int n4 = rUTF8.length();
        if (n4 != (n3 = rUTF82.length())) {
            return n4 > n3;
        }
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6 = rUTF8.byteAt(i) & 0xFF;
            if (n6 == (n5 = rUTF82.byteAt(i) & 0xFF)) continue;
            return n6 > n5;
        }
        throw new RuntimeException("same UTF8 added!");
    }

    private boolean need_swapCmp2(int n, int n2) {
        int n3;
        boolean bl;
        RUTF8 rUTF8 = this.vutf8.elementAt(n);
        RUTF8 rUTF82 = this.vutf8.elementAt(n2);
        boolean bl2 = rUTF8.isGeneral();
        if (bl2 != (bl = rUTF82.isGeneral())) {
            return bl;
        }
        int n4 = rUTF8.length();
        if (n4 != (n3 = rUTF82.length())) {
            return n4 > n3;
        }
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6 = rUTF8.byteAt(i) & 0xFF;
            if (n6 == (n5 = rUTF82.byteAt(i) & 0xFF)) continue;
            return n6 > n5;
        }
        throw new RuntimeException("same UTF8 added!");
    }

    private void sortWithJDWP() {
        this.vcount = this.vutf8.size();
        int n = 1;
        while (n < this.vcount) {
            n = n * 3 + 1;
        }
        while (n > 0) {
            for (int i = n; i < this.vcount; ++i) {
                for (int j = i; j >= n && this.need_swapCmp(j - n, j); j -= n) {
                    RUTF8 rUTF8 = this.vutf8.elementAt(j);
                    this.vutf8.set(j, this.vutf8.elementAt(j - n));
                    this.vutf8.set(j - n, rUTF8);
                }
            }
            n /= 3;
        }
    }

    private void sortWithoutJDWP() {
        int n;
        this.vcount = this.vutf8.size();
        int n2 = 1;
        while (n2 < this.vcount) {
            n2 = n2 * 3 + 1;
        }
        while (n2 > 0) {
            for (n = n2; n < this.vcount; ++n) {
                for (int i = n; i >= n2 && this.need_swapCmp2(i - n2, i); i -= n2) {
                    RUTF8 rUTF8 = this.vutf8.elementAt(i);
                    this.vutf8.set(i, this.vutf8.elementAt(i - n2));
                    this.vutf8.set(i - n2, rUTF8);
                }
            }
            n2 /= 3;
        }
        for (n = 0; n < this.vcount; ++n) {
            RUTF8 rUTF8 = this.vutf8.elementAt(n);
            if (rUTF8.isGeneral()) continue;
            this.vcount = n;
            break;
        }
    }

    private boolean need_swap(int n, int n2) {
        RUTF8 rUTF8 = this.vutf8.elementAt(n);
        RUTF8 rUTF82 = this.vutf8.elementAt(n2);
        boolean bl = rUTF8.isGeneral();
        boolean bl2 = rUTF82.isGeneral();
        return bl < bl2;
    }

    private void sort() {
        int n = 1;
        while (n < this.vutf8.size()) {
            n = n * 3 + 1;
        }
        while (n > 0) {
            for (int i = n; i < this.vutf8.size(); ++i) {
                for (int j = i; j >= n && this.need_swap(j - n, j); j -= n) {
                    RUTF8 rUTF8 = this.vutf8.elementAt(j);
                    this.vutf8.set(j, this.vutf8.elementAt(j - n));
                    this.vutf8.set(j - n, rUTF8);
                }
            }
            n /= 3;
        }
    }

    public TotalUTF8(RClassLoader rClassLoader) {
        this.loader = rClassLoader;
        this.addElementX(new RUTF8(""));
    }

    public void addElementByCodeVariableTable(RUTF8 rUTF8) {
        for (RUTF8 rUTF82 : this.vutf8) {
            if (!rUTF82.equals(rUTF8)) continue;
            return;
        }
        this.vutf8.addElement(rUTF8);
    }

    public void addElementX(RUTF8 rUTF8) {
        for (RUTF8 rUTF82 : this.vutf8) {
            if (!rUTF82.equals(rUTF8)) continue;
            rUTF82.setGeneral();
            return;
        }
        rUTF8.setGeneral();
        this.vutf8.addElement(rUTF8);
    }

    public String findUTF8(RUTF8 rUTF8) {
        if (C.FIXED_STRING) {
            if (rUTF8.length() == 0) {
                return "UTF8_TABLE[0]";
            }
            for (RUTF8 rUTF82 : this.vutf8) {
                if (!rUTF8.equals(rUTF82)) continue;
                return "UTF8_TABLE[" + rUTF82.getBindex() + "]";
            }
        } else {
            if (rUTF8.length() == 0) {
                return "UTF8_ZERO";
            }
            for (RUTF8 rUTF83 : this.vutf8) {
                if (!rUTF8.equals(rUTF83)) continue;
                return "UTF8_" + C.toHex4(rUTF83.getIndex());
            }
        }
        throw new RuntimeException("not defined UTF8:" + rUTF8);
    }

    public int getUTF8ID(RUTF8 rUTF8) {
        for (RUTF8 rUTF82 : this.vutf8) {
            if (!rUTF8.equals(rUTF82)) continue;
            return rUTF82.getIndex() + 1;
        }
        throw new RuntimeException("not defined UTF8:" + rUTF8);
    }

    public void finish(boolean bl) {
        if (bl) {
            this.sortWithJDWP();
        } else {
            this.sort();
        }
        this.setIndexAll();
    }

    private void setIndexAll() {
        int n = 0;
        for (RUTF8 rUTF8 : this.vutf8) {
            rUTF8.setIndex(n);
            ++n;
        }
    }

    public void outputCAP(MyDataOutputStream myDataOutputStream) throws IOException {
        int n = 1;
        myDataOutputStream.writeVU(this.vutf8.size());
        for (RUTF8 rUTF8 : this.vutf8) {
            myDataOutputStream.writeVU(rUTF8.length());
            myDataOutputStream.write(rUTF8.getBytes());
            ++n;
        }
    }

    static boolean isSjisKanji(byte by) {
        int n = by & 0xFF;
        return n >= 129 && (n <= 159 || n >= 224 && n <= 252);
    }

    static boolean isSjisKanji2(byte by) {
        int n = by & 0xFF;
        return n >= 64 && n <= 252 && n != 127;
    }

    static byte[] utf8_to_sjis(byte[] byArray, boolean bl) {
        int n;
        byte[] byArray2;
        try {
            String string = new String(byArray, "UTF8");
            byArray2 = string.getBytes("SJIS");
        }
        catch (Exception exception) {
            return null;
        }
        byte[] byArray3 = new byte[byArray2.length * 2];
        int n2 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            byte by;
            if (i + 1 < byArray2.length && TotalUTF8.isSjisKanji(byArray2[i]) && TotalUTF8.isSjisKanji2(byArray2[i + 1])) {
                n = byArray2[i];
                by = byArray2[i + 1];
                ++i;
            } else {
                n = 0;
                by = byArray2[i];
            }
            if (bl) {
                byArray3[n2++] = by;
                byArray3[n2++] = n;
                continue;
            }
            byArray3[n2++] = n;
            byArray3[n2++] = by;
        }
        byte[] byArray4 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray4[n] = byArray3[n];
        }
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputOnce(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            try {
                int n = 0;
                for (int i = 0; i < this.vcount; ++i) {
                    RUTF8 rUTF8 = this.vutf8.elementAt(i);
                    int n2 = rUTF8.length();
                    if (!C.FIXED_STRING) {
                        if (n2 == 0) {
                            this.loader.println("#define UTF8_ZERO UTF8_TABLE[" + n + "]");
                        } else {
                            this.loader.println("#define UTF8_" + C.toHex4(rUTF8.getIndex()) + " UTF8_TABLE[" + n + "]");
                        }
                    } else {
                        rUTF8.setBindex(n);
                    }
                    byte[] byArray = rUTF8.getBytes();
                    int n3 = n2 = byArray.length;
                    if (bl) {
                        dataOutputStream.writeChar(n3 << 8 | n3 >>> 8);
                    } else {
                        dataOutputStream.writeChar(n3);
                    }
                    dataOutputStream.write(byArray);
                    n += 2 + n2;
                    if ((n2 & 1) == 0) continue;
                    dataOutputStream.writeByte(0);
                    ++n;
                }
            }
            finally {
                dataOutputStream.close();
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.loader.println("static const unsigned char UTF8_TABLE[] = {");
                this.loader.printlnHexBytes(byArray);
                this.loader.println("};");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    @Override
    public void outputClassData() {
        this.finish(false);
        if (C.ENDIAN == 1) {
            this.loader.println("#if !defined(NANO_BIG_ENDIAN)");
            this.loader.println("  #error \"NANO_BIG_ENDIAN not defined.\"");
            this.loader.println("#endif");
        } else if (C.ENDIAN == 0) {
            this.loader.println("#if !defined(NANO_LITTLE_ENDIAN)");
            this.loader.println("  #error \"NANO_LITTLE_ENDIAN not defined.\"");
            this.loader.println("#endif");
        } else {
            this.loader.println("#if !defined(NANO_LITTLE_ENDIAN) && !defined(NANO_BIG_ENDIAN)");
            this.loader.println("  #error \"NANO_LITTLE_ENDIAN, NANO_BIG_ENDIAN not defined.\"");
            this.loader.println("#endif");
        }
        if (C.JDWP == 1) {
            this.loader.println("#if (JDWP != 1)");
            this.loader.println("  #error \"JDWP != 1\"");
            this.loader.println("#endif");
        } else if (C.JDWP == 0) {
            this.loader.println("#if (JDWP != 0)");
            this.loader.println("  #error \"JDWP != 0\"");
            this.loader.println("#endif");
        }
        if (C.ENDIAN == -1) {
            this.sortWithoutJDWP();
            this.loader.println("#if defined(NANO_BIG_ENDIAN) && (JDWP == 0)");
            this.outputOnce(false);
            this.loader.println("#elif defined(NANO_LITTLE_ENDIAN) && (JDWP == 0)");
            this.outputOnce(true);
            this.sortWithJDWP();
            this.loader.println("#elif defined(NANO_BIG_ENDIAN) && (JDWP == 1)");
            this.outputOnce(false);
            this.loader.println("#elif defined(NANO_LITTLE_ENDIAN) && (JDWP == 1)");
            this.outputOnce(true);
            this.loader.println("#endif");
        } else {
            boolean bl;
            boolean bl2 = bl = C.ENDIAN == 0;
            if (C.JDWP == -1) {
                this.loader.println("#if (JDWP == 0)");
            }
            if (C.JDWP != 1) {
                this.sortWithoutJDWP();
                this.outputOnce(bl);
            }
            if (C.JDWP == -1) {
                this.loader.println("#else");
            }
            if (C.JDWP != 0) {
                this.sortWithJDWP();
                this.outputOnce(bl);
            }
            if (C.JDWP == -1) {
                this.loader.println("#endif");
            }
        }
    }

    @Override
    public String getCodingName() {
        throw new RuntimeException();
    }
}

