/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.C;
import avm.romize.FieldDef;
import avm.romize.Member;
import avm.romize.MethodDef;
import avm.romize.MethodDefAbstractFake;
import avm.romize.MyDataOutputStream;
import avm.romize.Outputable;
import avm.romize.RClass;
import avm.romize.RClassHashtable;
import avm.romize.RClassLoader;
import avm.romize.RUCS2;
import avm.romize.RUTF8;
import avm.romize.constantpool.CPDouble;
import avm.romize.constantpool.CPFieldOrMethod;
import avm.romize.constantpool.CPFloat;
import avm.romize.constantpool.CPInt;
import avm.romize.constantpool.CPLong;
import avm.romize.constantpool.ConstantPoolElement;
import avm.romize.constantpool.ConstantPools;
import java.io.IOException;
import java.util.Vector;

public final class TotalConstantPool
implements Outputable {
    private Vector<Integer> vtag = new Vector();
    private Vector<ConstantPoolElement> vinfo = new Vector();
    private Vector<Integer> vcount = new Vector();
    private int[] gindex;
    private RClassLoader loader;
    private int string_end;
    private int long_start;
    private int num_cp_string = 0;
    private int num_cp_int = 0;
    private int num_cp_float = 0;
    private int num_cp_long = 0;
    private int num_cp_double = 0;
    private int num_cp_classes = 0;
    private int num_cp_fields = 0;
    private int num_cp_methods = 0;
    private int num_cp = 0;
    private RClass[] ext_classes;
    private MethodDef[] ext_methods;
    private FieldDef[] ext_fields;
    private int num_notimpl_methods = 0;
    RClassHashtable extraExternalClasses = new RClassHashtable();

    private int point(int n) {
        int n2 = this.vtag.elementAt(n);
        int n3 = 0;
        switch (n2) {
            case 8: {
                n3 = 65536;
                if (!C.CP_STRING_KEEP_AS_UCS2) break;
                n3 |= ((RUCS2)this.vinfo.elementAt(n)).getIndex();
                break;
            }
            case 3: {
                n3 = 131072;
                break;
            }
            case 4: {
                n3 = 196608;
                break;
            }
            case 5: {
                n3 = 262144;
                break;
            }
            case 6: {
                n3 = 327680;
                break;
            }
            case 23: {
                n3 = 393216;
                break;
            }
            case 25: {
                n3 = 655360;
                break;
            }
            case 89: {
                n3 = 720896;
                break;
            }
            case 153: {
                n3 = 786432;
                break;
            }
            case 217: {
                n3 = 851968;
                break;
            }
            case 57: {
                n3 = 917504;
                break;
            }
            case 121: {
                n3 = 983040;
                break;
            }
            case 26: {
                n3 = 0x140000;
            }
        }
        return n3;
    }

    private boolean need_swap(int n, int n2) {
        return this.point(n) > this.point(n2);
    }

    public void sort() {
        int n = 1;
        while (n < this.vinfo.size()) {
            n = n * 3 + 1;
        }
        while (n > 0) {
            for (int i = n; i < this.vinfo.size(); ++i) {
                for (int j = i; j >= n && this.need_swap(j - n, j); j -= n) {
                    Integer n2 = this.vtag.elementAt(j);
                    ConstantPoolElement constantPoolElement = this.vinfo.elementAt(j);
                    Integer n3 = this.vcount.elementAt(j);
                    this.vtag.set(j, this.vtag.elementAt(j - n));
                    this.vinfo.set(j, this.vinfo.elementAt(j - n));
                    this.vcount.set(j, this.vcount.elementAt(j - n));
                    this.vtag.set(j - n, n2);
                    this.vinfo.set(j - n, constantPoolElement);
                    this.vcount.set(j - n, n3);
                }
            }
            n /= 3;
        }
    }

    private void incCount(int n) {
        Integer n2 = this.vcount.elementAt(n);
        this.vcount.set(n, new Integer(n2 + 1));
    }

    public boolean addElementZ(int n, ConstantPoolElement constantPoolElement) {
        if (C.METHOD_REDUCTION) {
            if (n == 9) {
                return true;
            }
            if (n == 10) {
                return true;
            }
        }
        block7: for (int i = 0; i < this.vtag.size(); ++i) {
            Integer n2 = this.vtag.elementAt(i);
            if (n2 != n) continue;
            ConstantPoolElement constantPoolElement2 = this.vinfo.elementAt(i);
            switch (n2) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 12: 
                case 23: 
                case 25: 
                case 26: 
                case 57: 
                case 89: 
                case 121: 
                case 153: 
                case 217: {
                    if (!constantPoolElement2.equals(constantPoolElement)) continue block7;
                    this.incCount(i);
                    return true;
                }
                default: {
                    throw new RuntimeException("has unresolve constantpool!, tag:" + C.getTypeName(n2) + "(" + constantPoolElement + ")");
                }
            }
        }
        if (!C.CP_STRING_KEEP_AS_UCS2 && n == 8) {
            this.loader.getTotalUTF8().addElementX((RUTF8)constantPoolElement);
        }
        switch (n) {
            case 23: {
                if (((RClass)constantPoolElement).getClassLoader() == this.loader) break;
                this.loader.getTotalUTF8().addElementX(((RClass)constantPoolElement).getAbsClassNameUTF8());
                break;
            }
            case 25: 
            case 26: 
            case 57: 
            case 89: 
            case 121: 
            case 153: 
            case 217: {
                if (((Member)constantPoolElement).getOwner().getClassLoader() == this.loader) break;
                this.loader.getTotalUTF8().addElementX(((Member)constantPoolElement).getName());
                this.loader.getTotalUTF8().addElementX(((Member)constantPoolElement).getDescriptor());
            }
        }
        this.vtag.add(new Integer(n));
        this.vinfo.add(constantPoolElement);
        this.vcount.add(new Integer(1));
        return false;
    }

    TotalConstantPool(RClassLoader rClassLoader) {
        this.loader = rClassLoader;
    }

    public void dump() {
    }

    public ConstantPoolElement getInfo(int n) {
        for (int i = 0; i < this.gindex.length; ++i) {
            if (this.gindex[i] != n) continue;
            return this.vinfo.elementAt(i);
        }
        throw new RuntimeException("There is no element for index=" + n);
    }

    public int findGlobalIndex(ConstantPools constantPools, int n) {
        if (n == 0) {
            return 0;
        }
        ConstantPoolElement constantPoolElement = constantPools.getInfo(n & 0xFFFF);
        int n2 = constantPools.getTag(n & 0xFFFF);
        if (C.METHOD_REDUCTION && constantPoolElement instanceof CPFieldOrMethod) {
            return 0;
        }
        for (int i = 0; i < this.vtag.size(); ++i) {
            if (this.vtag.elementAt(i) != n2 || !this.vinfo.elementAt(i).equals(constantPoolElement)) continue;
            if (this.gindex == null) {
                this.createGlobalIndex();
            }
            return this.gindex[i];
        }
        throw new RuntimeException("GlobalConstantPool index is not found! tag:" + C.getTypeName(n2) + ", info:" + constantPoolElement);
    }

    private void createGlobalIndex() {
        int n = -1;
        int n2 = 65535;
        int n3 = 1;
        this.gindex = new int[this.vinfo.size()];
        int n4 = 0;
        while (n4 < this.vinfo.size()) {
            ConstantPoolElement constantPoolElement = this.vinfo.get(n4);
            this.gindex[n4] = n3;
            if (constantPoolElement instanceof CPLong) {
                if (n3 < n2) {
                    n2 = n3;
                }
                ++n3;
                ++this.num_cp_long;
            } else if (constantPoolElement instanceof CPDouble) {
                if (n3 < n2) {
                    n2 = n3;
                }
                ++n3;
                ++this.num_cp_double;
            } else if (constantPoolElement instanceof CPInt) {
                ++this.num_cp_int;
            } else if (constantPoolElement instanceof CPFloat) {
                ++this.num_cp_float;
            } else if (constantPoolElement instanceof RUTF8 || constantPoolElement instanceof RUCS2) {
                ++this.num_cp_string;
                n = n3 + 1;
            } else if (constantPoolElement instanceof RClass) {
                ++this.num_cp_classes;
            } else if (constantPoolElement instanceof FieldDef) {
                ++this.num_cp_fields;
            } else if (constantPoolElement instanceof MethodDef) {
                ++this.num_cp_methods;
            }
            ++n4;
            ++n3;
        }
        this.num_cp = n3 - 1;
        if (this.num_cp != this.num_cp_string + this.num_cp_int + this.num_cp_float + this.num_cp_long * 2 + this.num_cp_double * 2 + this.num_cp_classes + this.num_cp_fields + this.num_cp_methods) {
            throw new RuntimeException("unknown error!");
        }
        if (n == -1) {
            n = 0;
        }
        this.string_end = n;
        this.long_start = n2;
    }

    @Override
    public void outputClassData() {
        if (this.gindex == null) {
            this.createGlobalIndex();
        }
        this.loader.println("\n\n\nstatic const nano_u4 TotalConstantPool[] = {");
        this.loader.println("\t0x00000000,\t\t\t\t\t\t\t// [0000] Dummy for Zero index.");
        for (int i = 0; i < this.vinfo.size(); ++i) {
            ConstantPoolElement constantPoolElement = this.vinfo.get(i);
            int n = this.vtag.get(i);
            if (constantPoolElement instanceof CPLong) {
                long l = ((CPLong)constantPoolElement).getValue();
                this.loader.println("\t0x" + C.toHex8((int)(l >> 32)) + "LU, 0x" + C.toHex8((int)l) + "LU,\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] LONG: " + l);
                continue;
            }
            if (constantPoolElement instanceof CPDouble) {
                long l = ((CPDouble)constantPoolElement).getValue();
                double d = ((CPDouble)constantPoolElement).getDoubleValue();
                if (C.ENDIAN == 1) {
                    this.loader.println("\t0x" + C.toHex8((int)(l >> 32)) + "LU, 0x" + C.toHex8((int)l) + "LU,\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] DOUBLE: " + d);
                    continue;
                }
                if (C.ENDIAN == 0) {
                    this.loader.println("\t0x" + C.toHex8((int)l) + "LU, 0x" + C.toHex8((int)(l >> 32)) + "LU,\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] DOUBLE: " + d);
                    continue;
                }
                this.loader.println("#if defined(NANO_BIG_ENDIAN)");
                this.loader.println("\t0x" + C.toHex8((int)(l >> 32)) + "LU, 0x" + C.toHex8((int)l) + "LU,\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] DOUBLE: " + d);
                this.loader.println("#elif defined(NANO_LITTLE_ENDIAN)");
                this.loader.println("\t0x" + C.toHex8((int)l) + "LU, 0x" + C.toHex8((int)(l >> 32)) + "LU,\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] DOUBLE: " + d);
                this.loader.println("#endif");
                continue;
            }
            if (constantPoolElement instanceof CPInt) {
                int n2 = ((CPInt)constantPoolElement).getValue();
                this.loader.println("\t0x" + C.toHex8(n2) + "LU,\t\t\t\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] INT: " + n2);
                continue;
            }
            if (constantPoolElement instanceof CPFloat) {
                int n3 = ((CPFloat)constantPoolElement).getValue();
                float f = ((CPFloat)constantPoolElement).getFloatValue();
                this.loader.println("\t0x" + C.toHex8(n3) + "LU,\t\t\t\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] FLOAT: " + f);
                continue;
            }
            if (constantPoolElement instanceof RUTF8) {
                if (C.CP_STRING_KEEP_AS_UCS2) {
                    throw new RuntimeException("utf8 was found in constant pool:" + constantPoolElement);
                }
                String string = this.loader.getTotalUTF8().findUTF8((RUTF8)constantPoolElement);
                this.loader.println("\t(nano_u4) &" + string + ",\t\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] String: " + constantPoolElement);
                continue;
            }
            if (constantPoolElement instanceof RUCS2) {
                if (!C.CP_STRING_KEEP_AS_UCS2) {
                    throw new RuntimeException("bad condition");
                }
                String string = this.loader.getTotalCPString().findUCS2((RUCS2)constantPoolElement);
                this.loader.println("\t(nano_u4) &" + string + ",\t\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] String: " + constantPoolElement);
                continue;
            }
            if (constantPoolElement instanceof RClass) {
                String string = ((RClass)constantPoolElement).getCodingName();
                this.loader.println("\t(nano_u4) &" + string + ",\t\t\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] Class: " + constantPoolElement);
                continue;
            }
            if (constantPoolElement instanceof FieldDef) {
                String string = ((FieldDef)constantPoolElement).getCodingName();
                this.loader.println("\t(nano_u4) &" + string + ",\t\t\t\t// [" + C.toHex4(this.gindex[i]) + "] " + C.getTypeName(n) + ": " + constantPoolElement);
                continue;
            }
            if (!(constantPoolElement instanceof MethodDef)) continue;
            String string = ((MethodDef)constantPoolElement).getCodingName();
            this.loader.println("\t(nano_u4) &" + string + ",\t\t\t// [" + C.toHex4(this.gindex[i]) + "] " + C.getTypeName(n) + ": " + constantPoolElement);
        }
        this.loader.println("};");
        this.loader.println("#define CP_STRING_END_INDEX    0x" + C.toHex4(this.string_end));
        this.loader.println("#define CP_LONG_START_INDEX    0x" + C.toHex4(this.long_start));
    }

    @Override
    public String getCodingName() {
        return "TotalConstantPool";
    }

    public RClass[] getExternalClasses() {
        return this.ext_classes;
    }

    public MethodDef[] getExternalMethods() {
        return this.ext_methods;
    }

    public FieldDef[] getExternalFields() {
        return this.ext_fields;
    }

    /*
     * WARNING - void declaration
     */
    private void getExternal() {
        int n;
        void var10_23;
        int n2;
        Object object;
        RClass[] rClassArray;
        Vector<MethodDef> vector = new Vector<MethodDef>();
        Vector<FieldDef> vector2 = new Vector<FieldDef>();
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        for (RClass constantPoolElement2 : rClassArray = this.loader.getAllClasses()) {
            RClass rClass = constantPoolElement2.getSuperClass();
            if (rClass.getClassLoader() != this.loader) {
                this.extraExternalClasses.put(rClass.getAbsClassNameUTF8(), rClass);
            }
            object = constantPoolElement2.getInterfaces();
            for (RClass rClass2 : object) {
                if (rClass2.getClassLoader() == this.loader) continue;
                this.extraExternalClasses.put(rClass2.getAbsClassNameUTF8(), rClass2);
            }
        }
        for (n2 = 0; n2 < this.vinfo.size(); ++n2) {
            FieldDef fieldDef;
            ConstantPoolElement constantPoolElement3 = this.vinfo.get(n2);
            if (constantPoolElement3 instanceof RClass) {
                RClass rClass = (RClass)constantPoolElement3;
                if (rClass.getClassLoader() == this.loader) continue;
                this.extraExternalClasses.put(rClass.getAbsClassNameUTF8(), rClass);
                continue;
            }
            if (constantPoolElement3 instanceof MethodDef) {
                MethodDef methodDef = (MethodDef)constantPoolElement3;
                if (methodDef.getOwner().getClassLoader() != this.loader && !vector.contains(methodDef)) {
                    vector.addElement(methodDef);
                    ++n3;
                    RClass rClass = methodDef.getOwner();
                    this.extraExternalClasses.put(rClass.getAbsClassNameUTF8(), rClass);
                }
                if (!(methodDef instanceof MethodDefAbstractFake)) continue;
                ++this.num_notimpl_methods;
                MethodDefAbstractFake methodDefAbstractFake = (MethodDefAbstractFake)methodDef;
                MethodDef methodDef2 = methodDefAbstractFake.getOriginalMethod();
                object = methodDef2.getOwner();
                if (((RClass)object).getClassLoader() == this.loader || vector.contains(methodDef)) continue;
                vector.addElement(methodDef2);
                ++n3;
                this.extraExternalClasses.put(((RClass)object).getAbsClassNameUTF8(), (RClass)object);
                continue;
            }
            if (!(constantPoolElement3 instanceof FieldDef) || (fieldDef = (FieldDef)constantPoolElement3).getOwner().getClassLoader() == this.loader || vector2.contains(fieldDef)) continue;
            vector2.addElement(fieldDef);
            ++n4;
            RClass rClass = fieldDef.getOwner();
            this.extraExternalClasses.put(rClass.getAbsClassNameUTF8(), rClass);
        }
        this.ext_classes = this.extraExternalClasses.getAllClasses();
        n2 = 1;
        RClass[] rClassArray2 = this.ext_classes;
        int n5 = rClassArray2.length;
        boolean bl2 = false;
        while (var10_23 < n5) {
            RClass rClass = rClassArray2[var10_23];
            rClass.setClassID(n2);
            ++n2;
            ++var10_23;
        }
        this.ext_methods = new MethodDef[vector.size()];
        for (n = 0; n < this.ext_methods.length; ++n) {
            this.ext_methods[n] = (MethodDef)vector.get(n);
            this.ext_methods[n].setMethodID(n + 1);
        }
        this.ext_fields = new FieldDef[vector2.size()];
        for (n = 0; n < this.ext_fields.length; ++n) {
            this.ext_fields[n] = (FieldDef)vector2.get(n);
            this.ext_fields[n].setFieldID(n + 1);
        }
    }

    public void finish() {
        if (this.gindex == null) {
            this.createGlobalIndex();
            this.getExternal();
        }
    }

    public int getNumberOfConstantPools() {
        return this.num_cp;
    }

    public void outputCAPGeneral(MyDataOutputStream myDataOutputStream) throws IOException {
        int n;
        ConstantPoolElement constantPoolElement;
        int n2 = 0;
        myDataOutputStream.writeVU(this.num_cp_string);
        for (n2 = 0; n2 < this.vinfo.size(); ++n2) {
            constantPoolElement = this.vinfo.get(n2);
            if (C.CP_STRING_KEEP_AS_UCS2) {
                if (constantPoolElement instanceof RUCS2) continue;
                break;
            }
            if (!(constantPoolElement instanceof RUTF8)) break;
            n = this.loader.getTotalUTF8().getUTF8ID((RUTF8)constantPoolElement);
            myDataOutputStream.writeVU(n);
        }
        myDataOutputStream.writeVU(this.num_cp_int);
        while (n2 < this.vinfo.size() && (constantPoolElement = this.vinfo.get(n2)) instanceof CPInt) {
            n = ((CPInt)constantPoolElement).getValue();
            myDataOutputStream.writeInt(n);
            ++n2;
        }
        if (C.SUPPORT_FLOAT) {
            myDataOutputStream.writeVU(this.num_cp_float);
            while (n2 < this.vinfo.size() && (constantPoolElement = this.vinfo.get(n2)) instanceof CPFloat) {
                n = ((CPFloat)constantPoolElement).getValue();
                myDataOutputStream.writeInt(n);
                ++n2;
            }
        }
        myDataOutputStream.writeVU(this.num_cp_long);
        while (n2 < this.vinfo.size() && (constantPoolElement = this.vinfo.get(n2)) instanceof CPLong) {
            long l = ((CPLong)constantPoolElement).getValue();
            myDataOutputStream.writeLong(l);
            ++n2;
        }
        if (C.SUPPORT_FLOAT) {
            myDataOutputStream.writeVU(this.num_cp_double);
            while (n2 < this.vinfo.size() && (constantPoolElement = this.vinfo.get(n2)) instanceof CPDouble) {
                long l = ((CPDouble)constantPoolElement).getValue();
                myDataOutputStream.writeLong(l);
                ++n2;
            }
        }
    }

    public void outputCAPClasses(MyDataOutputStream myDataOutputStream) throws IOException {
        ConstantPoolElement constantPoolElement;
        int n;
        for (n = 0; n < this.vinfo.size() && ((constantPoolElement = this.vinfo.get(n)) instanceof RUCS2 || constantPoolElement instanceof RUTF8 || constantPoolElement instanceof CPInt || constantPoolElement instanceof CPLong || constantPoolElement instanceof CPFloat || constantPoolElement instanceof CPDouble); ++n) {
        }
        myDataOutputStream.writeVU(this.num_cp_classes);
        while (n < this.vinfo.size() && (constantPoolElement = this.vinfo.get(n)) instanceof RClass) {
            int n2 = ((RClass)constantPoolElement).getClassID();
            myDataOutputStream.writeVU(n2);
            ++n;
        }
    }

    public void outputCAPFields(MyDataOutputStream myDataOutputStream) throws IOException {
        ConstantPoolElement constantPoolElement;
        int n;
        for (n = 0; n < this.vinfo.size() && ((constantPoolElement = this.vinfo.get(n)) instanceof RUCS2 || constantPoolElement instanceof RUTF8 || constantPoolElement instanceof CPInt || constantPoolElement instanceof CPLong || constantPoolElement instanceof CPFloat || constantPoolElement instanceof CPDouble || constantPoolElement instanceof RClass); ++n) {
        }
        myDataOutputStream.writeVU(this.num_cp_fields);
        while (n < this.vinfo.size() && (constantPoolElement = this.vinfo.get(n)) instanceof FieldDef) {
            int n2 = ((FieldDef)constantPoolElement).getFieldID();
            myDataOutputStream.writeVU(n2);
            ++n;
        }
    }

    public void outputCAPMethods(MyDataOutputStream myDataOutputStream) throws IOException {
        ConstantPoolElement constantPoolElement;
        int n;
        for (n = 0; n < this.vinfo.size() && ((constantPoolElement = this.vinfo.get(n)) instanceof RUCS2 || constantPoolElement instanceof RUTF8 || constantPoolElement instanceof CPInt || constantPoolElement instanceof CPLong || constantPoolElement instanceof RClass || constantPoolElement instanceof FieldDef || constantPoolElement instanceof CPFloat || constantPoolElement instanceof CPDouble); ++n) {
        }
        myDataOutputStream.writeVU(this.num_cp_methods);
        while (n < this.vinfo.size() && (constantPoolElement = this.vinfo.get(n)) instanceof MethodDef) {
            int n2 = ((MethodDef)constantPoolElement).getMethodID();
            myDataOutputStream.writeVU(n2);
            ++n;
        }
        if (n != this.vinfo.size()) {
            throw new RuntimeException("unknown error, vinfo.size(): " + this.vinfo.size() + ", i:" + n);
        }
    }

    public int setMethodIDForNotImplIfMethod(int n) {
        int n2 = 0;
        for (int i = 0; i < this.vinfo.size(); ++i) {
            ConstantPoolElement constantPoolElement = this.vinfo.get(i);
            if (!(constantPoolElement instanceof MethodDefAbstractFake)) continue;
            MethodDefAbstractFake methodDefAbstractFake = (MethodDefAbstractFake)constantPoolElement;
            methodDefAbstractFake.setMethodID(n);
            ++n;
            ++n2;
        }
        return n2;
    }

    public void outputCAPNotImplIfMethod(MyDataOutputStream myDataOutputStream, int n) throws IOException {
        int n2 = 0;
        myDataOutputStream.writeVU(this.num_notimpl_methods);
        for (int i = 0; i < this.vinfo.size(); ++i) {
            ConstantPoolElement constantPoolElement = this.vinfo.get(i);
            if (!(constantPoolElement instanceof MethodDefAbstractFake)) continue;
            MethodDefAbstractFake methodDefAbstractFake = (MethodDefAbstractFake)constantPoolElement;
            MethodDef methodDef = methodDefAbstractFake.getOriginalMethod();
            RClass rClass = methodDefAbstractFake.getOwner();
            myDataOutputStream.writeVU(rClass.getClassID());
            myDataOutputStream.writeVU(methodDef.getMethodID());
            ++n2;
        }
    }

    int getStringEndIndex() {
        return this.string_end;
    }

    public void addExternalClass(RClass rClass) {
        this.extraExternalClasses.put(rClass.getAbsClassNameUTF8(), rClass);
        this.loader.getTotalUTF8().addElementX(rClass.getAbsClassNameUTF8());
    }
}

