/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.C;
import java.io.IOException;
import java.io.Writer;

public abstract class TextOutTool {
    private int cols = 0;
    private static final int COLS = 12;
    private Writer os;
    private static char[] work = new char[16];

    TextOutTool() {
    }

    public void setWriter(Writer writer) {
        this.os = writer;
    }

    public void closeWriter() {
        try {
            this.os.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("close failed.");
        }
    }

    public void printChars(char[] cArray, int n) {
        try {
            this.os.write(cArray, 0, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("output failed.");
        }
    }

    public void print(String string) {
        try {
            this.os.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("output failed.");
        }
    }

    public void println(String string) {
        try {
            this.os.write(string);
            this.os.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("output failed.");
        }
    }

    public void printlnHexBytes(byte[] byArray) {
        this.printHexBytes(byArray, byArray.length);
        this.returnPrintHex();
    }

    public void printHexBytes(byte[] byArray, int n) {
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = 0;
                if (this.cols == 0) {
                    TextOutTool.work[n2++] = 9;
                }
                TextOutTool.work[n2++] = 48;
                TextOutTool.work[n2++] = 120;
                byte by = byArray[i];
                int n3 = (by >> 4 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                n3 = (by & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                TextOutTool.work[n2++] = 44;
                ++this.cols;
                if (this.cols == 12) {
                    TextOutTool.work[n2++] = 10;
                    this.cols = 0;
                } else {
                    TextOutTool.work[n2++] = 32;
                }
                this.os.write(work, 0, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void returnPrintHex() {
        if (this.cols != 0) {
            try {
                this.os.write(10);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException();
            }
        }
        this.cols = 0;
    }

    public void printlnHexShorts(short[] sArray) {
        this.printHexShorts(sArray);
        this.returnPrintHex();
    }

    private void printHexShorts(short[] sArray) {
        int n = sArray.length;
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = 0;
                if (this.cols == 0) {
                    TextOutTool.work[n2++] = 9;
                }
                TextOutTool.work[n2++] = 48;
                TextOutTool.work[n2++] = 120;
                short s = sArray[i];
                int n3 = (s >> 12 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                n3 = (s >> 8 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                n3 = (s >> 4 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                n3 = (s >> 0 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                TextOutTool.work[n2++] = 44;
                ++this.cols;
                if (this.cols == 12) {
                    TextOutTool.work[n2++] = 10;
                    this.cols = 0;
                } else {
                    TextOutTool.work[n2++] = 32;
                }
                this.os.write(work, 0, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void printlnHexChars(char[] cArray) {
        this.printHexChars(cArray);
        this.returnPrintHex();
    }

    public void printHexChars(char[] cArray) {
        int n = cArray.length;
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = 0;
                if (this.cols == 0) {
                    TextOutTool.work[n2++] = 9;
                }
                TextOutTool.work[n2++] = 48;
                TextOutTool.work[n2++] = 120;
                char c = cArray[i];
                int n3 = (c >> 12 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                n3 = (c >> 8 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                n3 = (c >> 4 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                n3 = (c >> 0 & 0xF) + 48;
                if (n3 > 57) {
                    n3 += 7;
                }
                TextOutTool.work[n2++] = (char)n3;
                TextOutTool.work[n2++] = 44;
                ++this.cols;
                if (this.cols == 12) {
                    TextOutTool.work[n2++] = 10;
                    this.cols = 0;
                } else {
                    TextOutTool.work[n2++] = 32;
                }
                this.os.write(work, 0, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void printlnHexInts(int[] nArray) {
        this.printHexInts(nArray);
        this.returnPrintHex();
    }

    public void printHexInts(int[] nArray) {
        try {
            for (int n : nArray) {
                if (this.cols == 0) {
                    this.os.write(9);
                }
                this.os.write("0x");
                this.os.write(C.toHex8(n));
                this.os.write(", ");
                ++this.cols;
                if (this.cols != 6) continue;
                this.os.write(10);
                this.cols = 0;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException();
        }
    }
}

