/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.NanoNoPixelInfoException;
import avm.romize.PixelInfo;
import avm.romize.RClassLoader;
import avm.romize.RInstance;
import avm.romize.RInstanceByteArray;
import avm.romize.RInstanceIntArray;
import avm.romize.RInstanceShortArray;
import avm.romize.imageencoder.ImageData;
import java.io.IOException;
import java.util.Hashtable;

public class RInstanceImage
extends RInstance {
    private String name;
    private int width;
    private int height;
    private int transparentColor;
    private int flags;
    private RClassLoader loader;
    int id;
    private RInstance rarray;
    private RInstance rarray_pal = null;

    RInstanceImage(RClassLoader rClassLoader, String string, byte[] byArray, PixelInfo pixelInfo) throws IOException, NanoNoPixelInfoException {
        int[] nArray;
        short[] sArray;
        byte[] byArray2;
        this.loader = rClassLoader;
        this.name = string;
        ImageData imageData = ImageData.createImageData(byArray);
        this.width = imageData.getWidth();
        this.height = imageData.getHeight();
        this.flags = imageData.getFlags();
        this.transparentColor = imageData.getTransparentColor();
        if (pixelInfo == null) {
            throw new NanoNoPixelInfoException("Required extracting image file \"" + string + "\"");
        }
        Object object = imageData.getEncodedArrayData(pixelInfo);
        try {
            byArray2 = (byte[])object;
            this.rarray = new RInstanceByteArray(rClassLoader, null, byArray2);
        }
        catch (ClassCastException classCastException) {
            try {
                sArray = (short[])object;
                this.rarray = new RInstanceShortArray(rClassLoader, null, sArray);
            }
            catch (ClassCastException classCastException2) {
                nArray = (int[])object;
                this.rarray = new RInstanceIntArray(rClassLoader, null, nArray);
            }
        }
        rClassLoader.getTotalRomizeInstance().add(this.rarray);
        if (imageData.isPalettedImage()) {
            object = imageData.getPaletteArrayData(pixelInfo);
            try {
                byArray2 = (byte[])object;
                this.rarray_pal = new RInstanceByteArray(rClassLoader, null, byArray2);
            }
            catch (ClassCastException classCastException) {
                try {
                    sArray = (short[])object;
                    this.rarray_pal = new RInstanceShortArray(rClassLoader, null, sArray);
                }
                catch (ClassCastException classCastException3) {
                    nArray = (int[])object;
                    this.rarray_pal = new RInstanceIntArray(rClassLoader, null, nArray);
                }
            }
            rClassLoader.getTotalRomizeInstance().add(this.rarray_pal);
        }
    }

    @Override
    void setID(int n) {
        this.id = n;
    }

    @Override
    void setCellName(String string) {
        this.cell = string;
    }

    @Override
    public void outputClassData() {
        String string;
        String string2;
        boolean bl;
        boolean bl2 = bl = this.rarray_pal != null;
        if (bl) {
            string2 = "PalImgInstanceT";
            string = "_PalImgInstanceT";
        } else {
            string2 = "ImgInstanceT";
            string = "_ImgInstance";
        }
        Hashtable<String, String> hashtable = this.loader.get_bmethod_hash();
        if (hashtable.get(string2) == null) {
            this.loader.println("\ttypedef struct " + string + " {");
            this.loader.println("\t\tObjectHeaderT h;");
            if (this.rarray_pal == null) {
                this.loader.println("\t\tnano_s4 field[5];");
            } else {
                this.loader.println("\t\tnano_s4 field[7];");
            }
            this.loader.println("\t} " + string2 + ";");
            hashtable.put(string2, string2);
        }
        this.loader.println("static " + string2 + " " + this.getCodingName() + " = {");
        this.loader.println("\t{");
        this.loader.println("\t  #if (JDWP == 1)");
        this.loader.println("\t\t" + this.id + "LU,");
        this.loader.println("\t  #endif /* (JDWP == 1) */");
        this.loader.println("\t\t(CellT*) &" + this.cell + ",");
        if (bl) {
            this.loader.println("\t\t(ClassFileT*) &" + this.loader.findLoadedClass("jp/co/aplix/display/RawPalettedImage").getCodingName() + ",");
        } else {
            this.loader.println("\t\t(ClassFileT*) &" + this.loader.findLoadedClass("jp/co/aplix/display/RawImage").getCodingName() + ",");
        }
        this.loader.println("\t\tNULL");
        this.loader.println("\t},");
        this.loader.println("\t{");
        this.loader.println("\t\t" + this.width + "L, " + this.height + "L,");
        this.loader.println("\t\t(nano_s4) &" + this.rarray.cell + ",");
        this.loader.println("\t\t0x" + Integer.toHexString(this.transparentColor) + "L, 0x" + Integer.toHexString(this.flags) + "L,");
        if (bl) {
            this.loader.println("\t\t(nano_s4) &" + this.rarray_pal.cell + ", 0");
        }
        this.loader.println("\t}");
        this.loader.println("};");
    }

    @Override
    public String getCodingName() {
        return "RomizedImage_" + this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

