/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.Bytep;
import avm.romize.C;
import avm.romize.CodeExceptionHandler;
import avm.romize.CodeLineNumberTable;
import avm.romize.CodeVariableTable;
import avm.romize.FieldDef;
import avm.romize.MethodDef;
import avm.romize.MethodDefAbstract;
import avm.romize.MethodDefBytecode;
import avm.romize.MethodDefNative;
import avm.romize.RClass;
import avm.romize.RClassLoader;
import avm.romize.RUCS2;
import avm.romize.RUTF8;
import avm.romize.UnnecessaryInfo;
import avm.romize.constantpool.CPDouble;
import avm.romize.constantpool.CPFieldOrMethod;
import avm.romize.constantpool.CPFloat;
import avm.romize.constantpool.CPInt;
import avm.romize.constantpool.CPLong;
import avm.romize.constantpool.CPNameAndType;
import avm.romize.constantpool.ConstantPoolElement;
import avm.romize.constantpool.ConstantPools;

final class RClass_Helper {
    private int access_flags_index;
    private int method_count_index;
    private int attribute_count_index;
    private int constantpool_count;
    private int interfaces_count;
    private int fields_count;
    private int methods_count;
    public ConstantPools cpool;
    public int access_flags;
    public RUTF8 this_class;
    public RUTF8 super_class_name;
    public RUTF8[] interfaces_name;
    public FieldDef[] fields;
    public int instance_size;
    public int class_fields_count;
    public MethodDef[] methods;
    public RUTF8 sourcefile;
    private final RClassLoader loader_;

    public RClass_Helper(byte[] byArray, RClassLoader rClassLoader) {
        this.loader_ = rClassLoader;
        this.get_classdata_offset_info(byArray);
        this.cpool = this.get_constant_pools(byArray);
        Bytep bytep = new Bytep(byArray, this.access_flags_index);
        this.access_flags = bytep.get_u2();
        this.get_classnames(byArray);
    }

    public void getFieldAndMethods(byte[] byArray, UnnecessaryInfo unnecessaryInfo, RClass rClass) {
        this.get_fields_data(byArray, rClass);
        this.get_methods_data(byArray, unnecessaryInfo, rClass);
        this.get_attributes_data(byArray);
    }

    private void get_classdata_offset_info(byte[] byArray) {
        this.check_magic_and_version(byArray);
        this.get_constantpools_count(byArray);
        Bytep bytep = new Bytep(byArray, this.access_flags_index);
        bytep.check_length(8);
        bytep.skip(6);
        this.interfaces_count = bytep.get_u2();
        bytep.check_length(this.interfaces_count * 2);
        this.get_fields_count(byArray);
        this.get_methods_count(byArray);
        bytep = new Bytep(byArray, this.attribute_count_index);
        bytep.check_length(2);
        int n = bytep.get_u2();
        this.skip_attribute(n, bytep);
        bytep.check_eof();
    }

    private void check_magic_and_version(byte[] byArray) {
        Bytep bytep = new Bytep(byArray);
        bytep.check_length(8);
        int n = bytep.get_u4();
        if (n != -889275714) {
            throw new RuntimeException("ClassFormatError, magic");
        }
    }

    private void get_constantpools_count(byte[] byArray) {
        Bytep bytep = new Bytep(byArray, 8);
        bytep.check_length(2);
        this.constantpool_count = bytep.get_u2();
        if (this.constantpool_count == 0) {
            throw new RuntimeException("ClassFormatError, constantpools count");
        }
        for (int i = this.constantpool_count - 1; i != 0; --i) {
            bytep.check_length(1);
            int n = 0;
            int n2 = bytep.get_u1();
            switch (n2) {
                case 7: 
                case 8: {
                    n = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n = 4;
                    break;
                }
                case 5: 
                case 6: {
                    n = 8;
                    if (i == 1) {
                        throw new RuntimeException("bad classfile format.");
                    }
                    --i;
                    break;
                }
                case 1: {
                    bytep.check_length(2);
                    n = bytep.get_u2();
                    break;
                }
                default: {
                    throw new RuntimeException("bad classfile bad constantpool: 0x" + Integer.toHexString(n2));
                }
            }
            bytep.check_length(n);
            bytep.skip(n);
        }
        this.access_flags_index = bytep.get_index();
    }

    private void get_fields_count(byte[] byArray) {
        int n;
        Bytep bytep = new Bytep(byArray, this.access_flags_index + 8 + this.interfaces_count * 2);
        bytep.check_length(2);
        for (int i = n = bytep.get_u2(); i != 0; --i) {
            bytep.check_length(8);
            bytep.skip(6);
            int n2 = bytep.get_u2();
            this.skip_attribute(n2, bytep);
        }
        this.fields_count = n;
        this.method_count_index = bytep.get_index();
    }

    private void get_methods_count(byte[] byArray) {
        int n;
        Bytep bytep = new Bytep(byArray, this.method_count_index);
        bytep.check_length(2);
        for (int i = n = bytep.get_u2(); i != 0; --i) {
            bytep.check_length(8);
            bytep.skip(6);
            int n2 = bytep.get_u2();
            this.skip_attribute(n2, bytep);
        }
        this.methods_count = n;
        this.attribute_count_index = bytep.get_index();
    }

    private void skip_attribute(int n, Bytep bytep) {
        while (n != 0) {
            bytep.check_length(6);
            bytep.skip(2);
            int n2 = bytep.get_u4();
            bytep.check_length(n2);
            bytep.skip(n2);
            --n;
        }
    }

    private void get_attributes_data(byte[] byArray) {
        boolean bl = false;
        Bytep bytep = new Bytep(byArray, this.attribute_count_index);
        for (int i = bytep.get_u2(); i != 0; --i) {
            RUTF8 rUTF8 = this.cpool.get_utf8string(bytep.get_u2());
            int n = bytep.get_u4();
            Bytep bytep2 = new Bytep(bytep);
            bytep.skip(n);
            if (!rUTF8.equals(RUTF8.SourceFile)) continue;
            if (bl) {
                throw new RuntimeException("ClassFormatError MultipleSourceFileAttribute");
            }
            bl = true;
            if (n != 2) {
                throw new RuntimeException("ClassFormatError_BadAttribute");
            }
            int n2 = bytep2.get_u2();
            if (!C.KEEP_CLASS_FILENAME) continue;
            this.sourcefile = this.cpool.get_utf8string(n2);
        }
    }

    private void get_classnames(byte[] byArray) {
        Bytep bytep = new Bytep(byArray, this.access_flags_index + 2);
        int n = bytep.get_u2();
        this.this_class = this.cpool.get_classname(n);
        n = bytep.get_u2();
        if (n != 0) {
            this.super_class_name = this.cpool.get_classname(n);
        }
        bytep.skip(2);
        this.interfaces_name = new RUTF8[this.interfaces_count];
        for (int i = 0; i < this.interfaces_count; ++i) {
            n = bytep.get_u2();
            this.interfaces_name[i] = this.cpool.get_classname(n);
        }
    }

    private ConstantPools get_constant_pools(byte[] byArray) {
        int n;
        int n2;
        int[] nArray = new int[this.constantpool_count];
        ConstantPools constantPools = new ConstantPools(this.constantpool_count);
        Bytep bytep = new Bytep(byArray, 10);
        block17: for (n2 = 1; n2 < this.constantpool_count; ++n2) {
            nArray[n2] = n = bytep.get_u1();
            switch (n) {
                case 7: 
                case 8: {
                    bytep.skip(2);
                    continue block17;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    bytep.skip(4);
                    continue block17;
                }
                case 5: 
                case 6: {
                    bytep.skip(8);
                    ++n2;
                    continue block17;
                }
                case 1: {
                    int n3 = bytep.get_u2();
                    RUTF8 rUTF8 = new RUTF8(bytep.get_bytes(n3));
                    constantPools.set(n2, n, rUTF8);
                    continue block17;
                }
                default: {
                    throw new RuntimeException("unkown");
                }
            }
        }
        bytep = new Bytep(byArray, 10);
        block18: for (n2 = 1; n2 < this.constantpool_count; ++n2) {
            n = bytep.get_u1();
            switch (n) {
                case 7: {
                    int n4 = bytep.get_u2();
                    if (n4 <= 0 || n4 >= this.constantpool_count || nArray[n4] != 1) {
                        throw new RuntimeException("bad constantpool");
                    }
                    RUTF8 rUTF8 = constantPools.get_utf8string(n4);
                    rUTF8 = rUTF8.convertToString().charAt(0) == '[' ? this.loader_.substituteClassNameInDescriptorIfNecessary(rUTF8) : this.loader_.substituteClassNameIfNecessary(rUTF8);
                    constantPools.set(n2, n, rUTF8);
                    continue block18;
                }
                case 8: {
                    int n5 = bytep.get_u2();
                    if (n5 <= 0 || n5 >= this.constantpool_count || nArray[n5] != 1) {
                        throw new RuntimeException("bad constantpool");
                    }
                    ConstantPoolElement constantPoolElement = constantPools.get_utf8string(n5);
                    if (C.CP_STRING_KEEP_AS_UCS2) {
                        constantPoolElement = new RUCS2((RUTF8)constantPoolElement);
                    }
                    constantPools.set(n2, n, constantPoolElement);
                    continue block18;
                }
                case 9: 
                case 10: 
                case 11: {
                    int n6 = bytep.get_u2();
                    int n7 = bytep.get_u2();
                    if (n6 <= 0 || n6 >= this.constantpool_count || nArray[n6] != 7) {
                        throw new RuntimeException("bad constantpool");
                    }
                    if (n7 <= 0 || n7 >= this.constantpool_count || nArray[n7] != 12) {
                        throw new RuntimeException("bad constantpool");
                    }
                    constantPools.set(n2, n, new CPFieldOrMethod(constantPools, n6, n7));
                    continue block18;
                }
                case 12: {
                    int n8 = bytep.get_u2();
                    int n9 = bytep.get_u2();
                    if (n8 <= 0 || n8 >= this.constantpool_count || nArray[n8] != 1) {
                        throw new RuntimeException("bad constantpool");
                    }
                    if (n9 <= 0 || n9 >= this.constantpool_count || nArray[n9] != 1) {
                        throw new RuntimeException("bad constantpool");
                    }
                    RUTF8 rUTF8 = constantPools.get_utf8string(n8);
                    RUTF8 rUTF82 = constantPools.get_utf8string(n9);
                    rUTF82 = this.loader_.substituteClassNameInDescriptorIfNecessary(rUTF82);
                    constantPools.set(n2, n, new CPNameAndType(n8, n9, rUTF8, rUTF82));
                    continue block18;
                }
                case 3: {
                    constantPools.set(n2, n, new CPInt(bytep.get_u4()));
                    continue block18;
                }
                case 4: {
                    constantPools.set(n2, n, new CPFloat(bytep.get_u4()));
                    continue block18;
                }
                case 5: {
                    long l = (long)bytep.get_u4() & 0xFFFFFFFFL;
                    long l2 = (long)bytep.get_u4() & 0xFFFFFFFFL;
                    constantPools.set(n2, n, new CPLong(l << 32 | l2));
                    ++n2;
                    continue block18;
                }
                case 6: {
                    long l = (long)bytep.get_u4() & 0xFFFFFFFFL;
                    long l3 = (long)bytep.get_u4() & 0xFFFFFFFFL;
                    constantPools.set(n2, n, new CPDouble(l << 32 | l3));
                    ++n2;
                    continue block18;
                }
                case 1: {
                    int n10 = bytep.get_u2();
                    bytep.skip(n10);
                    continue block18;
                }
                default: {
                    throw new RuntimeException("unkown");
                }
            }
        }
        return constantPools;
    }

    private void get_fields_data(byte[] byArray, RClass rClass) {
        int n = 0;
        int n2 = 0;
        Bytep bytep = new Bytep(byArray, this.access_flags_index + 8 + this.interfaces_count * 2);
        int n3 = bytep.get_u2();
        if (n3 != this.fields_count) {
            throw new RuntimeException();
        }
        this.fields = new FieldDef[n3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = bytep.get_u2() & 0xDF;
            RUTF8 rUTF8 = this.cpool.get_utf8string(bytep.get_u2());
            RUTF8 rUTF82 = this.cpool.get_utf8string(bytep.get_u2());
            rUTF82 = this.loader_.substituteClassNameInDescriptorIfNecessary(rUTF82);
            int n6 = 0;
            for (int j = bytep.get_u2(); j != 0; --j) {
                RUTF8 rUTF83 = this.cpool.get_utf8string(bytep.get_u2());
                int n7 = bytep.get_u4();
                if (rUTF83.equals(RUTF8.ConstantValue)) {
                    if (n7 != 2) {
                        throw new RuntimeException("bad ConstantValue");
                    }
                    n6 = bytep.get_u2();
                    continue;
                }
                bytep.skip(n7);
            }
            if ((n5 & 8) != 0) {
                n4 = n2++;
                if (rUTF82.byteAt(0) == 74 || rUTF82.byteAt(0) == 68) {
                    ++n2;
                }
            } else {
                n4 = n++;
                if (rUTF82.byteAt(0) == 74 || rUTF82.byteAt(0) == 68) {
                    ++n;
                }
            }
            this.fields[i] = new FieldDef(n5, rUTF8, rUTF82, n6, rClass, n4);
            this.fields[i].setTypeID(i);
        }
        this.instance_size = n;
        this.class_fields_count = n2;
    }

    private void get_method_total_size(ConstantPools constantPools, byte[] byArray) {
        Bytep bytep = new Bytep(byArray, this.method_count_index + 2);
        for (int i = 0; i < this.methods_count; ++i) {
            int n = bytep.get_u2();
            RUTF8 rUTF8 = constantPools.get_utf8string(bytep.get_u2());
            RUTF8 rUTF82 = constantPools.get_utf8string(bytep.get_u2());
            if (rUTF8.equals(RUTF8.clinit) && rUTF82.equals(RUTF8.sig_V_V_Method)) {
                n = n & 0x800 | 8;
            } else if ((n & 0x200) != 0) {
                if ((n & 0x401) != 1025) {
                    throw new RuntimeException("bad interface accessflags");
                }
                if ((n & 0x13E) != 0) {
                    throw new RuntimeException("bad interface accessflags");
                }
            } else {
                if ((n & 1) != 0 && (n & 6) != 0 || (n & 2) != 0 && (n & 5) != 0 || (n & 4) != 0 && (n & 3) != 0) {
                    throw new RuntimeException("bad method accessflags");
                }
                if ((n & 0x400) != 0 && (n & 0x13A) != 0) {
                    throw new RuntimeException("bad method accessflags");
                }
                if (rUTF8.equals(RUTF8.init) && (n & 0x538) != 0) {
                    throw new RuntimeException("bad method accessflags");
                }
            }
            int n2 = bytep.get_u2();
            boolean bl = false;
            boolean bl2 = false;
            for (int j = 0; j < n2; ++j) {
                RUTF8 rUTF83 = constantPools.get_utf8string(bytep.get_u2());
                int n3 = bytep.get_u4();
                if (rUTF83.equals(RUTF8.Code)) {
                    if (bl) {
                        throw new RuntimeException("duplicate Code attribute");
                    }
                    bl = true;
                } else if (rUTF83.equals(RUTF8.Exceptions)) {
                    if (bl2) {
                        throw new RuntimeException("duplicate Exceptions attribute");
                    }
                    bl2 = true;
                }
                bytep.skip(n3);
            }
            if (!((n & 0x500) != 0 ? bl : !bl)) continue;
            throw new RuntimeException("wrong.");
        }
    }

    private void get_methods_data(byte[] byArray, UnnecessaryInfo unnecessaryInfo, RClass rClass) {
        this.get_method_total_size(this.cpool, byArray);
        this.methods = new MethodDef[this.methods_count];
        Bytep bytep = new Bytep(byArray, this.method_count_index + 2);
        boolean bl = unnecessaryInfo != null && unnecessaryInfo.isSecond();
        int n = 0;
        for (int i = 0; i < this.methods_count; ++i) {
            int n2 = bytep.get_u2() & 0xD3F;
            RUTF8 rUTF8 = this.cpool.get_utf8string(bytep.get_u2());
            RUTF8 rUTF82 = this.cpool.get_utf8string(bytep.get_u2());
            rUTF82 = this.loader_.substituteClassNameInDescriptorIfNecessary(rUTF82);
            if (rUTF8.equals(RUTF8.clinit) && rUTF82.equals(RUTF8.sig_V_V_Method)) {
                n2 = n2 & 0x800 | 8 | 0x4000;
            } else if (rUTF8.equals(RUTF8.init)) {
                n2 |= 0x8000;
            }
            CodeExceptionHandler codeExceptionHandler = null;
            CodeLineNumberTable codeLineNumberTable = null;
            CodeVariableTable codeVariableTable = null;
            int[] nArray = null;
            int n3 = 0;
            int n4 = 0;
            byte[] byArray2 = null;
            boolean bl2 = false;
            if (bl && unnecessaryInfo.isDescriptorOnlyMethod(rClass.getAbsClassNameString() + '#' + rUTF8.convertToString() + rUTF82.convertToString())) {
                byArray2 = new byte[]{};
                bl2 = true;
            }
            int n5 = bytep.get_u2();
            for (int j = 0; j < n5; ++j) {
                int n6;
                int n7;
                RUTF8 rUTF83 = this.cpool.get_utf8string(bytep.get_u2());
                int n8 = bytep.get_u4();
                Bytep bytep2 = new Bytep(bytep);
                bytep.skip(n8);
                if (bl2) continue;
                if (rUTF83.equals(RUTF8.Code)) {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    n3 = bytep2.get_u2();
                    n4 = bytep2.get_u2();
                    n7 = bytep2.get_u4();
                    byArray2 = bytep2.get_bytes(n7);
                    n6 = bytep2.get_u2();
                    if (n6 != 0) {
                        codeExceptionHandler = new CodeExceptionHandler(n6);
                        for (n12 = 0; n12 < n6; ++n12) {
                            n11 = bytep2.get_u2();
                            n10 = bytep2.get_u2();
                            n9 = bytep2.get_u2();
                            int n13 = bytep2.get_u2();
                            codeExceptionHandler.set(n12, n11, n10, n9, n13);
                        }
                    }
                    n12 = 0;
                    n11 = 0;
                    n10 = bytep2.get_u2();
                    for (n9 = 0; n9 < n10; ++n9) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        RUTF8 rUTF84 = this.cpool.get_utf8string(bytep2.get_u2());
                        int n18 = bytep2.get_u4();
                        Bytep bytep3 = new Bytep(bytep2);
                        bytep2.skip(n18);
                        if (rUTF84.equals(RUTF8.LineNumberTable)) {
                            if (n12 != 0) continue;
                            n12 = 1;
                            n17 = bytep3.get_u2();
                            codeLineNumberTable = new CodeLineNumberTable(n17);
                            for (n16 = 0; n16 < n17; ++n16) {
                                n15 = bytep3.get_u2();
                                n14 = bytep3.get_u2();
                                codeLineNumberTable.set(n16, n15, n14);
                            }
                            continue;
                        }
                        if (!rUTF84.equals(RUTF8.LocalVariableTable) || n11 != 0) continue;
                        n11 = 1;
                        n17 = bytep3.get_u2();
                        codeVariableTable = new CodeVariableTable(n17);
                        for (n16 = 0; n16 < n17; ++n16) {
                            n15 = bytep3.get_u2();
                            n14 = bytep3.get_u2();
                            int n19 = bytep3.get_u2();
                            int n20 = bytep3.get_u2();
                            int n21 = bytep3.get_u2();
                            codeVariableTable.set(n16, n15, n14, n19, n20, n21);
                        }
                    }
                    continue;
                }
                if (!rUTF83.equals(RUTF8.Exceptions)) continue;
                n7 = bytep2.get_u2();
                nArray = new int[n7];
                for (n6 = 0; n6 < n7; ++n6) {
                    nArray[n6] = bytep2.get_u2();
                }
            }
            MethodDef methodDef = (n2 & 0x400) != 0 ? new MethodDefAbstract(n2, rUTF8, rUTF82, nArray, rClass) : ((n2 & 0x100) != 0 ? new MethodDefNative(n2, rUTF8, rUTF82, nArray, rClass) : new MethodDefBytecode(n2, rUTF8, rUTF82, nArray, rClass, byArray2, n3, n4, codeExceptionHandler, codeLineNumberTable, codeVariableTable));
            if (bl && unnecessaryInfo.isUnnecessaryMethod(methodDef)) continue;
            methodDef.setTypeID(n);
            this.methods[n] = methodDef;
            ++n;
        }
        if (C.METHOD_REDUCTION && n != this.methods_count) {
            MethodDef[] methodDefArray = new MethodDef[n];
            System.arraycopy(this.methods, 0, methodDefArray, 0, n);
            this.methods = methodDefArray;
            this.methods_count = n;
        }
    }
}

