/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.C;
import avm.romize.FieldDef;
import avm.romize.Member;
import avm.romize.MethodDef;
import avm.romize.MethodDefBytecode;
import avm.romize.Module;
import avm.romize.MyDataOutputStream;
import avm.romize.NanoNoPixelInfoException;
import avm.romize.NanoRomizerException;
import avm.romize.PixelInfo;
import avm.romize.RClass;
import avm.romize.RClassHashtable;
import avm.romize.RInstance;
import avm.romize.RInstanceByteArray;
import avm.romize.RInstanceImage;
import avm.romize.RUTF8;
import avm.romize.TextOutTool;
import avm.romize.TotalCPString;
import avm.romize.TotalConstantPool;
import avm.romize.TotalRomizeInstance;
import avm.romize.TotalUTF8;
import avm.romize.UnnecessaryInfo;
import avm.romize.constantpool.ConstantPoolElement;
import avm.romize.resourcearchiver.StructuredBinaryConcatenater;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;

public final class RClassLoader
extends TextOutTool {
    RClassHashtable hash = new RClassHashtable();
    private RClassLoader parent;
    private TotalConstantPool tcpool = new TotalConstantPool(this);
    private TotalUTF8 tutf8;
    private TotalCPString cpstrings;
    private int endID = 1;
    private Hashtable<String, String> bmethod_hash = new Hashtable();
    TotalRomizeInstance tri = new TotalRomizeInstance(this);
    private RUTF8[] nessessaryClassNames;
    private LinkedHashMap<String, String> classNameSubstitutionTable_;
    UnnecessaryInfo uinfo = null;
    public static final String ROMIZE_IMAGE_CLASS_STD = "jp/co/aplix/display/RawImage";
    public static final String ROMIZE_IMAGE_CLASS = "jp/co/aplix/display/RawPalettedImage";
    private boolean need_romizeImageClass = false;
    private static File resourceRoot;
    private static final String[] Object_fields;
    private static final String[] String_fields;
    private static final String[] Thread_fields;
    private static final String[] Throwable_fields;
    private static final String[] StringBuilder_fields;
    private static final String[] RawFont_fields;
    private static final String[] RawGraphics_fields;
    private static final String[] Thread_methods;
    private static final String[] LoadableModule_fields;
    private static final String[] RawImage_fields;
    private static final String[] RawPalettedImage_fields;
    private static final String[] RawPalette_fields;
    private static final String[] Dirent_fields;
    private MyDataOutputStream dos;

    public RClassLoader(RClassLoader rClassLoader) {
        this.parent = rClassLoader;
        this.tutf8 = new TotalUTF8(this);
        if (C.CP_STRING_KEEP_AS_UCS2) {
            this.cpstrings = new TotalCPString(this);
        }
    }

    public RClassLoader(RClassLoader rClassLoader, UnnecessaryInfo unnecessaryInfo) {
        this.uinfo = unnecessaryInfo;
        this.parent = rClassLoader;
        this.tutf8 = new TotalUTF8(this);
        if (C.CP_STRING_KEEP_AS_UCS2) {
            this.cpstrings = new TotalCPString(this);
        }
    }

    Hashtable<String, String> get_bmethod_hash() {
        return this.bmethod_hash;
    }

    public boolean isBootStrap() {
        return this.parent == null;
    }

    public void setNecessaryClasses(String[] stringArray) throws NanoRomizerException {
        if (stringArray != null) {
            this.nessessaryClassNames = new RUTF8[stringArray.length];
            int n = 0;
            for (String string : stringArray) {
                RUTF8 rUTF8 = new RUTF8(string);
                this.nessessaryClassNames[n++] = rUTF8;
                RClass rClass = string.charAt(0) == '[' ? this.requestArrayClass(string) : this.findLoadedClass(rUTF8);
                if (rClass == null) {
                    throw new NanoRomizerException("Indispensable class \"" + string + "\" doesn't exist.");
                }
                rClass.classResolve();
            }
        }
    }

    public void setTypeIDs() {
        RClass[] rClassArray;
        for (RClass rClass : rClassArray = this.getAllClasses()) {
            rClass.setTypeID(this.getInstanceID());
        }
    }

    public RClass findLoadedClass(String string) {
        return this.findLoadedClass(new RUTF8(string));
    }

    public RClass findLoadedClass(RUTF8 rUTF8) {
        RClass rClass = this.hash.getClassFromName(rUTF8);
        if (rClass != null) {
            return rClass;
        }
        if (this.parent != null) {
            rClass = this.parent.findLoadedClass(rUTF8);
        }
        return rClass;
    }

    public void sweepUnsedClass() {
        this.hash.sweepUnsedClass();
        if (this.parent != null) {
            this.parent.sweepUnsedClass();
        }
    }

    public void prepare() {
        RClass[] rClassArray;
        for (RClass rClass : rClassArray = this.hash.getAllClasses()) {
            rClass.prepare();
        }
        if (this.parent != null) {
            this.parent.prepare();
        }
    }

    public void resolve() {
        RClass[] rClassArray;
        for (RClass rClass : rClassArray = this.hash.getAllClasses()) {
            rClass.resolve();
        }
        if (this.parent != null) {
            this.parent.resolve();
        }
    }

    public RClass[] getAllClasses() {
        return this.hash.getAllClasses();
    }

    public RClass[] getAllClassesIncludeEvenTheParentLoader() {
        RClassLoader rClassLoader = this;
        int n = 0;
        do {
            n += rClassLoader.hash.length();
        } while ((rClassLoader = rClassLoader.parent) != null);
        RClass[] rClassArray = new RClass[n];
        rClassLoader = this;
        int n2 = 0;
        do {
            RClass[] rClassArray2 = rClassLoader.hash.getAllClasses();
            System.arraycopy(rClassArray2, 0, rClassArray, n2, rClassArray2.length);
            n2 += rClassArray2.length;
        } while ((rClassLoader = rClassLoader.parent) != null);
        return rClassArray;
    }

    private int point(RClass rClass) {
        int n;
        block17: {
            RUTF8 rUTF8;
            block16: {
                rUTF8 = rClass.getAbsClassNameUTF8();
                n = 65535;
                if (rUTF8.length() != 2) break block16;
                if (rUTF8.byteAt(0) != 91) break block17;
                switch (rUTF8.byteAt(1)) {
                    case 90: {
                        n = 1;
                        break;
                    }
                    case 67: {
                        n = 2;
                        break;
                    }
                    case 66: {
                        n = 3;
                        break;
                    }
                    case 83: {
                        n = 4;
                        break;
                    }
                    case 73: {
                        n = 5;
                        break;
                    }
                    case 74: {
                        n = 6;
                    }
                }
                if (C.SUPPORT_FLOAT) {
                    switch (rUTF8.byteAt(1)) {
                        case 70: {
                            n = 7;
                            break;
                        }
                        case 68: {
                            n = 8;
                        }
                    }
                }
                break block17;
            }
            if (this.nessessaryClassNames != null) {
                for (int i = 0; i < this.nessessaryClassNames.length; ++i) {
                    RUTF8 rUTF82 = this.nessessaryClassNames[i];
                    if (!rUTF8.equals(rUTF82)) continue;
                    if (C.SUPPORT_FLOAT) {
                        n = 9 + i;
                        break;
                    }
                    n = 7 + i;
                    break;
                }
            }
        }
        return n;
    }

    private boolean need_swap(RClass[] rClassArray, int n, int n2) {
        return this.point(rClassArray[n]) > this.point(rClassArray[n2]);
    }

    public RClass[] getAllClassesAsSort() {
        RClass[] rClassArray = this.hash.getAllClasses();
        int n = 1;
        while (n < rClassArray.length) {
            n = n * 3 + 1;
        }
        while (n > 0) {
            for (int i = n; i < rClassArray.length; ++i) {
                for (int j = i; j >= n && this.need_swap(rClassArray, j - n, j); j -= n) {
                    RClass rClass = rClassArray[j];
                    rClassArray[j] = rClassArray[j - n];
                    rClassArray[j - n] = rClass;
                }
            }
            n /= 3;
        }
        return rClassArray;
    }

    private static byte[] getStreamBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = new byte[4096];
            while (true) {
                int n;
                if ((n = inputStream.read(byArray)) == -1) {
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    return byArray2;
                }
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileBytes(File file) throws IOException {
        String string = file.getName();
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("too large class file: " + string);
        }
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            while (l != 0L) {
                int n = fileInputStream.read(byArray, (int)((long)byArray.length - l), (int)l);
                if (n < 0) {
                    throw new RuntimeException("unknown error occurred.");
                }
                l -= (long)n;
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            fileInputStream.close();
        }
    }

    private static boolean isImageType(String string) {
        if (string.endsWith(".bmp")) {
            return true;
        }
        if (string.endsWith(".png")) {
            return true;
        }
        if (string.endsWith(".gif")) {
            return true;
        }
        return string.endsWith(".jpg");
    }

    public void checkResource(String string, boolean bl) throws IOException, NanoRomizerException {
        if (bl && !this.need_romizeImageClass) {
            File file = new File(string);
            if (file.isDirectory()) {
                if (!file.getName().equals(".svn")) {
                    String[] stringArray;
                    for (String string2 : stringArray = file.list()) {
                        this.checkResource(file.getCanonicalPath() + System.getProperty("file.separator") + string2, bl);
                    }
                }
                return;
            }
            if (!file.exists()) {
                return;
            }
            if (file.getName().equals("Thumbs.db")) {
                return;
            }
            String string3 = file.getName();
            if (RClassLoader.isImageType(string3)) {
                this.need_romizeImageClass = true;
                RClass rClass = this.findLoadedClass(ROMIZE_IMAGE_CLASS);
                if (rClass == null) {
                    throw new NanoRomizerException("Indispensable class \"jp/co/aplix/display/RawPalettedImage\" doesn't exist.");
                }
                rClass.classResolve();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkResourceFromJAR(String string, boolean bl) throws IOException, NanoRomizerException {
        if (bl && !this.need_romizeImageClass) {
            File file = new File(string);
            if (!file.exists() || !file.isFile()) {
                throw new IOException(string + " is not valid file.");
            }
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            try {
                JarEntry jarEntry;
                while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                    String string2;
                    int n;
                    String string3 = jarEntry.getName();
                    if (!jarEntry.isDirectory() && (n = string3.lastIndexOf(47)) != -1 && RClassLoader.isImageType(string2 = string3.substring(n + 1))) {
                        this.need_romizeImageClass = true;
                        RClass rClass = this.findLoadedClass(ROMIZE_IMAGE_CLASS);
                        if (rClass == null) {
                            throw new NanoRomizerException("Indispensable class \"jp/co/aplix/display/RawPalettedImage\" doesn't exist.");
                        }
                        rClass.classResolve();
                        return;
                    }
                    jarInputStream.closeEntry();
                }
            }
            finally {
                jarInputStream.close();
            }
        }
    }

    public void setResourceRoot(String string) {
        resourceRoot = new File(string);
    }

    String getResourceAbsolute(File file) throws IOException {
        String string = file.getCanonicalPath();
        String string2 = resourceRoot.getCanonicalPath();
        char[] cArray = new char[string.length() - string2.length()];
        int n = 0;
        int n2 = string2.length();
        while (n < cArray.length) {
            int n3 = string.charAt(n2);
            if (n3 == 92) {
                n3 = 47;
            }
            cArray[n] = n3;
            ++n;
            ++n2;
        }
        return new String(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResourceFromJar(String string, PixelInfo pixelInfo, boolean bl) throws IOException, NanoNoPixelInfoException {
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            throw new IOException(string + " is not valid file.");
        }
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
        try {
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String string2 = jarEntry.getName();
                if (!jarEntry.isDirectory()) {
                    RInstance rInstance;
                    byte[] byArray;
                    String string3 = string2;
                    int n = string2.lastIndexOf(47);
                    if (n != -1) {
                        string3 = string2.substring(n + 1);
                    }
                    string2 = '/' + string2;
                    if (bl && (string3.endsWith(".bmp") || string3.endsWith(".png") || string3.endsWith(".gif") || string3.endsWith(".jpg"))) {
                        byArray = RClassLoader.getStreamBytes(jarInputStream);
                        rInstance = new RInstanceImage(this, string2, byArray, pixelInfo);
                        this.tri.add(rInstance);
                    } else if (!string3.endsWith(".class")) {
                        byArray = RClassLoader.getStreamBytes(jarInputStream);
                        rInstance = new RInstanceByteArray(this, string2, byArray);
                        this.tri.add(rInstance);
                    }
                }
                jarInputStream.closeEntry();
            }
        }
        finally {
            jarInputStream.close();
        }
    }

    public void loadResource(String string, PixelInfo pixelInfo, boolean bl) throws IOException, NanoNoPixelInfoException {
        File file = new File(string);
        if (file.isDirectory()) {
            if (!file.getName().equals(".svn")) {
                String[] stringArray;
                for (String string2 : stringArray = file.list()) {
                    this.loadResource(file.getCanonicalPath() + System.getProperty("file.separator") + string2, pixelInfo, bl);
                }
            }
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.getName().equals("Thumbs.db")) {
            return;
        }
        String string3 = file.getName();
        String string4 = this.getResourceAbsolute(file);
        if (bl && (string3.endsWith(".bmp") || string3.endsWith(".png") || string3.endsWith(".gif") || string3.endsWith(".jpg"))) {
            byte[] byArray = RClassLoader.getFileBytes(file);
            RInstanceImage rInstanceImage = new RInstanceImage(this, string4, byArray, pixelInfo);
            this.tri.add(rInstanceImage);
        } else {
            byte[] byArray = RClassLoader.getFileBytes(file);
            RInstanceByteArray rInstanceByteArray = new RInstanceByteArray(this, string4, byArray);
            this.tri.add(rInstanceByteArray);
        }
    }

    public void loadClass(String string) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray;
            for (String string2 : stringArray = file.list()) {
                this.loadClass(file.getCanonicalPath() + System.getProperty("file.separator") + string2);
            }
            return;
        }
        if (!file.exists()) {
            throw new IOException("Waning: input file or directory " + string + " is not exist.");
        }
        String string3 = file.getName();
        if (string3.endsWith(".class")) {
            RClass rClass;
            byte[] byArray = RClassLoader.getFileBytes(file);
            RClass rClass2 = new RClass(byArray, this);
            if (!(this.uinfo != null && this.uinfo.isSecond() && this.uinfo.isUnnecessaryClass(rClass2) || (rClass = this.hash.getClassFromName(rClass2.getAbsClassNameUTF8())) != null)) {
                this.hash.put(rClass2.getAbsClassNameUTF8(), rClass2);
            }
        }
    }

    public void addStartupClass(String string) {
        RClass rClass = new RClass(string, this);
        this.hash.put(rClass.getAbsClassNameUTF8(), rClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadClassFromJar(String string) throws IOException {
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            throw new IOException(string + " is not valid file.");
        }
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
        try {
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String string2 = jarEntry.getName();
                if (!jarEntry.isDirectory() && string2.endsWith(".class")) {
                    RClass rClass;
                    byte[] byArray = RClassLoader.getStreamBytes(jarInputStream);
                    RClass rClass2 = new RClass(byArray, this);
                    if (!(this.uinfo != null && this.uinfo.isSecond() && this.uinfo.isUnnecessaryClass(rClass2) || (rClass = this.hash.getClassFromName(rClass2.getAbsClassNameUTF8())) != null)) {
                        this.hash.put(rClass2.getAbsClassNameUTF8(), rClass2);
                    }
                }
                jarInputStream.closeEntry();
            }
        }
        finally {
            jarInputStream.close();
        }
    }

    public TotalConstantPool getTotalConstantPool() {
        return this.tcpool;
    }

    public TotalUTF8 getTotalUTF8() {
        return this.tutf8;
    }

    public void verifyAll() {
        RClass[] rClassArray;
        for (RClass rClass : rClassArray = this.getAllClasses()) {
            rClass.verify();
        }
    }

    public RClass requestArrayClass(String string) {
        return this.requestArrayClass(new RUTF8(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RClass requestArrayClass(RUTF8 rUTF8) {
        int n;
        RClass rClass = this.hash.getClassFromName(rUTF8);
        if (rClass != null) return rClass;
        for (n = 0; n < rUTF8.length() && rUTF8.byteAt(n) == 91; ++n) {
        }
        if (n == 0) throw new RuntimeException("bad array dimension.");
        if (n > 255) throw new RuntimeException("bad array dimension.");
        if (n == rUTF8.length()) {
            throw new RuntimeException("bad array dimension.");
        }
        if (rUTF8.byteAt(n) == 76) {
            RUTF8 rUTF82 = rUTF8.substring(n + 1, rUTF8.length() - 1);
            RClass rClass2 = this.hash.getClassFromName(rUTF82);
            if (rClass2 == null) {
                if (this.parent != null) return this.parent.requestArrayClass(rUTF8);
                if (this.uinfo == null) throw new RuntimeException(rUTF82 + " is not found!");
                if (!this.uinfo.isSecond()) throw new RuntimeException(rUTF82 + " is not found!");
                if (!this.uinfo.isUnnecessaryClass(rUTF82)) throw new RuntimeException(rUTF82 + " is not found!");
                return null;
            }
            if (n > 1) {
                RUTF8 rUTF83 = rUTF8.substring(1, rUTF8.length());
                this.requestArrayClass(rUTF83);
            }
            rClass = new RClass(rUTF8, this);
            this.hash.put(rClass.getAbsClassNameUTF8(), rClass);
            return rClass;
        } else {
            if (this.parent != null) {
                return this.parent.requestArrayClass(rUTF8);
            }
            if (n > 1) {
                RUTF8 rUTF84 = rUTF8.substring(1, rUTF8.length());
                this.requestArrayClass(rUTF84);
            }
            rClass = new RClass(rUTF8, this);
            this.hash.put(rClass.getAbsClassNameUTF8(), rClass);
        }
        return rClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void output(String string, String[] stringArray) throws IOException {
        Object object;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("romizer.h");
        if (inputStream == null) {
            inputStream = new FileInputStream("data/romizer.h");
        }
        try {
            int n;
            object = new byte[1024];
            while ((n = inputStream.read((byte[])object)) != -1) {
                fileOutputStream.write((byte[])object, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
        fileOutputStream.flush();
        object = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        this.setWriter((Writer)object);
        try {
            void var10_24;
            RClass[] rClassArray = this.getAllClassesAsSort();
            this.println("#define CONFIG_BYTE_65B\t((GLCD_PIXEL_BYTES - 1) << 5)");
            this.println("#if defined(NANO_BIG_ENDIAN)");
            this.println("  #define CONFIG_BYTE_4B\t(1<<4)");
            this.println("#elif defined(NANO_LITTLE_ENDIAN)");
            this.println("  #define CONFIG_BYTE_4B\t(0<<4)");
            this.println("#endif");
            this.println("#if defined(LOADABLE) && (LOADABLE == 1)");
            this.println("  #define CONFIG_BYTE_3B\t(1<<3)");
            this.println("#else");
            this.println("  #define CONFIG_BYTE_3B\t(0<<3)");
            this.println("#endif");
            this.println("#if defined(FLOAT_SUPPORT) && (FLOAT_SUPPORT == 1)");
            this.println("  #define CONFIG_BYTE_7B\t(1<<7)");
            this.println("#else");
            this.println("  #define CONFIG_BYTE_7B\t(0<<7)");
            this.println("#endif");
            this.println("#define CONFIG_BYTE_CLASSDATA \\");
            this.println("\t  (((JDWP == 1) ? (1 << 0) : 0)\\");
            this.println("\t| ((ENABLE_CHECKCAST == 1) ? (1 << 1) : 0)\\");
            this.println("\t| ((METHOD_TABLE_ENABLE == 1) ? (1 << 2) : 0)\\");
            this.println("\t| CONFIG_BYTE_3B | CONFIG_BYTE_4B | CONFIG_BYTE_65B | CONFIG_BYTE_7B)");
            this.println("extern unsigned char ConfigByteClassData;");
            this.println("unsigned char ConfigByteClassData = CONFIG_BYTE_CLASSDATA;");
            for (String string2 : stringArray) {
                this.println("#include \"" + string2 + "\"");
            }
            for (RClass rClass : rClassArray) {
                rClass.output_prototype();
            }
            this.tutf8.outputClassData();
            if (C.CP_STRING_KEEP_AS_UCS2) {
                this.cpstrings.outputClassData();
            }
            for (RClass rClass : rClassArray) {
                rClass.output_fields();
            }
            this.getTotalConstantPool().outputClassData();
            String string3 = RClass.output_classStatusPrototype(this, 0);
            this.println("static const " + string3 + " " + "CLS_ARRAYSTATUS" + " = {");
            this.println("\tNULL, {CLASS_INITIALIZED},");
            this.println("};");
            RClass[] rClassArray2 = rClassArray;
            int n = rClassArray2.length;
            boolean bl = false;
            while (var10_24 < n) {
                RClass rClass = rClassArray2[var10_24];
                rClass.outputClassData();
                ++var10_24;
            }
            int n2 = 0;
            this.println("\n\n\nstatic const ClassFileT* cfs[] = {");
            for (RClass rClass : rClassArray) {
                if (n2 == 0) {
                    this.print("\t");
                }
                this.print("(ClassFileT*) &" + rClass.getCodingName() + ", ");
                if (++n2 != 8) continue;
                this.print("\n");
                n2 = 0;
            }
            if (n2 != 0) {
                this.print("\n");
            }
            this.println("};");
            if (this.tcpool.getStringEndIndex() != 0) {
                this.println("static CellT *runtime[CP_STRING_END_INDEX];");
            }
            this.println("const ClassLoaderT cl0 = {");
            this.println("\t" + this.getTotalConstantPool().getCodingName() + ",");
            this.println("\tCP_STRING_END_INDEX,");
            this.println("\tCP_LONG_START_INDEX,");
            this.println("\tsizeof(UTF8_TABLE),");
            this.println("\tUTF8_TABLE,");
            if (C.CP_STRING_KEEP_AS_UCS2) {
                this.println("\tCPSTR_TABLE,");
            } else {
                this.println("\tNULL,");
            }
            this.println("\tcfs,");
            if (this.tcpool.getStringEndIndex() == 0) {
                this.println("\tNULL,");
            } else {
                this.println("\truntime,");
            }
            this.println("\t" + rClassArray.length);
            this.println("  #if (LOADABLE == 1)");
            this.println("\t, NULL, NULL, 0, NULL, NULL,");
            this.println("\t1 // used");
            this.println("  #endif /* (LOADABLE == 1) */");
            this.println("  #if (METHOD_TABLE_ENABLE == 1)");
            this.println("\t, NULL\n");
            this.println("  #endif /* (METHOD_TABLE_ENABLE == 1) */");
            this.println("};");
            this.tri.outputClassData();
            this.print_field_index("java/lang/Object", Object_fields, false);
            this.print_field_index("java/lang/String", String_fields, true);
            this.print_field_index("java/lang/Thread", Thread_fields, false);
            this.print_field_index("java/lang/Throwable", Throwable_fields, false);
            this.print_field_index("java/lang/StringBuilder", StringBuilder_fields, false);
            this.print_field_index("jp/co/aplix/avm/LoadableModule", LoadableModule_fields, false);
            this.print_field_index("jp/co/aplix/display/RawFont", RawFont_fields, false);
            this.print_field_index("jp/co/aplix/display/RawGraphics", RawGraphics_fields, false);
            this.print_method_index("java/lang/Thread", Thread_methods);
            this.print_field_index(ROMIZE_IMAGE_CLASS_STD, RawImage_fields, false);
            this.print_field_index(ROMIZE_IMAGE_CLASS, new String[]{ROMIZE_IMAGE_CLASS_STD}, RawPalettedImage_fields, false);
            this.print_field_index("jp/co/aplix/display/RawPalette", RawPalette_fields, false);
            this.print_field_index("java/io/Dirent", Dirent_fields, false);
            this.println("\n");
            this.println("#if (JDWP == 1)");
            this.println("nano_u4 global_type_id = " + this.endID + ";");
            this.println("#endif /* (JDWP == 1) */");
            this.println("/*");
            for (RClass rClass : rClassArray) {
                this.println(" *DBGINFO_INC_CLASS*" + rClass.getAbsClassNameString());
            }
            this.println("*/");
        }
        finally {
            this.closeWriter();
        }
    }

    private boolean print_field_index(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        RClass rClass = this.findLoadedClass(string);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = cArray[i] == '/' ? 95 : Character.toUpperCase(cArray[i]);
        }
        String string2 = new String(cArray);
        if (rClass == null) {
            if (C.METHOD_REDUCTION) {
                RClass[] rClassArray = this.getAllClasses();
                for (String string3 : stringArray2) {
                    boolean bl2 = false;
                    block2: for (int i = 0; !bl2 && i < rClassArray.length; ++i) {
                        MethodDef[] methodDefArray = rClassArray[i].getMethods();
                        block3: for (int j = 0; !bl2 && j < methodDefArray.length; ++j) {
                            String string4 = methodDefArray[j].getDescriptor().convertToString();
                            if (string4.indexOf('L' + string + ';') != -1) {
                                this.println("const nano_u1 FieldIndex_" + string2 + "_" + string3 + " = " + 0 + ";\t// dummy");
                                bl2 = true;
                                continue block2;
                            }
                            if (stringArray == null) continue;
                            for (String string5 : stringArray) {
                                if (string4.indexOf('L' + string5 + ';') == -1) continue;
                                this.println("const nano_u1 FieldIndex_" + string2 + "_" + string3 + " = " + 0 + ";\t// dummy");
                                bl2 = true;
                                continue block3;
                            }
                        }
                    }
                }
            }
            return false;
        }
        RUTF8[] rUTF8Array = new RUTF8[stringArray2.length];
        for (int i = 0; i < rUTF8Array.length; ++i) {
            rUTF8Array[i] = new RUTF8(stringArray2[i]);
        }
        FieldDef[] fieldDefArray = rClass.getFields();
        this.println("\n");
        int n = 0;
        int n2 = 0;
        for (FieldDef fieldDef : fieldDefArray) {
            for (int i = 0; i < rUTF8Array.length; ++i) {
                if (!fieldDef.getName().equals(rUTF8Array[i])) continue;
                this.println("const nano_u1 FieldIndex_" + string2 + "_" + stringArray2[i] + " = " + fieldDef.getFieldIndex() + ";");
                ++n;
                break;
            }
            n2 += fieldDef.is64() ? 2 : 1;
        }
        if (bl) {
            this.println("const nano_u1 FieldSize_" + string2 + " = " + n2 + ";");
        }
        return n == stringArray2.length;
    }

    private boolean print_field_index(String string, String[] stringArray, boolean bl) {
        return this.print_field_index(string, null, stringArray, bl);
    }

    private boolean print_method_index(String string, String[] stringArray) {
        RClass rClass = this.findLoadedClass(string);
        if (rClass == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = cArray[i] == '/' ? 95 : Character.toUpperCase(cArray[i]);
        }
        String string2 = new String(cArray);
        RUTF8[] rUTF8Array = new RUTF8[stringArray.length];
        for (int i = 0; i < rUTF8Array.length; ++i) {
            rUTF8Array[i] = new RUTF8(stringArray[i]);
        }
        MethodDef[] methodDefArray = rClass.getMethods();
        this.println("\n");
        int n = 0;
        block2: for (int i = 0; i < methodDefArray.length; ++i) {
            MethodDef methodDef = methodDefArray[i];
            for (int j = 0; j < rUTF8Array.length; ++j) {
                if (!methodDef.getName().equals(rUTF8Array[j])) continue;
                this.println("const nano_u1 MethodIndex_" + string2 + "_" + stringArray[j] + " = " + i + ";");
                ++n;
                continue block2;
            }
        }
        return n == stringArray.length;
    }

    public int getInstanceID() {
        int n = this.endID++;
        return n;
    }

    public TotalRomizeInstance getTotalRomizeInstance() {
        return this.tri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputCAP(String string, RClass rClass, MethodDef methodDef, Module module, Module[] moduleArray, String string2) throws IOException {
        block42: {
            TotalConstantPool totalConstantPool = this.getTotalConstantPool();
            this.tutf8.finish(true);
            totalConstantPool.finish();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n;
                char c;
                this.dos = new MyDataOutputStream(byteArrayOutputStream);
                try {
                    Member[] memberArray;
                    ConstantPoolElement rClass6;
                    int methodDef3;
                    this.dos.writeInt(1397902657);
                    this.dos.writeInt(0);
                    c = '\u0000';
                    if (C.CP_STRING_KEEP_AS_UCS2) {
                        c = (char)(c | 1);
                    }
                    if (C.METHOD_REDUCTION) {
                        c = (char)(c | 2);
                    }
                    if (C.SUPPORT_FLOAT) {
                        c = (char)(c | 4);
                    }
                    this.dos.writeChar(c);
                    if (module != null) {
                        module.outputCAP(this.dos);
                    } else {
                        Module.outputCAPDummy(this.dos);
                    }
                    int n3 = moduleArray == null ? 0 : moduleArray.length;
                    this.dos.writeVU(n3);
                    if (moduleArray != null) {
                        for (Module object2 : moduleArray) {
                            object2.outputCAP(this.dos);
                        }
                    }
                    n = 0;
                    int n4 = 0;
                    int n5 = 0;
                    RClass[] rClassArray = totalConstantPool.getExternalClasses();
                    MethodDef[] methodDefArray = totalConstantPool.getExternalMethods();
                    FieldDef[] fieldDefArray = totalConstantPool.getExternalFields();
                    int n2 = rClassArray.length;
                    int n6 = fieldDefArray.length;
                    int n7 = methodDefArray.length;
                    int n8 = n2 + 1;
                    int n9 = n6 + 1;
                    int n10 = n7 + 1;
                    RClass[] rClassArray2 = this.getAllClassesAsSort();
                    int n11 = rClassArray2.length;
                    int n12 = 0;
                    int n13 = 0;
                    RClass[] rClassArray3 = rClassArray2;
                    int n14 = rClassArray3.length;
                    for (methodDef3 = 0; methodDef3 < n14; ++methodDef3) {
                        int n15;
                        rClass6 = rClassArray3[methodDef3];
                        rClass6.setClassID(n8++);
                        MethodDef[] rClass4 = rClass6.getMethods();
                        memberArray = rClass4;
                        int n16 = memberArray.length;
                        for (n15 = 0; n15 < n16; ++n15) {
                            MethodDef methodDef2 = memberArray[n15];
                            methodDef2.setMethodID(n10++);
                        }
                        n13 += rClass4.length;
                        Member[] memberArray2 = memberArray = rClass6.getFields();
                        n15 = memberArray2.length;
                        for (int i = 0; i < n15; ++i) {
                            Member member = memberArray2[i];
                            ((FieldDef)member).setFieldID(n9++);
                        }
                        n12 += memberArray.length;
                    }
                    int n17 = totalConstantPool.setMethodIDForNotImplIfMethod(n10);
                    n = n11 + n2;
                    n4 = n12 + n6;
                    n5 = n13 + n7 + n17;
                    this.dos.writeVU(n);
                    this.dos.writeVU(n4);
                    this.dos.writeVU(n5);
                    this.dos.writeVU(totalConstantPool.getNumberOfConstantPools());
                    if (rClass == null) {
                        this.dos.writeVU(0);
                    } else {
                        this.dos.writeVU(rClass.getClassID());
                    }
                    if (methodDef != null) {
                        this.dos.writeVU(methodDef.getMethodID());
                    } else {
                        this.dos.writeVU(0);
                    }
                    this.tutf8.outputCAP(this.dos);
                    if (C.CP_STRING_KEEP_AS_UCS2) {
                        this.cpstrings.outputCAP(this.dos);
                    }
                    this.dos.writeVU(n2);
                    for (n14 = 0; n14 < n2; ++n14) {
                        RClass rClass2 = rClassArray[n14];
                        rClass6 = rClass2.getAbsClassNameUTF8();
                        int n18 = this.tutf8.getUTF8ID((RUTF8)rClass6);
                        this.dos.writeVU(n18);
                    }
                    this.dos.writeVU(n6);
                    for (n14 = 0; n14 < n6; ++n14) {
                        FieldDef fieldDef = fieldDefArray[n14];
                        this.dos.writeVU(fieldDef.getOwner().getClassID());
                        this.dos.writeVU(this.tutf8.getUTF8ID(fieldDef.getName()));
                        this.dos.writeVU(this.tutf8.getUTF8ID(fieldDef.getDescriptor()));
                    }
                    this.dos.writeVU(n7);
                    for (n14 = 0; n14 < n7; ++n14) {
                        MethodDef methodDef4 = methodDefArray[n14];
                        this.dos.writeVU(methodDef4.getOwner().getClassID());
                        this.dos.writeVU(this.tutf8.getUTF8ID(methodDef4.getName()));
                        this.dos.writeVU(this.tutf8.getUTF8ID(methodDef4.getDescriptor()));
                    }
                    this.dos.writeVU(n11);
                    for (n14 = 0; n14 < n11; ++n14) {
                        RClass rClass2 = rClassArray2[n14];
                        rClass2.outputCAP(this.dos);
                    }
                    this.dos.writeVU(n12);
                    boolean bl = false;
                    for (RClass rClass3 : rClassArray2) {
                        for (Member member : memberArray = rClass3.getFields()) {
                            this.dos.writeVU(rClass3.getClassID());
                            this.dos.writeChar(member.getAccessFlags());
                            this.dos.writeVU(this.tutf8.getUTF8ID(member.getName()));
                            this.dos.writeVU(this.tutf8.getUTF8ID(member.getDescriptor()));
                            this.dos.writeVU(totalConstantPool.findGlobalIndex(rClass3.getConstantPools(), ((FieldDef)member).getConstantValueIndex()));
                        }
                    }
                    this.dos.writeVU(n13);
                    bl = false;
                    RClass[] rClassArray4 = rClassArray2;
                    methodDef3 = rClassArray4.length;
                    for (int i = 0; i < methodDef3; ++i) {
                        RClass rClass4 = rClassArray4[i];
                        for (Member member : memberArray = rClass4.getMethods()) {
                            this.dos.writeVU(rClass4.getClassID());
                            this.dos.writeChar(member.getAccessFlags());
                            this.dos.writeVU(this.tutf8.getUTF8ID(member.getName()));
                            this.dos.writeVU(this.tutf8.getUTF8ID(member.getDescriptor()));
                            if (!(member instanceof MethodDefBytecode)) continue;
                            ((MethodDefBytecode)member).outputCAP(this.dos);
                        }
                    }
                    totalConstantPool.outputCAPNotImplIfMethod(this.dos, n10);
                    int n19 = 0;
                    for (methodDef3 = 0; methodDef3 < n11; ++methodDef3) {
                        RClass rClass5 = rClassArray2[methodDef3];
                        if (rClass5.isInterface() || rClass5.isArray()) continue;
                        ++n19;
                    }
                    this.dos.writeVU(n19);
                    n19 = 0;
                    for (methodDef3 = 0; methodDef3 < n11; ++methodDef3) {
                        RClass rClass7 = rClassArray2[methodDef3];
                        if (rClass7.isInterface() || rClass7.isArray()) continue;
                        rClass7.outputCAPMt(n19++, this.dos);
                    }
                    totalConstantPool.outputCAPGeneral(this.dos);
                    totalConstantPool.outputCAPClasses(this.dos);
                    totalConstantPool.outputCAPFields(this.dos);
                    totalConstantPool.outputCAPMethods(this.dos);
                    this.dos.writeChar(0);
                    this.dos.flush();
                }
                finally {
                    this.dos.close();
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                c = (char)byArray.length;
                byArray[4] = (byte)(c >>> 24);
                byArray[5] = (byte)(c >>> 16);
                byArray[6] = (byte)(c >>> 8);
                byArray[7] = (byte)(c >>> 0);
                C.setCRC(byArray);
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                try {
                    fileOutputStream.write(byArray);
                    if (string2 == null) break block42;
                    n = 0;
                    StructuredBinaryConcatenater structuredBinaryConcatenater = new StructuredBinaryConcatenater(n);
                    try {
                        File file = new File(string2);
                        if (file.isDirectory()) {
                            File[] fileArray;
                            for (File file2 : fileArray = file.listFiles()) {
                                if (!file2.isFile() || file2.getName().equals("Thumbs.db")) continue;
                                try {
                                    FileInputStream fileInputStream = new FileInputStream(file2);
                                    structuredBinaryConcatenater.add(file2.getName(), fileInputStream, file2.length());
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            structuredBinaryConcatenater.output(fileOutputStream);
                        }
                    }
                    finally {
                        structuredBinaryConcatenater.closeStreams();
                    }
                }
                finally {
                    fileOutputStream.close();
                }
            }
            finally {
                byteArrayOutputStream.close();
            }
        }
    }

    public TotalCPString getTotalCPString() {
        if (C.CP_STRING_KEEP_AS_UCS2) {
            return this.cpstrings;
        }
        throw new RuntimeException("bad condition");
    }

    public void setClassNameSubstitutionTable(LinkedHashMap<String, String> linkedHashMap) {
        this.classNameSubstitutionTable_ = linkedHashMap;
    }

    public RUTF8 substituteClassNameIfNecessary(RUTF8 rUTF8) {
        if (rUTF8 == null) {
            return null;
        }
        if (this.classNameSubstitutionTable_ != null) {
            String string = rUTF8.convertToString();
            for (String string2 : this.classNameSubstitutionTable_.keySet()) {
                if (!string.startsWith(string2)) continue;
                String string3 = this.classNameSubstitutionTable_.get(string2);
                String string4 = string.replaceFirst(Pattern.quote(string2), string3);
                return new RUTF8(string4);
            }
        }
        return rUTF8;
    }

    RUTF8 substituteClassNameInDescriptorIfNecessary(RUTF8 rUTF8) {
        if (rUTF8 == null) {
            return null;
        }
        if (this.classNameSubstitutionTable_ != null) {
            String string = rUTF8.convertToString();
            for (String string2 : this.classNameSubstitutionTable_.keySet()) {
                if (string.indexOf('L' + string2) == -1) continue;
                String string3 = string.replaceAll(Pattern.quote('L' + string2), 'L' + this.classNameSubstitutionTable_.get(string2));
                return new RUTF8(string3);
            }
        }
        return rUTF8;
    }

    private void aaShowTree(RClass rClass, String string) {
        RClass[] rClassArray = rClass.aaGetDirectSubclasses();
        for (int i = 0; i < rClassArray.length; ++i) {
            System.out.println(string + (i == rClassArray.length - 1 ? "\u2514" : "\u251c") + rClassArray[i].getAbsClassNameString());
            this.aaShowTree(rClassArray[i], string + (i == rClassArray.length - 1 ? "  " : "\u2502"));
        }
    }

    public void aaMakeTree() {
        RClass[] rClassArray;
        for (RClass rClass : rClassArray = this.getAllClassesIncludeEvenTheParentLoader()) {
            RClass rClass2;
            if (rClass.isInterface() || rClass.isArray() || (rClass2 = rClass.getSuperClass()) == null) continue;
            rClass2.aaAddDirectSubclass(rClass);
        }
        RClass rClass = this.findLoadedClass("java/lang/Object");
        for (RClass rClass2 : rClassArray) {
            RClass[] rClassArray2;
            if (rClass2.isInterface() || (rClassArray2 = rClass2.getInterfaces()).length == 0) continue;
            for (RClass rClass3 : rClassArray2) {
                rClass3.aaAddImplementsClasses(rClass2);
            }
        }
    }

    public void aaMarkLoader(MethodDef methodDef, List<String> list) {
        if (this.nessessaryClassNames != null) {
            for (ConstantPoolElement constantPoolElementArray : this.nessessaryClassNames) {
                RClass rClass = this.findLoadedClass((RUTF8)constantPoolElementArray);
                rClass.aaMarkClass();
            }
        }
        ConstantPoolElement[] constantPoolElementArray = this.getAllClasses();
        RClass[] rClassArray = list.iterator();
        while (rClassArray.hasNext()) {
            String string = rClassArray.next();
            for (ConstantPoolElement constantPoolElement : constantPoolElementArray) {
                if (!((RClass)constantPoolElement).matchPattern(string)) continue;
                ((RClass)constantPoolElement).aaMarkClass();
                for (MethodDef methodDef2 : ((RClass)constantPoolElement).getMethods()) {
                    methodDef2.aaMarkMethod();
                }
            }
        }
        methodDef.getOwner().aaMarkClass();
        methodDef.aaMarkMethod();
        for (RClass rClass : rClassArray = this.getAllClasses()) {
            if (this.uinfo.isUnnecessaryClass(rClass) || this.uinfo.isNotInstantiated(rClass)) continue;
            MethodDef[] methodDefArray = rClass.getVMethodTable();
            block5: for (int i = 0; i < methodDefArray.length; ++i) {
                MethodDef[] methodDefArray2;
                MethodDef methodDef3 = methodDefArray[i];
                if (methodDef3.getOwner() != rClass) continue;
                for (RClass rClass2 = rClass.getSuperClass(); rClass2 != null && (methodDefArray2 = rClass2.getVMethodTable()).length > i; rClass2 = rClass2.getSuperClass()) {
                    MethodDef methodDef4 = methodDefArray2[i];
                    if (methodDef4.getOwner().getClassLoader() == this) continue;
                    methodDef3.aaMarkMethod();
                    continue block5;
                }
            }
        }
    }

    public void aaMarkEntryClasses(RClass rClass, List<String> list) {
        if (this.nessessaryClassNames != null) {
            for (ConstantPoolElement constantPoolElementArray : this.nessessaryClassNames) {
                RClass rClass2 = this.findLoadedClass((RUTF8)constantPoolElementArray);
                rClass2.aaMarkClass();
            }
        }
        ConstantPoolElement[] constantPoolElementArray = this.getAllClasses();
        for (String string : list) {
            for (ConstantPoolElement constantPoolElement : constantPoolElementArray) {
                if (!((RClass)constantPoolElement).matchPattern(string)) continue;
                ((RClass)constantPoolElement).aaMarkClass();
                for (MethodDef methodDef : ((RClass)constantPoolElement).getMethods()) {
                    methodDef.aaMarkMethod();
                }
            }
        }
        rClass.aaMarkClass();
        MethodDef[] methodDefArray = rClass.getMethods();
        for (MethodDef methodDef : methodDefArray) {
            if (!methodDef.isStatic() || !methodDef.getName().equals("main") || !methodDef.getDescriptor().equals("([Ljava/lang/String;)V")) continue;
            methodDef.aaMarkMethod();
        }
        RClass rClass3 = this.findLoadedClass("java/lang/Thread");
        methodDefArray = rClass3.getMethods();
        RUTF8 rUTF8 = new RUTF8("start");
        RUTF8 rUTF82 = new RUTF8("()V");
        for (MethodDef methodDef : methodDefArray) {
            if (methodDef.isStatic() || methodDef.isConstructor() || !methodDef.getName().equals(rUTF8) || !methodDef.getDescriptor().equals(rUTF82) || !methodDef.aaIsMethodMarked()) continue;
            RClass rClass4 = this.findLoadedClass("java/lang/Runnable");
            RClass[] rClassArray = rClass4.aaGetImplementClasses();
            RUTF8 rUTF83 = new RUTF8("run");
            block6: for (RClass rClass5 : rClassArray) {
                MethodDef[] methodDefArray2 = rClass5.getMethods();
                if (this.uinfo.isUnnecessaryClass(rClass5) || this.uinfo.isNotInstantiated(rClass5)) continue;
                for (MethodDef methodDef2 : methodDefArray2) {
                    if (methodDef2.isStatic() || methodDef2.isConstructor() || !methodDef2.getName().equals(rUTF83) || !methodDef2.getDescriptor().equals(rUTF82)) continue;
                    methodDef2.aaMarkMethod();
                    continue block6;
                }
            }
            break;
        }
    }

    public void aaMarkThroughUseTree() {
        RClass[] rClassArray;
        for (RClass rClass : rClassArray = this.getAllClasses()) {
            if (rClass.isInterface()) continue;
            rClass.aaMarkThroughUseTree(this.uinfo);
        }
    }

    public UnnecessaryInfo aaGetUnnecessaryInfo() {
        return this.uinfo;
    }

    public void aaClearMarks() {
        RClass[] rClassArray;
        for (RClass rClass : rClassArray = this.getAllClasses()) {
            rClass.aaClearMarks();
        }
    }

    static {
        Object_fields = new String[]{"outofmemoryerror"};
        String_fields = new String[]{"length", "str"};
        Thread_fields = new String[]{"lockObj", "not_startable", "name"};
        Throwable_fields = new String[]{"stackTrace", "message"};
        StringBuilder_fields = new String[]{"buffer", "bufferLength", "length"};
        RawFont_fields = new String[]{"fontID"};
        RawGraphics_fields = new String[]{"clipSX", "clipSY", "clipEX", "clipEY", "color", "fontID", "tgtW", "tgtH", "target", "renderMode"};
        Thread_methods = new String[]{"run"};
        LoadableModule_fields = new String[]{"entry_method", "entry_type", "loader"};
        RawImage_fields = new String[]{"width", "height", "image", "transparentColor", "flags"};
        RawPalettedImage_fields = new String[]{"palette"};
        RawPalette_fields = new String[]{"palette"};
        Dirent_fields = new String[]{"d_name", "d_type"};
    }
}

