/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.RClass;
import avm.romize.RUTF8;

final class RClassHashtable {
    private static final int TABLE_SIZE = 1234;
    private KeyAndValue[] kavs = new KeyAndValue[1234];
    private int elements = 0;

    public RClass getClassFromName(RUTF8 rUTF8) {
        KeyAndValue keyAndValue;
        int n = rUTF8.hashCode();
        KeyAndValue keyAndValue2 = keyAndValue = this.kavs[n % 1234];
        while (keyAndValue2 != null) {
            if (keyAndValue2.key.equals(rUTF8)) {
                return keyAndValue2.value;
            }
            keyAndValue2 = keyAndValue2.next;
        }
        return null;
    }

    public void put(RUTF8 rUTF8, RClass rClass) {
        KeyAndValue keyAndValue;
        int n = rUTF8.hashCode();
        KeyAndValue keyAndValue2 = keyAndValue = this.kavs[n % 1234];
        while (keyAndValue2 != null) {
            if (keyAndValue2.key.equals(rUTF8)) {
                keyAndValue2.value = rClass;
                return;
            }
            keyAndValue2 = keyAndValue2.next;
        }
        ++this.elements;
        this.kavs[n % 1234] = keyAndValue2 = new KeyAndValue(rUTF8, rClass, keyAndValue);
    }

    public void sweepUnsedClass() {
        for (int i = 0; i < 1234; ++i) {
            KeyAndValue keyAndValue = this.kavs[i];
            KeyAndValue keyAndValue2 = null;
            while (keyAndValue != null) {
                if (!keyAndValue.value.isUsed()) {
                    --this.elements;
                    if (keyAndValue2 == null) {
                        this.kavs[i] = keyAndValue.next;
                    } else {
                        keyAndValue2.next = keyAndValue.next;
                    }
                } else {
                    keyAndValue2 = keyAndValue;
                }
                keyAndValue = keyAndValue.next;
            }
        }
    }

    public RClass[] getAllClasses() {
        RClass[] rClassArray = new RClass[this.elements];
        int n = 0;
        for (KeyAndValue keyAndValue : this.kavs) {
            while (keyAndValue != null) {
                rClassArray[n++] = keyAndValue.value;
                keyAndValue = keyAndValue.next;
            }
        }
        if (n != this.elements) {
            throw new RuntimeException("unexpected scene!");
        }
        return rClassArray;
    }

    public int length() {
        return this.elements;
    }

    public void dump() {
        for (RClass rClass : this.getAllClasses()) {
            System.out.println("RClassHashtable:" + rClass);
        }
    }

    static class KeyAndValue {
        RUTF8 key;
        RClass value;
        KeyAndValue next;

        KeyAndValue(RUTF8 rUTF8, RClass rClass, KeyAndValue keyAndValue) {
            this.key = rUTF8;
            this.value = rClass;
            this.next = keyAndValue;
        }
    }
}

