/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.NanoRomizerException;

public final class PixelInfo {
    public int bytesPerPixel;
    public int orPattern = 0;
    public int redMask;
    public int greenMask;
    public int blueMask;
    public int redLen;
    public int greenLen;
    public int blueLen;
    public int redShift;
    public int greenShift;
    public int blueShift;

    private byte[] cvtR8G8B8toDependB(int[] nArray, int n, int n2) {
        byte[] byArray = new byte[n * n2];
        int n3 = 0;
        for (int n4 : nArray) {
            int n5 = n4 >> 16 + (8 - this.redLen) & (1 << this.redLen) - 1;
            int n6 = n4 >> 8 + (8 - this.greenLen) & (1 << this.greenLen) - 1;
            int n7 = n4 >> 0 + (8 - this.blueLen) & (1 << this.blueLen) - 1;
            int n8 = n5 << this.redShift | n6 << this.greenShift | n7 << this.blueShift | this.orPattern;
            byArray[n3++] = (byte)n8;
        }
        return byArray;
    }

    private short[] cvtR8G8B8toDependS(int[] nArray, int n, int n2) {
        short[] sArray = new short[n * n2];
        int n3 = 0;
        for (int n4 : nArray) {
            int n5 = n4 >> 16 + (8 - this.redLen) & (1 << this.redLen) - 1;
            int n6 = n4 >> 8 + (8 - this.greenLen) & (1 << this.greenLen) - 1;
            int n7 = n4 >> 0 + (8 - this.blueLen) & (1 << this.blueLen) - 1;
            int n8 = n5 << this.redShift | n6 << this.greenShift | n7 << this.blueShift | this.orPattern;
            sArray[n3++] = (short)n8;
        }
        return sArray;
    }

    private int[] cvtR8G8B8toDependI(int[] nArray, int n, int n2) {
        if (this.redMask == 0xFF0000 && this.greenMask == 65280 && this.blueMask == 255) {
            return nArray;
        }
        int[] nArray2 = new int[n * n2];
        int n3 = 0;
        for (int n4 : nArray) {
            int n5 = n4 >> 16 + (8 - this.redLen) & (1 << this.redLen) - 1;
            int n6 = n4 >> 8 + (8 - this.greenLen) & (1 << this.greenLen) - 1;
            int n7 = n4 >> 0 + (8 - this.blueLen) & (1 << this.blueLen) - 1;
            int n8 = n5 << this.redShift | n6 << this.greenShift | n7 << this.blueShift | this.orPattern;
            nArray2[n3++] = n8;
        }
        return nArray2;
    }

    public Object cvtR8G8B8toDepend(int[] nArray, int n, int n2) {
        switch (this.bytesPerPixel) {
            case 1: {
                return this.cvtR8G8B8toDependB(nArray, n, n2);
            }
            case 2: {
                return this.cvtR8G8B8toDependS(nArray, n, n2);
            }
            case 4: {
                return this.cvtR8G8B8toDependI(nArray, n, n2);
            }
        }
        throw new RuntimeException("unknown pixel format");
    }

    public PixelInfo(String string, String string2, int n) throws NanoRomizerException {
        int n2;
        if (n != 0) {
            this.orPattern = 1 << n;
        }
        if ((n2 = string2.indexOf(44)) <= 0 || n2 == string2.length() - 1) {
            throw new NanoRomizerException("bad format -bitlen " + string2);
        }
        int n3 = string2.indexOf(44, n2 + 1);
        if (n3 < 0 || n3 == n2 + 1 || n3 == string2.length() - 1) {
            throw new NanoRomizerException("bad format -bitlen " + string2 + ", reason:" + n3);
        }
        if (string2.indexOf(44, n3 + 1) != -1) {
            throw new NanoRomizerException("bad format -bitlen " + string2);
        }
        int n4 = Integer.parseInt(string2.substring(0, n2));
        int n5 = Integer.parseInt(string2.substring(n2 + 1, n3));
        int n6 = Integer.parseInt(string2.substring(n3 + 1));
        if (n4 <= 0 || n5 <= 0 || n6 <= 0) {
            throw new NanoRomizerException("bad format -bitlen " + string2);
        }
        int n7 = n5 + n6;
        int n8 = (1 << n4) - 1 << n7;
        int n9 = n6;
        int n10 = (1 << n5) - 1 << n9;
        int n11 = 0;
        int n12 = (1 << n6) - 1 << n11;
        int n13 = n8 | n10 | n12;
        this.bytesPerPixel = (n13 & 0xFFFFFF00) == 0 ? 1 : ((n13 & 0xFFFF0000) == 0 ? 2 : 4);
        if (string.equals("BGR")) {
            this.redMask = n12;
            this.greenMask = n10;
            this.blueMask = n8;
            this.redLen = n6;
            this.greenLen = n5;
            this.blueLen = n4;
            this.redShift = n11;
            this.greenShift = n9;
            this.blueShift = n7;
        } else if (string.equals("RGB")) {
            this.redMask = n8;
            this.greenMask = n10;
            this.blueMask = n12;
            this.redLen = n4;
            this.greenLen = n5;
            this.blueLen = n6;
            this.redShift = n7;
            this.greenShift = n9;
            this.blueShift = n11;
        } else if (string.equals("GRB")) {
            this.greenMask = n8;
            this.redMask = n10;
            this.blueMask = n12;
            this.greenLen = n4;
            this.redLen = n5;
            this.blueLen = n6;
            this.greenShift = n7;
            this.redShift = n9;
            this.blueShift = n11;
        } else {
            throw new NanoRomizerException("unsuported type -order " + string);
        }
    }
}

