/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.C;
import avm.romize.CodeExceptionHandler;
import avm.romize.CodeLineNumberTable;
import avm.romize.CodeVariableTable;
import avm.romize.MethodDef;
import avm.romize.MyDataOutputStream;
import avm.romize.RClass;
import avm.romize.RClassLoader;
import avm.romize.RUTF8;
import avm.romize.TotalUTF8;
import avm.romize.bytecode.ByteCodes;
import avm.romize.main.romizer;
import java.io.IOException;
import java.util.Hashtable;

public final class MethodDefBytecode
extends MethodDef {
    private int max_stack;
    private int max_locals;
    private CodeExceptionHandler exception_handler;
    private CodeLineNumberTable line_number_table;
    private CodeVariableTable variable_table;
    private byte[] code;
    private ByteCodes bcodeX;

    CodeExceptionHandler getCodeExceptionHandler() {
        return this.exception_handler;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public byte[] getCode() {
        return this.code;
    }

    public CodeLineNumberTable getLineNumberTable() {
        return this.line_number_table;
    }

    public int oldAddrToNewAddr(int n) {
        return this.bcodeX.oldToNew(n);
    }

    MethodDefBytecode(int n, RUTF8 rUTF8, RUTF8 rUTF82, int[] nArray, RClass rClass, byte[] byArray, int n2, int n3, CodeExceptionHandler codeExceptionHandler, CodeLineNumberTable codeLineNumberTable, CodeVariableTable codeVariableTable) {
        super(n, rUTF8, rUTF82, nArray, rClass);
        this.max_stack = n2;
        this.max_locals = n3;
        this.exception_handler = codeExceptionHandler;
        if (C.KEEP_LINENUMBER_TABLES) {
            this.line_number_table = codeLineNumberTable;
        }
        this.variable_table = codeVariableTable;
        this.code = byArray;
        if (codeExceptionHandler != null) {
            codeExceptionHandler.setOwnerMethod(this);
        }
        if (codeLineNumberTable != null) {
            codeLineNumberTable.setOwnerMethod(this);
        }
        if (codeVariableTable != null) {
            codeVariableTable.setOwnerMethod(this);
        }
    }

    @Override
    public void outputClassData() {
        RClassLoader rClassLoader = this.getOwner().getClassLoader();
        int n = this.bcodeX.output();
        String string = "NULL";
        int n2 = 0;
        if (this.line_number_table != null && this.line_number_table.length() != 0) {
            n2 = this.line_number_table.length();
            this.line_number_table.outputClassData();
            string = this.line_number_table.getCodingName();
        }
        int n3 = 0;
        if (this.exception_handler != null && this.exception_handler.length() != 0) {
            n3 = this.exception_handler.length();
        }
        int n4 = 0;
        String string2 = "NULL";
        if (this.variable_table != null && this.variable_table.length() != 0) {
            this.variable_table.outputClassData();
            n4 = this.variable_table.length();
            string2 = this.variable_table.getCodingName();
        }
        String string3 = ("MethodDefBytecodeR" + n3 + "T").intern();
        TotalUTF8 totalUTF8 = rClassLoader.getTotalUTF8();
        rClassLoader.println("static const " + string3 + " " + this.getCodingName() + "= {");
        rClassLoader.println("\t{");
        rClassLoader.println("\t\t(ClassFileT*) &" + this.getOwner().getCodingName() + ",");
        rClassLoader.println("\t\t0x" + C.toHex4(this.getAccessFlags()) + ",");
        rClassLoader.println("\t\t" + this.getArgSize() + ",");
        rClassLoader.println("\t  #if (METHOD_TABLE_ENABLE == 1)");
        rClassLoader.println("\t\t" + this.getMethodIndex() + ",");
        rClassLoader.println("\t  #endif /* (METHOD_TABLE_ENABLE == 1) */");
        rClassLoader.println("\t\t{");
        if (C.KEEP_PACKAGE_PRIVATE_STATIC_METHODNAME || this.isClinit() || !this.isStatic() || !this.isPrivate() && !this.isPackagePrivate()) {
            rClassLoader.println("\t\t\t(Utf8InfoT*) &" + totalUTF8.findUTF8(this.getName()) + ",");
        } else {
            rClassLoader.println("\t\t\tNULL,");
        }
        rClassLoader.println("\t\t\t(Utf8InfoT*) &" + totalUTF8.findUTF8(this.getDescriptor()));
        rClassLoader.println("\t\t}");
        rClassLoader.println("\t},");
        rClassLoader.println("\t" + this.max_stack + ", " + this.max_locals + ",");
        rClassLoader.println("\t" + n2 + ", " + n3 + ",");
        rClassLoader.println("\t" + n + ",");
        if (C.METHOD_REDUCTION && this.code.length == 0) {
            rClassLoader.println("\tNULL,");
        } else {
            rClassLoader.println("\t" + this.getCodingName() + "_code,");
        }
        rClassLoader.println("  #if (JDWP == 1)");
        rClassLoader.println("\t" + this.code.length + ",");
        rClassLoader.println("\t" + this.bcodeX.getCvtTblSize() + ",");
        rClassLoader.println("\t" + n4 + ",");
        rClassLoader.println("\t" + this.bcodeX.getCvtTblName() + ",");
        rClassLoader.println("\t" + string2 + ",");
        rClassLoader.println("  #endif");
        rClassLoader.println("\t" + string + ",");
        if (n3 != 0) {
            rClassLoader.println("\t{");
            this.exception_handler.outputClassData();
            rClassLoader.println("\t}");
        }
        rClassLoader.println("};");
    }

    public void verifyer() {
        this.bcodeX = new ByteCodes(this, this.code);
        if (this.variable_table != null) {
            this.variable_table.registUTF8(this.getOwner().getClassLoader().getTotalUTF8(), this.getOwner().getConstantPools());
        }
    }

    @Override
    public void outputPrototype() {
        RClassLoader rClassLoader = this.getOwner().getClassLoader();
        int n = 0;
        if (this.exception_handler != null) {
            n = this.exception_handler.length();
        }
        String string = ("MethodDefBytecodeR" + n + "T").intern();
        String string2 = ("_MethodDefBytecodeR" + n).intern();
        Hashtable<String, String> hashtable = rClassLoader.get_bmethod_hash();
        if (hashtable.get(string) == null) {
            rClassLoader.println("\ttypedef struct " + string2 + " {");
            rClassLoader.println("\t\tMethodInfoT header;");
            rClassLoader.println("\t\t");
            rClassLoader.println("\t\tnano_u2 max_stack;");
            rClassLoader.println("\t\tnano_u2 max_locals;");
            rClassLoader.println("\t\tnano_u2 line_number_table_length;");
            rClassLoader.println("\t\tnano_u2 exception_handler_length;");
            rClassLoader.println("\t\tnano_u2 code_length;");
            rClassLoader.println("\t\t");
            rClassLoader.println("\t  #if (JDWP == 1)");
            rClassLoader.println("\t\tnano_u1 *code;");
            rClassLoader.println("\t  \tnano_u2 orinal_code_length;");
            rClassLoader.println("\t\tnano_u2 addr_cvt_tbl_size;");
            rClassLoader.println("\t\tnano_u2 variable_tbl_size;");
            rClassLoader.println("\t\tconst AddrCvtTblT *addr_tbl;");
            rClassLoader.println("\t\tconst VariableTblT *var_tbl;");
            rClassLoader.println("\t  #else");
            rClassLoader.println("\t\tconst nano_u1 *code;");
            rClassLoader.println("\t  #endif /* JDWP */");
            rClassLoader.println("\t\tconst LineNumberT *line_numbers;");
            if (n != 0) {
                rClassLoader.println("\t\tconst ExceptionHandlerT exception_handlers[" + n + "];");
            }
            rClassLoader.println("\t} " + string + ";");
            hashtable.put(string, string);
        }
        rClassLoader.println(romizer.static_prototype + "const " + string + " " + this.getCodingName() + ";");
    }

    public void outputCAP(MyDataOutputStream myDataOutputStream) throws IOException {
        myDataOutputStream.writeVU(this.max_stack);
        myDataOutputStream.writeVU(this.max_locals);
        this.bcodeX.fix();
        myDataOutputStream.writeVU(this.bcodeX.getCodeLength());
        boolean bl = false;
        if (this.line_number_table != null && this.line_number_table.length() != 0) {
            myDataOutputStream.writeVU(this.line_number_table.length());
            bl = true;
        } else {
            myDataOutputStream.writeVU(0);
        }
        boolean bl2 = false;
        if (this.exception_handler != null && this.exception_handler.length() != 0) {
            myDataOutputStream.writeVU(this.exception_handler.length());
            bl2 = true;
        } else {
            myDataOutputStream.writeVU(0);
        }
        myDataOutputStream.writeVU(this.code.length);
        boolean bl3 = false;
        if (this.variable_table != null && this.variable_table.length() != 0) {
            myDataOutputStream.writeVU(this.variable_table.length());
            bl3 = true;
        } else {
            myDataOutputStream.writeVU(0);
        }
        int n = this.bcodeX.getCvtTblSize();
        myDataOutputStream.writeVU(n);
        this.bcodeX.outputCAP(myDataOutputStream);
        if (bl) {
            this.line_number_table.outputCAP(myDataOutputStream);
        }
        if (bl2) {
            this.exception_handler.outputCAP(myDataOutputStream);
        }
        if (bl3) {
            this.variable_table.outputCAP(this.getOwner().getClassLoader().getTotalUTF8(), myDataOutputStream);
        }
        if (n != 0) {
            this.bcodeX.outputAddrCvtTable(myDataOutputStream);
        }
    }

    @Override
    public void aaMarkMethod() {
        if (!this.aaMethodMarked_) {
            super.aaMarkMethod();
            this.bcodeX.aaMarkByteCodes();
        }
    }

    @Override
    public void aaMarkMethod(boolean bl) {
        boolean bl2 = this.aaMethodMarked_;
        super.aaMarkMethod(bl);
        if (!bl2) {
            this.bcodeX.aaMarkByteCodes();
        }
    }
}

