/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.FieldDef;
import avm.romize.Outputable;
import avm.romize.RClass;
import avm.romize.RUTF8;
import avm.romize.constantpool.ConstantPoolElement;

public abstract class Member
extends ConstantPoolElement
implements Outputable {
    private int access_flags;
    private RUTF8 name;
    private RUTF8 descriptor;
    private RClass this_class;
    private int typeID;

    Member(int n, RUTF8 rUTF8, RUTF8 rUTF82, RClass rClass) {
        this.access_flags = n;
        this.name = rUTF8;
        this.descriptor = rUTF82;
        this.this_class = rClass;
    }

    Member(Member member, RClass rClass) {
        this.access_flags = member.access_flags;
        this.name = member.name;
        this.descriptor = member.descriptor;
        this.this_class = rClass;
    }

    public final void setTypeID(int n) {
        this.typeID = n;
    }

    public final int getAccessFlags() {
        return this.access_flags;
    }

    public final RUTF8 getName() {
        return this.name;
    }

    public final RUTF8 getDescriptor() {
        return this.descriptor;
    }

    public final RClass getOwner() {
        return this.this_class;
    }

    public final int getTypeID() {
        return this.typeID;
    }

    public final String toString() {
        if (this instanceof FieldDef) {
            return this.getClass().getName() + "<\"" + this.this_class.getAbsClassNameString() + "#" + this.name.convertToString() + " - " + this.descriptor.convertToString() + "\">";
        }
        return this.getClass().getName() + "<\"" + this.this_class.getAbsClassNameString() + "#" + this.name.convertToString() + this.descriptor.convertToString() + "\">";
    }

    public final String getAbsString() {
        if (this instanceof FieldDef) {
            return this.this_class.getAbsClassNameString() + "#" + this.name.convertToString() + " - " + this.descriptor.convertToString();
        }
        return this.this_class.getAbsClassNameString() + "#" + this.name.convertToString() + this.descriptor.convertToString();
    }

    public final boolean isFinal() {
        return (this.access_flags & 0x10) != 0;
    }

    public final boolean isPublic() {
        return (this.access_flags & 1) != 0;
    }

    public final boolean isProtected() {
        return (this.access_flags & 4) != 0;
    }

    public final boolean isPrivate() {
        return (this.access_flags & 2) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.access_flags & 7) == 0;
    }

    public final boolean isStatic() {
        return (this.access_flags & 8) != 0;
    }

    public final boolean isSameNameAndDesc(Member member) {
        return this.name.equals(member.name) && this.descriptor.equals(member.descriptor);
    }

    public final String getArrayElementClassName() {
        String string = this.descriptor.convertToString();
        if (string.length() > 0 && string.charAt(0) == '[') {
            int n = 0;
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (n <= string.length() - 1 && string.charAt(n) == 'L' && string.endsWith(";")) {
                return string.substring(n + 1, string.length() - 1);
            }
        }
        return null;
    }

    @Override
    public abstract String getCodingName();

    public abstract void outputPrototype();
}

