/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.CodeAttribute;
import avm.romize.MyDataOutputStream;
import avm.romize.RClassLoader;
import avm.romize.RUTF8;
import avm.romize.TotalUTF8;
import avm.romize.constantpool.ConstantPools;
import java.io.IOException;

public final class CodeVariableTable
extends CodeAttribute {
    private int[] start_pc;
    private int[] length;
    private int[] name_index;
    private int[] descriptor_index;
    private int[] index;
    RUTF8[] name;
    RUTF8[] desc;

    CodeVariableTable(int n) {
        this.start_pc = new int[n];
        this.length = new int[n];
        this.name_index = new int[n];
        this.descriptor_index = new int[n];
        this.index = new int[n];
    }

    void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.start_pc[n] = n2;
        this.length[n] = n3;
        this.name_index[n] = n4;
        this.descriptor_index[n] = n5;
        this.index[n] = n6;
    }

    void registUTF8(TotalUTF8 totalUTF8, ConstantPools constantPools) {
        this.name = new RUTF8[this.start_pc.length];
        this.desc = new RUTF8[this.start_pc.length];
        for (int i = 0; i < this.start_pc.length; ++i) {
            int n = this.name_index[i];
            RUTF8 rUTF8 = n == 0 ? new RUTF8("") : constantPools.get_utf8string(n);
            totalUTF8.addElementByCodeVariableTable(rUTF8);
            this.name[i] = rUTF8;
            int n2 = this.descriptor_index[i];
            rUTF8 = n2 == 0 ? new RUTF8("") : constantPools.get_utf8string(n2);
            totalUTF8.addElementByCodeVariableTable(rUTF8);
            this.desc[i] = rUTF8;
        }
    }

    public int length() {
        return this.start_pc.length;
    }

    @Override
    public void outputClassData() {
        RClassLoader rClassLoader = this.getClassLoader();
        TotalUTF8 totalUTF8 = rClassLoader.getTotalUTF8();
        rClassLoader.println("#if (JDWP == 1)");
        rClassLoader.println("static const VariableTblT " + this.getCodingName() + "[] = {");
        for (int i = 0; i < this.length(); ++i) {
            rClassLoader.println("\t{ " + this.start_pc[i] + ", " + this.length[i] + ", " + this.index[i] + ", " + "(Utf8InfoT*) &" + totalUTF8.findUTF8(this.name[i]) + ", " + "(Utf8InfoT*) &" + totalUTF8.findUTF8(this.desc[i]) + "},");
        }
        rClassLoader.println("};");
        rClassLoader.println("#endif /* (JDWP == 1) */");
    }

    @Override
    public String getCodingName() {
        return this.getMethod().getCodingName() + "_VarTable";
    }

    public void outputCAP(TotalUTF8 totalUTF8, MyDataOutputStream myDataOutputStream) throws IOException {
        for (int i = 0; i < this.length(); ++i) {
            myDataOutputStream.writeVU(this.start_pc[i]);
            myDataOutputStream.writeVU(this.length[i]);
            myDataOutputStream.writeVU(this.index[i]);
            myDataOutputStream.writeVU(totalUTF8.getUTF8ID(this.name[i]));
            myDataOutputStream.writeVU(totalUTF8.getUTF8ID(this.desc[i]));
        }
    }
}

