/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.CodeAttribute;
import avm.romize.MyDataOutputStream;
import avm.romize.RClassLoader;
import java.io.IOException;

public final class CodeLineNumberTable
extends CodeAttribute {
    private int[] start_pc;
    private int[] line_number;

    public CodeLineNumberTable(int n) {
        this.start_pc = new int[n];
        this.line_number = new int[n];
    }

    void set(int n, int n2, int n3) {
        this.start_pc[n] = n2;
        this.line_number[n] = n3;
    }

    public int length() {
        return this.start_pc.length;
    }

    public int getStartPC(int n) {
        return this.start_pc[n];
    }

    public int getLineNumber(int n) {
        return this.line_number[n];
    }

    @Override
    public void outputClassData() {
        RClassLoader rClassLoader = this.getClassLoader();
        rClassLoader.println("static const LineNumberT " + this.getMethod().getCodingName() + "_LineNumbers[] = {");
        for (int i = 0; i < this.length(); ++i) {
            rClassLoader.println("\t{ " + this.oldAddrToNewAddr(this.getStartPC(i)) + ", " + this.getLineNumber(i) + " },");
        }
        rClassLoader.println("};");
    }

    @Override
    public String getCodingName() {
        return this.getMethod().getCodingName() + "_LineNumbers";
    }

    public void outputCAP(MyDataOutputStream myDataOutputStream) throws IOException {
        for (int i = 0; i < this.length(); ++i) {
            myDataOutputStream.writeVU(this.oldAddrToNewAddr(this.getStartPC(i)));
            myDataOutputStream.writeVU(this.getLineNumber(i));
        }
    }
}

