/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

import avm.romize.CodeAttribute;
import avm.romize.MyDataOutputStream;
import avm.romize.RClass;
import avm.romize.RClassLoader;
import avm.romize.TotalConstantPool;
import avm.romize.constantpool.ConstantPools;
import java.io.IOException;

public final class CodeExceptionHandler
extends CodeAttribute {
    private int[] start_pc;
    private int[] end_pc;
    private int[] handler_pc;
    private int[] catch_type;
    private RClass[] classes;

    public CodeExceptionHandler(int n) {
        this.start_pc = new int[n];
        this.end_pc = new int[n];
        this.handler_pc = new int[n];
        this.catch_type = new int[n];
        this.classes = new RClass[n];
    }

    public void set(int n, int n2, int n3, int n4, int n5) {
        this.start_pc[n] = n2;
        this.end_pc[n] = n3;
        this.handler_pc[n] = n4;
        this.catch_type[n] = n5;
    }

    public int length() {
        return this.start_pc.length;
    }

    public int getCatchType(int n) {
        return this.catch_type[n];
    }

    public void setResolvedCatchType(int n, RClass rClass) {
        this.classes[n] = rClass;
        if (rClass != null) {
            this.getTotalConstantPool().addElementZ(23, rClass);
        }
    }

    @Override
    public void outputClassData() {
        RClassLoader rClassLoader = this.getClassLoader();
        ConstantPools constantPools = this.getConstantPools();
        TotalConstantPool totalConstantPool = this.getTotalConstantPool();
        for (int i = 0; i < this.length(); ++i) {
            rClassLoader.println("\t{ " + this.oldAddrToNewAddr(this.start_pc[i]) + ", " + this.oldAddrToNewAddr(this.end_pc[i]) + ", " + this.oldAddrToNewAddr(this.handler_pc[i]) + ", " + totalConstantPool.findGlobalIndex(constantPools, this.catch_type[i]) + "},");
        }
    }

    @Override
    public String getCodingName() {
        return this.getMethod().getCodingName() + "_ExpHandler";
    }

    public void outputCAP(MyDataOutputStream myDataOutputStream) throws IOException {
        for (int i = 0; i < this.length(); ++i) {
            myDataOutputStream.writeVU(this.oldAddrToNewAddr(this.start_pc[i]));
            myDataOutputStream.writeVU(this.oldAddrToNewAddr(this.end_pc[i]));
            myDataOutputStream.writeVU(this.oldAddrToNewAddr(this.handler_pc[i]));
            RClass rClass = this.classes[i];
            if (rClass == null) {
                myDataOutputStream.writeVU(0);
                continue;
            }
            ConstantPools constantPools = this.getConstantPools();
            TotalConstantPool totalConstantPool = this.getTotalConstantPool();
            myDataOutputStream.writeVU(totalConstantPool.findGlobalIndex(constantPools, this.catch_type[i]));
        }
    }

    public void removeEntry(int n) {
        int n2 = this.length();
        int n3 = n2 - 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        RClass[] rClassArray = new RClass[n3];
        if (n > 0) {
            System.arraycopy(this.start_pc, 0, nArray, 0, n);
            System.arraycopy(this.end_pc, 0, nArray2, 0, n);
            System.arraycopy(this.handler_pc, 0, nArray3, 0, n);
            System.arraycopy(this.catch_type, 0, nArray4, 0, n);
            System.arraycopy(this.classes, 0, rClassArray, 0, n);
        }
        if (n < n3) {
            int n4 = n3 - n;
            System.arraycopy(this.start_pc, n + 1, nArray, n, n4);
            System.arraycopy(this.end_pc, n + 1, nArray2, n, n4);
            System.arraycopy(this.handler_pc, n + 1, nArray3, n, n4);
            System.arraycopy(this.catch_type, n + 1, nArray4, n, n4);
            System.arraycopy(this.classes, n + 1, rClassArray, n, n4);
        }
        this.start_pc = nArray;
        this.end_pc = nArray2;
        this.handler_pc = nArray3;
        this.catch_type = nArray4;
        this.classes = rClassArray;
    }
}

