/*
 * Decompiled with CFR 0.152.
 */
package avm.romize;

public final class Bytep {
    private byte[] array;
    private int index;

    public Bytep(Bytep bytep) {
        this.array = bytep.array;
        this.index = bytep.index;
    }

    public Bytep(byte[] byArray) {
        this.array = byArray;
        this.index = 0;
    }

    public Bytep(byte[] byArray, int n) {
        this.array = byArray;
        this.index = n;
    }

    public int get_u1() {
        int n = this.array[this.index] & 0xFF;
        ++this.index;
        return n;
    }

    public int get_u2() {
        return this.get_u1() << 8 | this.get_u1();
    }

    public int get_u4() {
        return this.get_u2() << 16 | this.get_u2();
    }

    public int get_index() {
        return this.index;
    }

    public void skip(int n) {
        this.index += n;
    }

    void check_length(int n) {
        if (this.array.length < this.index + n) {
            throw new RuntimeException("bad classfile format.");
        }
    }

    void check_eof() {
        if (this.array.length != this.index) {
            throw new RuntimeException("bad classfile format.");
        }
    }

    byte[] get_bytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.array, this.index, byArray, 0, n);
        this.index += n;
        return byArray;
    }

    public int[] getInts(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.get_u4();
        }
        return nArray;
    }
}

